/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.greengrass.model.Function;
import software.amazon.awssdk.services.greengrass.model.ListOfFunctionCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateFunctionDefinitionVersionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateFunctionDefinitionVersionRequest> {
    private final String amznClientToken;
    private final String functionDefinitionId;
    private final List<Function> functions;

    private CreateFunctionDefinitionVersionRequest(BuilderImpl builder) {
        this.amznClientToken = builder.amznClientToken;
        this.functionDefinitionId = builder.functionDefinitionId;
        this.functions = builder.functions;
    }

    public String amznClientToken() {
        return this.amznClientToken;
    }

    public String functionDefinitionId() {
        return this.functionDefinitionId;
    }

    public List<Function> functions() {
        return this.functions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.amznClientToken() == null ? 0 : this.amznClientToken().hashCode());
        hashCode = 31 * hashCode + (this.functionDefinitionId() == null ? 0 : this.functionDefinitionId().hashCode());
        hashCode = 31 * hashCode + (this.functions() == null ? 0 : this.functions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFunctionDefinitionVersionRequest)) {
            return false;
        }
        CreateFunctionDefinitionVersionRequest other = (CreateFunctionDefinitionVersionRequest)((Object)obj);
        if (other.amznClientToken() == null ^ this.amznClientToken() == null) {
            return false;
        }
        if (other.amznClientToken() != null && !other.amznClientToken().equals(this.amznClientToken())) {
            return false;
        }
        if (other.functionDefinitionId() == null ^ this.functionDefinitionId() == null) {
            return false;
        }
        if (other.functionDefinitionId() != null && !other.functionDefinitionId().equals(this.functionDefinitionId())) {
            return false;
        }
        if (other.functions() == null ^ this.functions() == null) {
            return false;
        }
        return other.functions() == null || other.functions().equals(this.functions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.amznClientToken() != null) {
            sb.append("AmznClientToken: ").append(this.amznClientToken()).append(",");
        }
        if (this.functionDefinitionId() != null) {
            sb.append("FunctionDefinitionId: ").append(this.functionDefinitionId()).append(",");
        }
        if (this.functions() != null) {
            sb.append("Functions: ").append(this.functions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String amznClientToken;
        private String functionDefinitionId;
        private List<Function> functions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFunctionDefinitionVersionRequest model) {
            this.setAmznClientToken(model.amznClientToken);
            this.setFunctionDefinitionId(model.functionDefinitionId);
            this.setFunctions(model.functions);
        }

        public final String getAmznClientToken() {
            return this.amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final String getFunctionDefinitionId() {
            return this.functionDefinitionId;
        }

        @Override
        public final Builder functionDefinitionId(String functionDefinitionId) {
            this.functionDefinitionId = functionDefinitionId;
            return this;
        }

        public final void setFunctionDefinitionId(String functionDefinitionId) {
            this.functionDefinitionId = functionDefinitionId;
        }

        public final Collection<Function> getFunctions() {
            return this.functions;
        }

        @Override
        public final Builder functions(Collection<Function> functions) {
            this.functions = ListOfFunctionCopier.copy(functions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functions(Function ... functions) {
            this.functions(Arrays.asList(functions));
            return this;
        }

        public final void setFunctions(Collection<Function> functions) {
            this.functions = ListOfFunctionCopier.copy(functions);
        }

        @SafeVarargs
        public final void setFunctions(Function ... functions) {
            this.functions(Arrays.asList(functions));
        }

        public CreateFunctionDefinitionVersionRequest build() {
            return new CreateFunctionDefinitionVersionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateFunctionDefinitionVersionRequest> {
        public Builder amznClientToken(String var1);

        public Builder functionDefinitionId(String var1);

        public Builder functions(Collection<Function> var1);

        public Builder functions(Function ... var1);
    }
}

