/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.greengrass.model.Device;
import software.amazon.awssdk.services.greengrass.model.ListOfDeviceCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDeviceDefinitionVersionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateDeviceDefinitionVersionRequest> {
    private final String amznClientToken;
    private final String deviceDefinitionId;
    private final List<Device> devices;

    private CreateDeviceDefinitionVersionRequest(BuilderImpl builder) {
        this.amznClientToken = builder.amznClientToken;
        this.deviceDefinitionId = builder.deviceDefinitionId;
        this.devices = builder.devices;
    }

    public String amznClientToken() {
        return this.amznClientToken;
    }

    public String deviceDefinitionId() {
        return this.deviceDefinitionId;
    }

    public List<Device> devices() {
        return this.devices;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.amznClientToken() == null ? 0 : this.amznClientToken().hashCode());
        hashCode = 31 * hashCode + (this.deviceDefinitionId() == null ? 0 : this.deviceDefinitionId().hashCode());
        hashCode = 31 * hashCode + (this.devices() == null ? 0 : this.devices().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeviceDefinitionVersionRequest)) {
            return false;
        }
        CreateDeviceDefinitionVersionRequest other = (CreateDeviceDefinitionVersionRequest)((Object)obj);
        if (other.amznClientToken() == null ^ this.amznClientToken() == null) {
            return false;
        }
        if (other.amznClientToken() != null && !other.amznClientToken().equals(this.amznClientToken())) {
            return false;
        }
        if (other.deviceDefinitionId() == null ^ this.deviceDefinitionId() == null) {
            return false;
        }
        if (other.deviceDefinitionId() != null && !other.deviceDefinitionId().equals(this.deviceDefinitionId())) {
            return false;
        }
        if (other.devices() == null ^ this.devices() == null) {
            return false;
        }
        return other.devices() == null || other.devices().equals(this.devices());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.amznClientToken() != null) {
            sb.append("AmznClientToken: ").append(this.amznClientToken()).append(",");
        }
        if (this.deviceDefinitionId() != null) {
            sb.append("DeviceDefinitionId: ").append(this.deviceDefinitionId()).append(",");
        }
        if (this.devices() != null) {
            sb.append("Devices: ").append(this.devices()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String amznClientToken;
        private String deviceDefinitionId;
        private List<Device> devices;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeviceDefinitionVersionRequest model) {
            this.setAmznClientToken(model.amznClientToken);
            this.setDeviceDefinitionId(model.deviceDefinitionId);
            this.setDevices(model.devices);
        }

        public final String getAmznClientToken() {
            return this.amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final String getDeviceDefinitionId() {
            return this.deviceDefinitionId;
        }

        @Override
        public final Builder deviceDefinitionId(String deviceDefinitionId) {
            this.deviceDefinitionId = deviceDefinitionId;
            return this;
        }

        public final void setDeviceDefinitionId(String deviceDefinitionId) {
            this.deviceDefinitionId = deviceDefinitionId;
        }

        public final Collection<Device> getDevices() {
            return this.devices;
        }

        @Override
        public final Builder devices(Collection<Device> devices) {
            this.devices = ListOfDeviceCopier.copy(devices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(Device ... devices) {
            this.devices(Arrays.asList(devices));
            return this;
        }

        public final void setDevices(Collection<Device> devices) {
            this.devices = ListOfDeviceCopier.copy(devices);
        }

        @SafeVarargs
        public final void setDevices(Device ... devices) {
            this.devices(Arrays.asList(devices));
        }

        public CreateDeviceDefinitionVersionRequest build() {
            return new CreateDeviceDefinitionVersionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateDeviceDefinitionVersionRequest> {
        public Builder amznClientToken(String var1);

        public Builder deviceDefinitionId(String var1);

        public Builder devices(Collection<Device> var1);

        public Builder devices(Device ... var1);
    }
}

