/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.greengrass.model.ErrorDetail;
import software.amazon.awssdk.services.greengrass.model.ErrorDetailsCopier;
import software.amazon.awssdk.services.greengrass.model.GreengrassException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BadRequestException
extends GreengrassException
implements ToCopyableBuilder<Builder, BadRequestException> {
    private final List<ErrorDetail> errorDetails;

    private BadRequestException(BuilderImpl builder) {
        super(builder.message);
        this.errorDetails = builder.errorDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public List<ErrorDetail> errorDetails() {
        return this.errorDetails;
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ErrorDetail> errorDetails;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(BadRequestException model) {
            this.setErrorDetails(model.errorDetails);
            this.message = model.getMessage();
        }

        public final Collection<ErrorDetail> getErrorDetails() {
            return this.errorDetails;
        }

        @Override
        public final Builder errorDetails(Collection<ErrorDetail> errorDetails) {
            this.errorDetails = ErrorDetailsCopier.copy(errorDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(ErrorDetail ... errorDetails) {
            this.errorDetails(Arrays.asList(errorDetails));
            return this;
        }

        @JsonProperty(value="ErrorDetails")
        public final void setErrorDetails(Collection<ErrorDetail> errorDetails) {
            this.errorDetails = ErrorDetailsCopier.copy(errorDetails);
        }

        @SafeVarargs
        public final void setErrorDetails(ErrorDetail ... errorDetails) {
            this.errorDetails(Arrays.asList(errorDetails));
        }

        public String getMessage() {
            return this.message;
        }

        public String message() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public BadRequestException build() {
            return new BadRequestException(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BadRequestException> {
        public Builder errorDetails(Collection<ErrorDetail> var1);

        public Builder errorDetails(ErrorDetail ... var1);

        public Builder message(String var1);
    }
}

