/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.MapValueCopier;
import software.amazon.awssdk.services.glue.model.StringListCopier;
import software.amazon.awssdk.services.glue.model.WorkerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDevEndpointResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, CreateDevEndpointResponse> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDevEndpointResponse.getter(CreateDevEndpointResponse::endpointName)).setter(CreateDevEndpointResponse.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDevEndpointResponse.getter(CreateDevEndpointResponse::status)).setter(CreateDevEndpointResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateDevEndpointResponse.getter(CreateDevEndpointResponse::securityGroupIds)).setter(CreateDevEndpointResponse.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDevEndpointResponse.getter(CreateDevEndpointResponse::subnetId)).setter(CreateDevEndpointResponse.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDevEndpointResponse.getter(CreateDevEndpointResponse::roleArn)).setter(CreateDevEndpointResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> YARN_ENDPOINT_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDevEndpointResponse.getter(CreateDevEndpointResponse::yarnEndpointAddress)).setter(CreateDevEndpointResponse.setter(Builder::yarnEndpointAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("YarnEndpointAddress").build()}).build();
    private static final SdkField<Integer> ZEPPELIN_REMOTE_SPARK_INTERPRETER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateDevEndpointResponse.getter(CreateDevEndpointResponse::zeppelinRemoteSparkInterpreterPort)).setter(CreateDevEndpointResponse.setter(Builder::zeppelinRemoteSparkInterpreterPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZeppelinRemoteSparkInterpreterPort").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateDevEndpointResponse.getter(CreateDevEndpointResponse::numberOfNodes)).setter(CreateDevEndpointResponse.setter(Builder::numberOfNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNodes").build()}).build();
    private static final SdkField<String> WORKER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDevEndpointResponse.getter(CreateDevEndpointResponse::workerTypeAsString)).setter(CreateDevEndpointResponse.setter(Builder::workerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerType").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateDevEndpointResponse.getter(CreateDevEndpointResponse::numberOfWorkers)).setter(CreateDevEndpointResponse.setter(Builder::numberOfWorkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDevEndpointResponse.getter(CreateDevEndpointResponse::availabilityZone)).setter(CreateDevEndpointResponse.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDevEndpointResponse.getter(CreateDevEndpointResponse::vpcId)).setter(CreateDevEndpointResponse.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<String> EXTRA_PYTHON_LIBS_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDevEndpointResponse.getter(CreateDevEndpointResponse::extraPythonLibsS3Path)).setter(CreateDevEndpointResponse.setter(Builder::extraPythonLibsS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtraPythonLibsS3Path").build()}).build();
    private static final SdkField<String> EXTRA_JARS_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDevEndpointResponse.getter(CreateDevEndpointResponse::extraJarsS3Path)).setter(CreateDevEndpointResponse.setter(Builder::extraJarsS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtraJarsS3Path").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDevEndpointResponse.getter(CreateDevEndpointResponse::failureReason)).setter(CreateDevEndpointResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDevEndpointResponse.getter(CreateDevEndpointResponse::securityConfiguration)).setter(CreateDevEndpointResponse.setter(Builder::securityConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CreateDevEndpointResponse.getter(CreateDevEndpointResponse::createdTimestamp)).setter(CreateDevEndpointResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<Map<String, String>> ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateDevEndpointResponse.getter(CreateDevEndpointResponse::arguments)).setter(CreateDevEndpointResponse.setter(Builder::arguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arguments").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD, STATUS_FIELD, SECURITY_GROUP_IDS_FIELD, SUBNET_ID_FIELD, ROLE_ARN_FIELD, YARN_ENDPOINT_ADDRESS_FIELD, ZEPPELIN_REMOTE_SPARK_INTERPRETER_PORT_FIELD, NUMBER_OF_NODES_FIELD, WORKER_TYPE_FIELD, NUMBER_OF_WORKERS_FIELD, AVAILABILITY_ZONE_FIELD, VPC_ID_FIELD, EXTRA_PYTHON_LIBS_S3_PATH_FIELD, EXTRA_JARS_S3_PATH_FIELD, FAILURE_REASON_FIELD, SECURITY_CONFIGURATION_FIELD, CREATED_TIMESTAMP_FIELD, ARGUMENTS_FIELD));
    private final String endpointName;
    private final String status;
    private final List<String> securityGroupIds;
    private final String subnetId;
    private final String roleArn;
    private final String yarnEndpointAddress;
    private final Integer zeppelinRemoteSparkInterpreterPort;
    private final Integer numberOfNodes;
    private final String workerType;
    private final Integer numberOfWorkers;
    private final String availabilityZone;
    private final String vpcId;
    private final String extraPythonLibsS3Path;
    private final String extraJarsS3Path;
    private final String failureReason;
    private final String securityConfiguration;
    private final Instant createdTimestamp;
    private final Map<String, String> arguments;

    private CreateDevEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.status = builder.status;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetId = builder.subnetId;
        this.roleArn = builder.roleArn;
        this.yarnEndpointAddress = builder.yarnEndpointAddress;
        this.zeppelinRemoteSparkInterpreterPort = builder.zeppelinRemoteSparkInterpreterPort;
        this.numberOfNodes = builder.numberOfNodes;
        this.workerType = builder.workerType;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.availabilityZone = builder.availabilityZone;
        this.vpcId = builder.vpcId;
        this.extraPythonLibsS3Path = builder.extraPythonLibsS3Path;
        this.extraJarsS3Path = builder.extraJarsS3Path;
        this.failureReason = builder.failureReason;
        this.securityConfiguration = builder.securityConfiguration;
        this.createdTimestamp = builder.createdTimestamp;
        this.arguments = builder.arguments;
    }

    public String endpointName() {
        return this.endpointName;
    }

    public String status() {
        return this.status;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String yarnEndpointAddress() {
        return this.yarnEndpointAddress;
    }

    public Integer zeppelinRemoteSparkInterpreterPort() {
        return this.zeppelinRemoteSparkInterpreterPort;
    }

    public Integer numberOfNodes() {
        return this.numberOfNodes;
    }

    public WorkerType workerType() {
        return WorkerType.fromValue(this.workerType);
    }

    public String workerTypeAsString() {
        return this.workerType;
    }

    public Integer numberOfWorkers() {
        return this.numberOfWorkers;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String extraPythonLibsS3Path() {
        return this.extraPythonLibsS3Path;
    }

    public String extraJarsS3Path() {
        return this.extraJarsS3Path;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public String securityConfiguration() {
        return this.securityConfiguration;
    }

    public Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Map<String, String> arguments() {
        return this.arguments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.yarnEndpointAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.zeppelinRemoteSparkInterpreterPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.extraPythonLibsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.extraJarsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.arguments());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDevEndpointResponse)) {
            return false;
        }
        CreateDevEndpointResponse other = (CreateDevEndpointResponse)((Object)obj);
        return Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.yarnEndpointAddress(), other.yarnEndpointAddress()) && Objects.equals(this.zeppelinRemoteSparkInterpreterPort(), other.zeppelinRemoteSparkInterpreterPort()) && Objects.equals(this.numberOfNodes(), other.numberOfNodes()) && Objects.equals(this.workerTypeAsString(), other.workerTypeAsString()) && Objects.equals(this.numberOfWorkers(), other.numberOfWorkers()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.extraPythonLibsS3Path(), other.extraPythonLibsS3Path()) && Objects.equals(this.extraJarsS3Path(), other.extraJarsS3Path()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.securityConfiguration(), other.securityConfiguration()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.arguments(), other.arguments());
    }

    public String toString() {
        return ToString.builder((String)"CreateDevEndpointResponse").add("EndpointName", (Object)this.endpointName()).add("Status", (Object)this.status()).add("SecurityGroupIds", this.securityGroupIds()).add("SubnetId", (Object)this.subnetId()).add("RoleArn", (Object)this.roleArn()).add("YarnEndpointAddress", (Object)this.yarnEndpointAddress()).add("ZeppelinRemoteSparkInterpreterPort", (Object)this.zeppelinRemoteSparkInterpreterPort()).add("NumberOfNodes", (Object)this.numberOfNodes()).add("WorkerType", (Object)this.workerTypeAsString()).add("NumberOfWorkers", (Object)this.numberOfWorkers()).add("AvailabilityZone", (Object)this.availabilityZone()).add("VpcId", (Object)this.vpcId()).add("ExtraPythonLibsS3Path", (Object)this.extraPythonLibsS3Path()).add("ExtraJarsS3Path", (Object)this.extraJarsS3Path()).add("FailureReason", (Object)this.failureReason()).add("SecurityConfiguration", (Object)this.securityConfiguration()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("Arguments", this.arguments()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "YarnEndpointAddress": {
                return Optional.ofNullable(clazz.cast(this.yarnEndpointAddress()));
            }
            case "ZeppelinRemoteSparkInterpreterPort": {
                return Optional.ofNullable(clazz.cast(this.zeppelinRemoteSparkInterpreterPort()));
            }
            case "NumberOfNodes": {
                return Optional.ofNullable(clazz.cast(this.numberOfNodes()));
            }
            case "WorkerType": {
                return Optional.ofNullable(clazz.cast(this.workerTypeAsString()));
            }
            case "NumberOfWorkers": {
                return Optional.ofNullable(clazz.cast(this.numberOfWorkers()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "ExtraPythonLibsS3Path": {
                return Optional.ofNullable(clazz.cast(this.extraPythonLibsS3Path()));
            }
            case "ExtraJarsS3Path": {
                return Optional.ofNullable(clazz.cast(this.extraJarsS3Path()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "SecurityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.securityConfiguration()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "Arguments": {
                return Optional.ofNullable(clazz.cast(this.arguments()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDevEndpointResponse, T> g) {
        return obj -> g.apply((CreateDevEndpointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private String endpointName;
        private String status;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String subnetId;
        private String roleArn;
        private String yarnEndpointAddress;
        private Integer zeppelinRemoteSparkInterpreterPort;
        private Integer numberOfNodes;
        private String workerType;
        private Integer numberOfWorkers;
        private String availabilityZone;
        private String vpcId;
        private String extraPythonLibsS3Path;
        private String extraJarsS3Path;
        private String failureReason;
        private String securityConfiguration;
        private Instant createdTimestamp;
        private Map<String, String> arguments = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDevEndpointResponse model) {
            super(model);
            this.endpointName(model.endpointName);
            this.status(model.status);
            this.securityGroupIds(model.securityGroupIds);
            this.subnetId(model.subnetId);
            this.roleArn(model.roleArn);
            this.yarnEndpointAddress(model.yarnEndpointAddress);
            this.zeppelinRemoteSparkInterpreterPort(model.zeppelinRemoteSparkInterpreterPort);
            this.numberOfNodes(model.numberOfNodes);
            this.workerType(model.workerType);
            this.numberOfWorkers(model.numberOfWorkers);
            this.availabilityZone(model.availabilityZone);
            this.vpcId(model.vpcId);
            this.extraPythonLibsS3Path(model.extraPythonLibsS3Path);
            this.extraJarsS3Path(model.extraJarsS3Path);
            this.failureReason(model.failureReason);
            this.securityConfiguration(model.securityConfiguration);
            this.createdTimestamp(model.createdTimestamp);
            this.arguments(model.arguments);
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getYarnEndpointAddress() {
            return this.yarnEndpointAddress;
        }

        @Override
        public final Builder yarnEndpointAddress(String yarnEndpointAddress) {
            this.yarnEndpointAddress = yarnEndpointAddress;
            return this;
        }

        public final void setYarnEndpointAddress(String yarnEndpointAddress) {
            this.yarnEndpointAddress = yarnEndpointAddress;
        }

        public final Integer getZeppelinRemoteSparkInterpreterPort() {
            return this.zeppelinRemoteSparkInterpreterPort;
        }

        @Override
        public final Builder zeppelinRemoteSparkInterpreterPort(Integer zeppelinRemoteSparkInterpreterPort) {
            this.zeppelinRemoteSparkInterpreterPort = zeppelinRemoteSparkInterpreterPort;
            return this;
        }

        public final void setZeppelinRemoteSparkInterpreterPort(Integer zeppelinRemoteSparkInterpreterPort) {
            this.zeppelinRemoteSparkInterpreterPort = zeppelinRemoteSparkInterpreterPort;
        }

        public final Integer getNumberOfNodes() {
            return this.numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        public final String getWorkerTypeAsString() {
            return this.workerType;
        }

        @Override
        public final Builder workerType(String workerType) {
            this.workerType = workerType;
            return this;
        }

        @Override
        public final Builder workerType(WorkerType workerType) {
            this.workerType(workerType == null ? null : workerType.toString());
            return this;
        }

        public final void setWorkerType(String workerType) {
            this.workerType = workerType;
        }

        public final Integer getNumberOfWorkers() {
            return this.numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getExtraPythonLibsS3Path() {
            return this.extraPythonLibsS3Path;
        }

        @Override
        public final Builder extraPythonLibsS3Path(String extraPythonLibsS3Path) {
            this.extraPythonLibsS3Path = extraPythonLibsS3Path;
            return this;
        }

        public final void setExtraPythonLibsS3Path(String extraPythonLibsS3Path) {
            this.extraPythonLibsS3Path = extraPythonLibsS3Path;
        }

        public final String getExtraJarsS3Path() {
            return this.extraJarsS3Path;
        }

        @Override
        public final Builder extraJarsS3Path(String extraJarsS3Path) {
            this.extraJarsS3Path = extraJarsS3Path;
            return this;
        }

        public final void setExtraJarsS3Path(String extraJarsS3Path) {
            this.extraJarsS3Path = extraJarsS3Path;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Map<String, String> getArguments() {
            return this.arguments;
        }

        @Override
        public final Builder arguments(Map<String, String> arguments) {
            this.arguments = MapValueCopier.copy(arguments);
            return this;
        }

        public final void setArguments(Map<String, String> arguments) {
            this.arguments = MapValueCopier.copy(arguments);
        }

        @Override
        public CreateDevEndpointResponse build() {
            return new CreateDevEndpointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDevEndpointResponse> {
        public Builder endpointName(String var1);

        public Builder status(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder subnetId(String var1);

        public Builder roleArn(String var1);

        public Builder yarnEndpointAddress(String var1);

        public Builder zeppelinRemoteSparkInterpreterPort(Integer var1);

        public Builder numberOfNodes(Integer var1);

        public Builder workerType(String var1);

        public Builder workerType(WorkerType var1);

        public Builder numberOfWorkers(Integer var1);

        public Builder availabilityZone(String var1);

        public Builder vpcId(String var1);

        public Builder extraPythonLibsS3Path(String var1);

        public Builder extraJarsS3Path(String var1);

        public Builder failureReason(String var1);

        public Builder securityConfiguration(String var1);

        public Builder createdTimestamp(Instant var1);

        public Builder arguments(Map<String, String> var1);
    }
}

