/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.JobNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetJobsRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, BatchGetJobsRequest> {
    private static final SdkField<List<String>> JOB_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchGetJobsRequest.getter(BatchGetJobsRequest::jobNames)).setter(BatchGetJobsRequest.setter(Builder::jobNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAMES_FIELD));
    private final List<String> jobNames;

    private BatchGetJobsRequest(BuilderImpl builder) {
        super(builder);
        this.jobNames = builder.jobNames;
    }

    public List<String> jobNames() {
        return this.jobNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetJobsRequest)) {
            return false;
        }
        BatchGetJobsRequest other = (BatchGetJobsRequest)((Object)obj);
        return Objects.equals(this.jobNames(), other.jobNames());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetJobsRequest").add("JobNames", this.jobNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobNames": {
                return Optional.ofNullable(clazz.cast(this.jobNames()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetJobsRequest, T> g) {
        return obj -> g.apply((BatchGetJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private List<String> jobNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetJobsRequest model) {
            super(model);
            this.jobNames(model.jobNames);
        }

        public final Collection<String> getJobNames() {
            return this.jobNames;
        }

        @Override
        public final Builder jobNames(Collection<String> jobNames) {
            this.jobNames = JobNameListCopier.copy(jobNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobNames(String ... jobNames) {
            this.jobNames(Arrays.asList(jobNames));
            return this;
        }

        public final void setJobNames(Collection<String> jobNames) {
            this.jobNames = JobNameListCopier.copy(jobNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetJobsRequest build() {
            return new BatchGetJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetJobsRequest> {
        public Builder jobNames(Collection<String> var1);

        public Builder jobNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

