/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.model.GetJobBookmarksRequest;
import software.amazon.awssdk.services.glue.model.GetJobBookmarksResponse;
import software.amazon.awssdk.services.glue.model.JobBookmarkEntry;

public class GetJobBookmarksPublisher
implements SdkPublisher<GetJobBookmarksResponse> {
    private final GlueAsyncClient client;
    private final GetJobBookmarksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetJobBookmarksPublisher(GlueAsyncClient client, GetJobBookmarksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetJobBookmarksPublisher(GlueAsyncClient client, GetJobBookmarksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetJobBookmarksResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetJobBookmarksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<JobBookmarkEntry> jobBookmarkEntries() {
        Function<GetJobBookmarksResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobBookmarkEntries() != null) {
                return response.jobBookmarkEntries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetJobBookmarksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetJobBookmarksResponseFetcher
    implements AsyncPageFetcher<GetJobBookmarksResponse> {
        private GetJobBookmarksResponseFetcher() {
        }

        public boolean hasNextPage(GetJobBookmarksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetJobBookmarksResponse> nextPage(GetJobBookmarksResponse previousPage) {
            if (previousPage == null) {
                return GetJobBookmarksPublisher.this.client.getJobBookmarks(GetJobBookmarksPublisher.this.firstRequest);
            }
            return GetJobBookmarksPublisher.this.client.getJobBookmarks((GetJobBookmarksRequest)((Object)GetJobBookmarksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

