/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.JobBookmarkEntry;
import software.amazon.awssdk.services.glue.model.JobBookmarkEntryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetJobBookmarksResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetJobBookmarksResponse> {
    private static final SdkField<List<JobBookmarkEntry>> JOB_BOOKMARK_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetJobBookmarksResponse.getter(GetJobBookmarksResponse::jobBookmarkEntries)).setter(GetJobBookmarksResponse.setter(Builder::jobBookmarkEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobBookmarkEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobBookmarkEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetJobBookmarksResponse.getter(GetJobBookmarksResponse::nextToken)).setter(GetJobBookmarksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_BOOKMARK_ENTRIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<JobBookmarkEntry> jobBookmarkEntries;
    private final Integer nextToken;

    private GetJobBookmarksResponse(BuilderImpl builder) {
        super(builder);
        this.jobBookmarkEntries = builder.jobBookmarkEntries;
        this.nextToken = builder.nextToken;
    }

    public List<JobBookmarkEntry> jobBookmarkEntries() {
        return this.jobBookmarkEntries;
    }

    public Integer nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobBookmarkEntries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobBookmarksResponse)) {
            return false;
        }
        GetJobBookmarksResponse other = (GetJobBookmarksResponse)((Object)obj);
        return Objects.equals(this.jobBookmarkEntries(), other.jobBookmarkEntries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetJobBookmarksResponse").add("JobBookmarkEntries", this.jobBookmarkEntries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobBookmarkEntries": {
                return Optional.ofNullable(clazz.cast(this.jobBookmarkEntries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetJobBookmarksResponse, T> g) {
        return obj -> g.apply((GetJobBookmarksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<JobBookmarkEntry> jobBookmarkEntries = DefaultSdkAutoConstructList.getInstance();
        private Integer nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobBookmarksResponse model) {
            super(model);
            this.jobBookmarkEntries(model.jobBookmarkEntries);
            this.nextToken(model.nextToken);
        }

        public final Collection<JobBookmarkEntry.Builder> getJobBookmarkEntries() {
            return this.jobBookmarkEntries != null ? (Collection)this.jobBookmarkEntries.stream().map(JobBookmarkEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobBookmarkEntries(Collection<JobBookmarkEntry> jobBookmarkEntries) {
            this.jobBookmarkEntries = JobBookmarkEntryListCopier.copy(jobBookmarkEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobBookmarkEntries(JobBookmarkEntry ... jobBookmarkEntries) {
            this.jobBookmarkEntries(Arrays.asList(jobBookmarkEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobBookmarkEntries(Consumer<JobBookmarkEntry.Builder> ... jobBookmarkEntries) {
            this.jobBookmarkEntries(Stream.of(jobBookmarkEntries).map(c -> (JobBookmarkEntry)((JobBookmarkEntry.Builder)JobBookmarkEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobBookmarkEntries(Collection<JobBookmarkEntry.BuilderImpl> jobBookmarkEntries) {
            this.jobBookmarkEntries = JobBookmarkEntryListCopier.copyFromBuilder(jobBookmarkEntries);
        }

        public final Integer getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(Integer nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(Integer nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetJobBookmarksResponse build() {
            return new GetJobBookmarksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetJobBookmarksResponse> {
        public Builder jobBookmarkEntries(Collection<JobBookmarkEntry> var1);

        public Builder jobBookmarkEntries(JobBookmarkEntry ... var1);

        public Builder jobBookmarkEntries(Consumer<JobBookmarkEntry.Builder> ... var1);

        public Builder nextToken(Integer var1);
    }
}

