/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.WorkflowGraph;
import software.amazon.awssdk.services.glue.model.WorkflowRun;
import software.amazon.awssdk.services.glue.model.WorkflowRunPropertiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Workflow
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Workflow> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Workflow.getter(Workflow::name)).setter(Workflow.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Workflow.getter(Workflow::description)).setter(Workflow.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, String>> DEFAULT_RUN_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Workflow.getter(Workflow::defaultRunProperties)).setter(Workflow.setter(Builder::defaultRunProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRunProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Workflow.getter(Workflow::createdOn)).setter(Workflow.setter(Builder::createdOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedOn").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Workflow.getter(Workflow::lastModifiedOn)).setter(Workflow.setter(Builder::lastModifiedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedOn").build()}).build();
    private static final SdkField<WorkflowRun> LAST_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Workflow.getter(Workflow::lastRun)).setter(Workflow.setter(Builder::lastRun)).constructor(WorkflowRun::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRun").build()}).build();
    private static final SdkField<WorkflowGraph> GRAPH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Workflow.getter(Workflow::graph)).setter(Workflow.setter(Builder::graph)).constructor(WorkflowGraph::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Graph").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, DEFAULT_RUN_PROPERTIES_FIELD, CREATED_ON_FIELD, LAST_MODIFIED_ON_FIELD, LAST_RUN_FIELD, GRAPH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final Map<String, String> defaultRunProperties;
    private final Instant createdOn;
    private final Instant lastModifiedOn;
    private final WorkflowRun lastRun;
    private final WorkflowGraph graph;

    private Workflow(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.defaultRunProperties = builder.defaultRunProperties;
        this.createdOn = builder.createdOn;
        this.lastModifiedOn = builder.lastModifiedOn;
        this.lastRun = builder.lastRun;
        this.graph = builder.graph;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Map<String, String> defaultRunProperties() {
        return this.defaultRunProperties;
    }

    public Instant createdOn() {
        return this.createdOn;
    }

    public Instant lastModifiedOn() {
        return this.lastModifiedOn;
    }

    public WorkflowRun lastRun() {
        return this.lastRun;
    }

    public WorkflowGraph graph() {
        return this.graph;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRunProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.graph());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Workflow)) {
            return false;
        }
        Workflow other = (Workflow)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.defaultRunProperties(), other.defaultRunProperties()) && Objects.equals(this.createdOn(), other.createdOn()) && Objects.equals(this.lastModifiedOn(), other.lastModifiedOn()) && Objects.equals(this.lastRun(), other.lastRun()) && Objects.equals(this.graph(), other.graph());
    }

    public String toString() {
        return ToString.builder((String)"Workflow").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("DefaultRunProperties", this.defaultRunProperties()).add("CreatedOn", (Object)this.createdOn()).add("LastModifiedOn", (Object)this.lastModifiedOn()).add("LastRun", (Object)this.lastRun()).add("Graph", (Object)this.graph()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DefaultRunProperties": {
                return Optional.ofNullable(clazz.cast(this.defaultRunProperties()));
            }
            case "CreatedOn": {
                return Optional.ofNullable(clazz.cast(this.createdOn()));
            }
            case "LastModifiedOn": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedOn()));
            }
            case "LastRun": {
                return Optional.ofNullable(clazz.cast(this.lastRun()));
            }
            case "Graph": {
                return Optional.ofNullable(clazz.cast(this.graph()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Workflow, T> g) {
        return obj -> g.apply((Workflow)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private Map<String, String> defaultRunProperties = DefaultSdkAutoConstructMap.getInstance();
        private Instant createdOn;
        private Instant lastModifiedOn;
        private WorkflowRun lastRun;
        private WorkflowGraph graph;

        private BuilderImpl() {
        }

        private BuilderImpl(Workflow model) {
            this.name(model.name);
            this.description(model.description);
            this.defaultRunProperties(model.defaultRunProperties);
            this.createdOn(model.createdOn);
            this.lastModifiedOn(model.lastModifiedOn);
            this.lastRun(model.lastRun);
            this.graph(model.graph);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Map<String, String> getDefaultRunProperties() {
            return this.defaultRunProperties;
        }

        @Override
        public final Builder defaultRunProperties(Map<String, String> defaultRunProperties) {
            this.defaultRunProperties = WorkflowRunPropertiesCopier.copy(defaultRunProperties);
            return this;
        }

        public final void setDefaultRunProperties(Map<String, String> defaultRunProperties) {
            this.defaultRunProperties = WorkflowRunPropertiesCopier.copy(defaultRunProperties);
        }

        public final Instant getCreatedOn() {
            return this.createdOn;
        }

        @Override
        public final Builder createdOn(Instant createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public final void setCreatedOn(Instant createdOn) {
            this.createdOn = createdOn;
        }

        public final Instant getLastModifiedOn() {
            return this.lastModifiedOn;
        }

        @Override
        public final Builder lastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        public final void setLastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
        }

        public final WorkflowRun.Builder getLastRun() {
            return this.lastRun != null ? this.lastRun.toBuilder() : null;
        }

        @Override
        public final Builder lastRun(WorkflowRun lastRun) {
            this.lastRun = lastRun;
            return this;
        }

        public final void setLastRun(WorkflowRun.BuilderImpl lastRun) {
            this.lastRun = lastRun != null ? lastRun.build() : null;
        }

        public final WorkflowGraph.Builder getGraph() {
            return this.graph != null ? this.graph.toBuilder() : null;
        }

        @Override
        public final Builder graph(WorkflowGraph graph) {
            this.graph = graph;
            return this;
        }

        public final void setGraph(WorkflowGraph.BuilderImpl graph) {
            this.graph = graph != null ? graph.build() : null;
        }

        public Workflow build() {
            return new Workflow(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Workflow> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder defaultRunProperties(Map<String, String> var1);

        public Builder createdOn(Instant var1);

        public Builder lastModifiedOn(Instant var1);

        public Builder lastRun(WorkflowRun var1);

        default public Builder lastRun(Consumer<WorkflowRun.Builder> lastRun) {
            return this.lastRun((WorkflowRun)((WorkflowRun.Builder)WorkflowRun.builder().applyMutation(lastRun)).build());
        }

        public Builder graph(WorkflowGraph var1);

        default public Builder graph(Consumer<WorkflowGraph.Builder> graph) {
            return this.graph((WorkflowGraph)((WorkflowGraph.Builder)WorkflowGraph.builder().applyMutation(graph)).build());
        }
    }
}

