/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateXMLClassifierRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateXMLClassifierRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateXMLClassifierRequest.getter(UpdateXMLClassifierRequest::name)).setter(UpdateXMLClassifierRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> CLASSIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateXMLClassifierRequest.getter(UpdateXMLClassifierRequest::classification)).setter(UpdateXMLClassifierRequest.setter(Builder::classification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classification").build()}).build();
    private static final SdkField<String> ROW_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateXMLClassifierRequest.getter(UpdateXMLClassifierRequest::rowTag)).setter(UpdateXMLClassifierRequest.setter(Builder::rowTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowTag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CLASSIFICATION_FIELD, ROW_TAG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String classification;
    private final String rowTag;

    private UpdateXMLClassifierRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.classification = builder.classification;
        this.rowTag = builder.rowTag;
    }

    public String name() {
        return this.name;
    }

    public String classification() {
        return this.classification;
    }

    public String rowTag() {
        return this.rowTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.classification());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowTag());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateXMLClassifierRequest)) {
            return false;
        }
        UpdateXMLClassifierRequest other = (UpdateXMLClassifierRequest)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.classification(), other.classification()) && Objects.equals(this.rowTag(), other.rowTag());
    }

    public String toString() {
        return ToString.builder((String)"UpdateXMLClassifierRequest").add("Name", (Object)this.name()).add("Classification", (Object)this.classification()).add("RowTag", (Object)this.rowTag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Classification": {
                return Optional.ofNullable(clazz.cast(this.classification()));
            }
            case "RowTag": {
                return Optional.ofNullable(clazz.cast(this.rowTag()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateXMLClassifierRequest, T> g) {
        return obj -> g.apply((UpdateXMLClassifierRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String classification;
        private String rowTag;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateXMLClassifierRequest model) {
            this.name(model.name);
            this.classification(model.classification);
            this.rowTag(model.rowTag);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getClassification() {
            return this.classification;
        }

        @Override
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        public final String getRowTag() {
            return this.rowTag;
        }

        @Override
        public final Builder rowTag(String rowTag) {
            this.rowTag = rowTag;
            return this;
        }

        public final void setRowTag(String rowTag) {
            this.rowTag = rowTag;
        }

        public UpdateXMLClassifierRequest build() {
            return new UpdateXMLClassifierRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateXMLClassifierRequest> {
        public Builder name(String var1);

        public Builder classification(String var1);

        public Builder rowTag(String var1);
    }
}

