/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.OneInputCopier;
import software.amazon.awssdk.services.glue.model.SnowflakeNodeData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnowflakeTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnowflakeTarget> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(SnowflakeTarget.getter(SnowflakeTarget::name)).setter(SnowflakeTarget.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<SnowflakeNodeData> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Data").getter(SnowflakeTarget.getter(SnowflakeTarget::data)).setter(SnowflakeTarget.setter(Builder::data)).constructor(SnowflakeNodeData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build()}).build();
    private static final SdkField<List<String>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Inputs").getter(SnowflakeTarget.getter(SnowflakeTarget::inputs)).setter(SnowflakeTarget.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DATA_FIELD, INPUTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SnowflakeTarget.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final SnowflakeNodeData data;
    private final List<String> inputs;

    private SnowflakeTarget(BuilderImpl builder) {
        this.name = builder.name;
        this.data = builder.data;
        this.inputs = builder.inputs;
    }

    public final String name() {
        return this.name;
    }

    public final SnowflakeNodeData data() {
        return this.data;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<String> inputs() {
        return this.inputs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeTarget)) {
            return false;
        }
        SnowflakeTarget other = (SnowflakeTarget)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.data(), other.data()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs());
    }

    public final String toString() {
        return ToString.builder((String)"SnowflakeTarget").add("Name", (Object)this.name()).add("Data", (Object)this.data()).add("Inputs", this.hasInputs() ? this.inputs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Data", DATA_FIELD);
        map.put("Inputs", INPUTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnowflakeTarget, T> g) {
        return obj -> g.apply((SnowflakeTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private SnowflakeNodeData data;
        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SnowflakeTarget model) {
            this.name(model.name);
            this.data(model.data);
            this.inputs(model.inputs);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final SnowflakeNodeData.Builder getData() {
            return this.data != null ? this.data.toBuilder() : null;
        }

        public final void setData(SnowflakeNodeData.BuilderImpl data) {
            this.data = data != null ? data.build() : null;
        }

        @Override
        public final Builder data(SnowflakeNodeData data) {
            this.data = data;
            return this;
        }

        public final Collection<String> getInputs() {
            if (this.inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        public SnowflakeTarget build() {
            return new SnowflakeTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnowflakeTarget> {
        public Builder name(String var1);

        public Builder data(SnowflakeNodeData var1);

        default public Builder data(Consumer<SnowflakeNodeData.Builder> data) {
            return this.data((SnowflakeNodeData)((SnowflakeNodeData.Builder)SnowflakeNodeData.builder().applyMutation(data)).build());
        }

        public Builder inputs(Collection<String> var1);

        public Builder inputs(String ... var1);
    }
}

