/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IntegrationPartition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IntegrationPartition> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldName").getter(IntegrationPartition.getter(IntegrationPartition::fieldName)).setter(IntegrationPartition.setter(Builder::fieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()}).build();
    private static final SdkField<String> FUNCTION_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionSpec").getter(IntegrationPartition.getter(IntegrationPartition::functionSpec)).setter(IntegrationPartition.setter(Builder::functionSpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionSpec").build()}).build();
    private static final SdkField<String> CONVERSION_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConversionSpec").getter(IntegrationPartition.getter(IntegrationPartition::conversionSpec)).setter(IntegrationPartition.setter(Builder::conversionSpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConversionSpec").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD, FUNCTION_SPEC_FIELD, CONVERSION_SPEC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IntegrationPartition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fieldName;
    private final String functionSpec;
    private final String conversionSpec;

    private IntegrationPartition(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.functionSpec = builder.functionSpec;
        this.conversionSpec = builder.conversionSpec;
    }

    public final String fieldName() {
        return this.fieldName;
    }

    public final String functionSpec() {
        return this.functionSpec;
    }

    public final String conversionSpec() {
        return this.conversionSpec;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.conversionSpec());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegrationPartition)) {
            return false;
        }
        IntegrationPartition other = (IntegrationPartition)obj;
        return Objects.equals(this.fieldName(), other.fieldName()) && Objects.equals(this.functionSpec(), other.functionSpec()) && Objects.equals(this.conversionSpec(), other.conversionSpec());
    }

    public final String toString() {
        return ToString.builder((String)"IntegrationPartition").add("FieldName", (Object)this.fieldName()).add("FunctionSpec", (Object)this.functionSpec()).add("ConversionSpec", (Object)this.conversionSpec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldName": {
                return Optional.ofNullable(clazz.cast(this.fieldName()));
            }
            case "FunctionSpec": {
                return Optional.ofNullable(clazz.cast(this.functionSpec()));
            }
            case "ConversionSpec": {
                return Optional.ofNullable(clazz.cast(this.conversionSpec()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("FieldName", FIELD_NAME_FIELD);
        map.put("FunctionSpec", FUNCTION_SPEC_FIELD);
        map.put("ConversionSpec", CONVERSION_SPEC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IntegrationPartition, T> g) {
        return obj -> g.apply((IntegrationPartition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldName;
        private String functionSpec;
        private String conversionSpec;

        private BuilderImpl() {
        }

        private BuilderImpl(IntegrationPartition model) {
            this.fieldName(model.fieldName);
            this.functionSpec(model.functionSpec);
            this.conversionSpec(model.conversionSpec);
        }

        public final String getFieldName() {
            return this.fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final String getFunctionSpec() {
            return this.functionSpec;
        }

        public final void setFunctionSpec(String functionSpec) {
            this.functionSpec = functionSpec;
        }

        @Override
        public final Builder functionSpec(String functionSpec) {
            this.functionSpec = functionSpec;
            return this;
        }

        public final String getConversionSpec() {
            return this.conversionSpec;
        }

        public final void setConversionSpec(String conversionSpec) {
            this.conversionSpec = conversionSpec;
        }

        @Override
        public final Builder conversionSpec(String conversionSpec) {
            this.conversionSpec = conversionSpec;
            return this;
        }

        public IntegrationPartition build() {
            return new IntegrationPartition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IntegrationPartition> {
        public Builder fieldName(String var1);

        public Builder functionSpec(String var1);

        public Builder conversionSpec(String var1);
    }
}

