/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DQResultsPublishingOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DQResultsPublishingOptions> {
    private static final SdkField<String> EVALUATION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationContext").getter(DQResultsPublishingOptions.getter(DQResultsPublishingOptions::evaluationContext)).setter(DQResultsPublishingOptions.setter(Builder::evaluationContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationContext").build()}).build();
    private static final SdkField<String> RESULTS_S3_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResultsS3Prefix").getter(DQResultsPublishingOptions.getter(DQResultsPublishingOptions::resultsS3Prefix)).setter(DQResultsPublishingOptions.setter(Builder::resultsS3Prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultsS3Prefix").build()}).build();
    private static final SdkField<Boolean> CLOUD_WATCH_METRICS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CloudWatchMetricsEnabled").getter(DQResultsPublishingOptions.getter(DQResultsPublishingOptions::cloudWatchMetricsEnabled)).setter(DQResultsPublishingOptions.setter(Builder::cloudWatchMetricsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchMetricsEnabled").build()}).build();
    private static final SdkField<Boolean> RESULTS_PUBLISHING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ResultsPublishingEnabled").getter(DQResultsPublishingOptions.getter(DQResultsPublishingOptions::resultsPublishingEnabled)).setter(DQResultsPublishingOptions.setter(Builder::resultsPublishingEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultsPublishingEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_CONTEXT_FIELD, RESULTS_S3_PREFIX_FIELD, CLOUD_WATCH_METRICS_ENABLED_FIELD, RESULTS_PUBLISHING_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DQResultsPublishingOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String evaluationContext;
    private final String resultsS3Prefix;
    private final Boolean cloudWatchMetricsEnabled;
    private final Boolean resultsPublishingEnabled;

    private DQResultsPublishingOptions(BuilderImpl builder) {
        this.evaluationContext = builder.evaluationContext;
        this.resultsS3Prefix = builder.resultsS3Prefix;
        this.cloudWatchMetricsEnabled = builder.cloudWatchMetricsEnabled;
        this.resultsPublishingEnabled = builder.resultsPublishingEnabled;
    }

    public final String evaluationContext() {
        return this.evaluationContext;
    }

    public final String resultsS3Prefix() {
        return this.resultsS3Prefix;
    }

    public final Boolean cloudWatchMetricsEnabled() {
        return this.cloudWatchMetricsEnabled;
    }

    public final Boolean resultsPublishingEnabled() {
        return this.resultsPublishingEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultsS3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchMetricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultsPublishingEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DQResultsPublishingOptions)) {
            return false;
        }
        DQResultsPublishingOptions other = (DQResultsPublishingOptions)obj;
        return Objects.equals(this.evaluationContext(), other.evaluationContext()) && Objects.equals(this.resultsS3Prefix(), other.resultsS3Prefix()) && Objects.equals(this.cloudWatchMetricsEnabled(), other.cloudWatchMetricsEnabled()) && Objects.equals(this.resultsPublishingEnabled(), other.resultsPublishingEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"DQResultsPublishingOptions").add("EvaluationContext", (Object)this.evaluationContext()).add("ResultsS3Prefix", (Object)this.resultsS3Prefix()).add("CloudWatchMetricsEnabled", (Object)this.cloudWatchMetricsEnabled()).add("ResultsPublishingEnabled", (Object)this.resultsPublishingEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationContext": {
                return Optional.ofNullable(clazz.cast(this.evaluationContext()));
            }
            case "ResultsS3Prefix": {
                return Optional.ofNullable(clazz.cast(this.resultsS3Prefix()));
            }
            case "CloudWatchMetricsEnabled": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchMetricsEnabled()));
            }
            case "ResultsPublishingEnabled": {
                return Optional.ofNullable(clazz.cast(this.resultsPublishingEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EvaluationContext", EVALUATION_CONTEXT_FIELD);
        map.put("ResultsS3Prefix", RESULTS_S3_PREFIX_FIELD);
        map.put("CloudWatchMetricsEnabled", CLOUD_WATCH_METRICS_ENABLED_FIELD);
        map.put("ResultsPublishingEnabled", RESULTS_PUBLISHING_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DQResultsPublishingOptions, T> g) {
        return obj -> g.apply((DQResultsPublishingOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String evaluationContext;
        private String resultsS3Prefix;
        private Boolean cloudWatchMetricsEnabled;
        private Boolean resultsPublishingEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(DQResultsPublishingOptions model) {
            this.evaluationContext(model.evaluationContext);
            this.resultsS3Prefix(model.resultsS3Prefix);
            this.cloudWatchMetricsEnabled(model.cloudWatchMetricsEnabled);
            this.resultsPublishingEnabled(model.resultsPublishingEnabled);
        }

        public final String getEvaluationContext() {
            return this.evaluationContext;
        }

        public final void setEvaluationContext(String evaluationContext) {
            this.evaluationContext = evaluationContext;
        }

        @Override
        public final Builder evaluationContext(String evaluationContext) {
            this.evaluationContext = evaluationContext;
            return this;
        }

        public final String getResultsS3Prefix() {
            return this.resultsS3Prefix;
        }

        public final void setResultsS3Prefix(String resultsS3Prefix) {
            this.resultsS3Prefix = resultsS3Prefix;
        }

        @Override
        public final Builder resultsS3Prefix(String resultsS3Prefix) {
            this.resultsS3Prefix = resultsS3Prefix;
            return this;
        }

        public final Boolean getCloudWatchMetricsEnabled() {
            return this.cloudWatchMetricsEnabled;
        }

        public final void setCloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
            this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
        }

        @Override
        public final Builder cloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
            this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
            return this;
        }

        public final Boolean getResultsPublishingEnabled() {
            return this.resultsPublishingEnabled;
        }

        public final void setResultsPublishingEnabled(Boolean resultsPublishingEnabled) {
            this.resultsPublishingEnabled = resultsPublishingEnabled;
        }

        @Override
        public final Builder resultsPublishingEnabled(Boolean resultsPublishingEnabled) {
            this.resultsPublishingEnabled = resultsPublishingEnabled;
            return this;
        }

        public DQResultsPublishingOptions build() {
            return new DQResultsPublishingOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DQResultsPublishingOptions> {
        public Builder evaluationContext(String var1);

        public Builder resultsS3Prefix(String var1);

        public Builder cloudWatchMetricsEnabled(Boolean var1);

        public Builder resultsPublishingEnabled(Boolean var1);
    }
}

