/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.Entity;
import software.amazon.awssdk.services.glue.model.ListEntitiesRequest;
import software.amazon.awssdk.services.glue.model.ListEntitiesResponse;

public class ListEntitiesIterable
implements SdkIterable<ListEntitiesResponse> {
    private final GlueClient client;
    private final ListEntitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEntitiesIterable(GlueClient client, ListEntitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEntitiesResponseFetcher();
    }

    public Iterator<ListEntitiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Entity> entities() {
        Function<ListEntitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.entities() != null) {
                return response.entities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEntitiesResponseFetcher
    implements SyncPageFetcher<ListEntitiesResponse> {
        private ListEntitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListEntitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEntitiesResponse nextPage(ListEntitiesResponse previousPage) {
            if (previousPage == null) {
                return ListEntitiesIterable.this.client.listEntities(ListEntitiesIterable.this.firstRequest);
            }
            return ListEntitiesIterable.this.client.listEntities((ListEntitiesRequest)((Object)ListEntitiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

