/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.ListCrawlersRequest;
import software.amazon.awssdk.services.glue.model.ListCrawlersResponse;

public class ListCrawlersIterable
implements SdkIterable<ListCrawlersResponse> {
    private final GlueClient client;
    private final ListCrawlersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCrawlersIterable(GlueClient client, ListCrawlersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCrawlersResponseFetcher();
    }

    public Iterator<ListCrawlersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListCrawlersResponseFetcher
    implements SyncPageFetcher<ListCrawlersResponse> {
        private ListCrawlersResponseFetcher() {
        }

        public boolean hasNextPage(ListCrawlersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCrawlersResponse nextPage(ListCrawlersResponse previousPage) {
            if (previousPage == null) {
                return ListCrawlersIterable.this.client.listCrawlers(ListCrawlersIterable.this.firstRequest);
            }
            return ListCrawlersIterable.this.client.listCrawlers((ListCrawlersRequest)((Object)ListCrawlersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

