/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.TaskStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelMlTaskRunResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, CancelMlTaskRunResponse> {
    private static final SdkField<String> TRANSFORM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransformId").getter(CancelMlTaskRunResponse.getter(CancelMlTaskRunResponse::transformId)).setter(CancelMlTaskRunResponse.setter(Builder::transformId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformId").build()}).build();
    private static final SdkField<String> TASK_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskRunId").getter(CancelMlTaskRunResponse.getter(CancelMlTaskRunResponse::taskRunId)).setter(CancelMlTaskRunResponse.setter(Builder::taskRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskRunId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CancelMlTaskRunResponse.getter(CancelMlTaskRunResponse::statusAsString)).setter(CancelMlTaskRunResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_ID_FIELD, TASK_RUN_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CancelMlTaskRunResponse.memberNameToFieldInitializer();
    private final String transformId;
    private final String taskRunId;
    private final String status;

    private CancelMlTaskRunResponse(BuilderImpl builder) {
        super(builder);
        this.transformId = builder.transformId;
        this.taskRunId = builder.taskRunId;
        this.status = builder.status;
    }

    public final String transformId() {
        return this.transformId;
    }

    public final String taskRunId() {
        return this.taskRunId;
    }

    public final TaskStatusType status() {
        return TaskStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transformId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelMlTaskRunResponse)) {
            return false;
        }
        CancelMlTaskRunResponse other = (CancelMlTaskRunResponse)((Object)obj);
        return Objects.equals(this.transformId(), other.transformId()) && Objects.equals(this.taskRunId(), other.taskRunId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CancelMlTaskRunResponse").add("TransformId", (Object)this.transformId()).add("TaskRunId", (Object)this.taskRunId()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransformId": {
                return Optional.ofNullable(clazz.cast(this.transformId()));
            }
            case "TaskRunId": {
                return Optional.ofNullable(clazz.cast(this.taskRunId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TransformId", TRANSFORM_ID_FIELD);
        map.put("TaskRunId", TASK_RUN_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelMlTaskRunResponse, T> g) {
        return obj -> g.apply((CancelMlTaskRunResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private String transformId;
        private String taskRunId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelMlTaskRunResponse model) {
            super(model);
            this.transformId(model.transformId);
            this.taskRunId(model.taskRunId);
            this.status(model.status);
        }

        public final String getTransformId() {
            return this.transformId;
        }

        public final void setTransformId(String transformId) {
            this.transformId = transformId;
        }

        @Override
        public final Builder transformId(String transformId) {
            this.transformId = transformId;
            return this;
        }

        public final String getTaskRunId() {
            return this.taskRunId;
        }

        public final void setTaskRunId(String taskRunId) {
            this.taskRunId = taskRunId;
        }

        @Override
        public final Builder taskRunId(String taskRunId) {
            this.taskRunId = taskRunId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public CancelMlTaskRunResponse build() {
            return new CancelMlTaskRunResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelMlTaskRunResponse> {
        public Builder transformId(String var1);

        public Builder taskRunId(String var1);

        public Builder status(String var1);

        public Builder status(TaskStatusType var1);
    }
}

