/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResetJobBookmarkResponse extends GlueResponse implements
        ToCopyableBuilder<ResetJobBookmarkResponse.Builder, ResetJobBookmarkResponse> {
    private static final SdkField<JobBookmarkEntry> JOB_BOOKMARK_ENTRY_FIELD = SdkField
            .<JobBookmarkEntry> builder(MarshallingType.SDK_POJO).memberName("JobBookmarkEntry")
            .getter(getter(ResetJobBookmarkResponse::jobBookmarkEntry)).setter(setter(Builder::jobBookmarkEntry))
            .constructor(JobBookmarkEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobBookmarkEntry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_BOOKMARK_ENTRY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final JobBookmarkEntry jobBookmarkEntry;

    private ResetJobBookmarkResponse(BuilderImpl builder) {
        super(builder);
        this.jobBookmarkEntry = builder.jobBookmarkEntry;
    }

    /**
     * <p>
     * The reset bookmark entry.
     * </p>
     * 
     * @return The reset bookmark entry.
     */
    public final JobBookmarkEntry jobBookmarkEntry() {
        return jobBookmarkEntry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobBookmarkEntry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetJobBookmarkResponse)) {
            return false;
        }
        ResetJobBookmarkResponse other = (ResetJobBookmarkResponse) obj;
        return Objects.equals(jobBookmarkEntry(), other.jobBookmarkEntry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResetJobBookmarkResponse").add("JobBookmarkEntry", jobBookmarkEntry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobBookmarkEntry":
            return Optional.ofNullable(clazz.cast(jobBookmarkEntry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JobBookmarkEntry", JOB_BOOKMARK_ENTRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResetJobBookmarkResponse, T> g) {
        return obj -> g.apply((ResetJobBookmarkResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, ResetJobBookmarkResponse> {
        /**
         * <p>
         * The reset bookmark entry.
         * </p>
         * 
         * @param jobBookmarkEntry
         *        The reset bookmark entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobBookmarkEntry(JobBookmarkEntry jobBookmarkEntry);

        /**
         * <p>
         * The reset bookmark entry.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobBookmarkEntry.Builder} avoiding the
         * need to create one manually via {@link JobBookmarkEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobBookmarkEntry.Builder#build()} is called immediately and its
         * result is passed to {@link #jobBookmarkEntry(JobBookmarkEntry)}.
         * 
         * @param jobBookmarkEntry
         *        a consumer that will call methods on {@link JobBookmarkEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobBookmarkEntry(JobBookmarkEntry)
         */
        default Builder jobBookmarkEntry(Consumer<JobBookmarkEntry.Builder> jobBookmarkEntry) {
            return jobBookmarkEntry(JobBookmarkEntry.builder().applyMutation(jobBookmarkEntry).build());
        }
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private JobBookmarkEntry jobBookmarkEntry;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetJobBookmarkResponse model) {
            super(model);
            jobBookmarkEntry(model.jobBookmarkEntry);
        }

        public final JobBookmarkEntry.Builder getJobBookmarkEntry() {
            return jobBookmarkEntry != null ? jobBookmarkEntry.toBuilder() : null;
        }

        public final void setJobBookmarkEntry(JobBookmarkEntry.BuilderImpl jobBookmarkEntry) {
            this.jobBookmarkEntry = jobBookmarkEntry != null ? jobBookmarkEntry.build() : null;
        }

        @Override
        public final Builder jobBookmarkEntry(JobBookmarkEntry jobBookmarkEntry) {
            this.jobBookmarkEntry = jobBookmarkEntry;
            return this;
        }

        @Override
        public ResetJobBookmarkResponse build() {
            return new ResetJobBookmarkResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
