/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filters the connection definitions that are returned by the <code>GetConnections</code> API operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConnectionsFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<GetConnectionsFilter.Builder, GetConnectionsFilter> {
    private static final SdkField<List<String>> MATCH_CRITERIA_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MatchCriteria")
            .getter(getter(GetConnectionsFilter::matchCriteria))
            .setter(setter(Builder::matchCriteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchCriteria").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionType").getter(getter(GetConnectionsFilter::connectionTypeAsString))
            .setter(setter(Builder::connectionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()).build();

    private static final SdkField<Integer> CONNECTION_SCHEMA_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ConnectionSchemaVersion").getter(getter(GetConnectionsFilter::connectionSchemaVersion))
            .setter(setter(Builder::connectionSchemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionSchemaVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_CRITERIA_FIELD,
            CONNECTION_TYPE_FIELD, CONNECTION_SCHEMA_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> matchCriteria;

    private final String connectionType;

    private final Integer connectionSchemaVersion;

    private GetConnectionsFilter(BuilderImpl builder) {
        this.matchCriteria = builder.matchCriteria;
        this.connectionType = builder.connectionType;
        this.connectionSchemaVersion = builder.connectionSchemaVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the MatchCriteria property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMatchCriteria() {
        return matchCriteria != null && !(matchCriteria instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A criteria string that must match the criteria recorded in the connection definition for that connection
     * definition to be returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatchCriteria} method.
     * </p>
     * 
     * @return A criteria string that must match the criteria recorded in the connection definition for that connection
     *         definition to be returned.
     */
    public final List<String> matchCriteria() {
        return matchCriteria;
    }

    /**
     * <p>
     * The type of connections to return. Currently, SFTP is not supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The type of connections to return. Currently, SFTP is not supported.
     * @see ConnectionType
     */
    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(connectionType);
    }

    /**
     * <p>
     * The type of connections to return. Currently, SFTP is not supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The type of connections to return. Currently, SFTP is not supported.
     * @see ConnectionType
     */
    public final String connectionTypeAsString() {
        return connectionType;
    }

    /**
     * <p>
     * Denotes if the connection was created with schema version 1 or 2.
     * </p>
     * 
     * @return Denotes if the connection was created with schema version 1 or 2.
     */
    public final Integer connectionSchemaVersion() {
        return connectionSchemaVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchCriteria() ? matchCriteria() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectionSchemaVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectionsFilter)) {
            return false;
        }
        GetConnectionsFilter other = (GetConnectionsFilter) obj;
        return hasMatchCriteria() == other.hasMatchCriteria() && Objects.equals(matchCriteria(), other.matchCriteria())
                && Objects.equals(connectionTypeAsString(), other.connectionTypeAsString())
                && Objects.equals(connectionSchemaVersion(), other.connectionSchemaVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConnectionsFilter").add("MatchCriteria", hasMatchCriteria() ? matchCriteria() : null)
                .add("ConnectionType", connectionTypeAsString()).add("ConnectionSchemaVersion", connectionSchemaVersion())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MatchCriteria":
            return Optional.ofNullable(clazz.cast(matchCriteria()));
        case "ConnectionType":
            return Optional.ofNullable(clazz.cast(connectionTypeAsString()));
        case "ConnectionSchemaVersion":
            return Optional.ofNullable(clazz.cast(connectionSchemaVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MatchCriteria", MATCH_CRITERIA_FIELD);
        map.put("ConnectionType", CONNECTION_TYPE_FIELD);
        map.put("ConnectionSchemaVersion", CONNECTION_SCHEMA_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConnectionsFilter, T> g) {
        return obj -> g.apply((GetConnectionsFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GetConnectionsFilter> {
        /**
         * <p>
         * A criteria string that must match the criteria recorded in the connection definition for that connection
         * definition to be returned.
         * </p>
         * 
         * @param matchCriteria
         *        A criteria string that must match the criteria recorded in the connection definition for that
         *        connection definition to be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchCriteria(Collection<String> matchCriteria);

        /**
         * <p>
         * A criteria string that must match the criteria recorded in the connection definition for that connection
         * definition to be returned.
         * </p>
         * 
         * @param matchCriteria
         *        A criteria string that must match the criteria recorded in the connection definition for that
         *        connection definition to be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchCriteria(String... matchCriteria);

        /**
         * <p>
         * The type of connections to return. Currently, SFTP is not supported.
         * </p>
         * 
         * @param connectionType
         *        The type of connections to return. Currently, SFTP is not supported.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(String connectionType);

        /**
         * <p>
         * The type of connections to return. Currently, SFTP is not supported.
         * </p>
         * 
         * @param connectionType
         *        The type of connections to return. Currently, SFTP is not supported.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(ConnectionType connectionType);

        /**
         * <p>
         * Denotes if the connection was created with schema version 1 or 2.
         * </p>
         * 
         * @param connectionSchemaVersion
         *        Denotes if the connection was created with schema version 1 or 2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionSchemaVersion(Integer connectionSchemaVersion);
    }

    static final class BuilderImpl implements Builder {
        private List<String> matchCriteria = DefaultSdkAutoConstructList.getInstance();

        private String connectionType;

        private Integer connectionSchemaVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectionsFilter model) {
            matchCriteria(model.matchCriteria);
            connectionType(model.connectionType);
            connectionSchemaVersion(model.connectionSchemaVersion);
        }

        public final Collection<String> getMatchCriteria() {
            if (matchCriteria instanceof SdkAutoConstructList) {
                return null;
            }
            return matchCriteria;
        }

        public final void setMatchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
        }

        @Override
        public final Builder matchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchCriteria(String... matchCriteria) {
            matchCriteria(Arrays.asList(matchCriteria));
            return this;
        }

        public final String getConnectionType() {
            return connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final Integer getConnectionSchemaVersion() {
            return connectionSchemaVersion;
        }

        public final void setConnectionSchemaVersion(Integer connectionSchemaVersion) {
            this.connectionSchemaVersion = connectionSchemaVersion;
        }

        @Override
        public final Builder connectionSchemaVersion(Integer connectionSchemaVersion) {
            this.connectionSchemaVersion = connectionSchemaVersion;
            return this;
        }

        @Override
        public GetConnectionsFilter build() {
            return new GetConnectionsFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
