/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetColumnStatisticsTaskRunResponse extends GlueResponse implements
        ToCopyableBuilder<GetColumnStatisticsTaskRunResponse.Builder, GetColumnStatisticsTaskRunResponse> {
    private static final SdkField<ColumnStatisticsTaskRun> COLUMN_STATISTICS_TASK_RUN_FIELD = SdkField
            .<ColumnStatisticsTaskRun> builder(MarshallingType.SDK_POJO).memberName("ColumnStatisticsTaskRun")
            .getter(getter(GetColumnStatisticsTaskRunResponse::columnStatisticsTaskRun))
            .setter(setter(Builder::columnStatisticsTaskRun)).constructor(ColumnStatisticsTaskRun::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnStatisticsTaskRun").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(COLUMN_STATISTICS_TASK_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ColumnStatisticsTaskRun columnStatisticsTaskRun;

    private GetColumnStatisticsTaskRunResponse(BuilderImpl builder) {
        super(builder);
        this.columnStatisticsTaskRun = builder.columnStatisticsTaskRun;
    }

    /**
     * <p>
     * A <code>ColumnStatisticsTaskRun</code> object representing the details of the column stats run.
     * </p>
     * 
     * @return A <code>ColumnStatisticsTaskRun</code> object representing the details of the column stats run.
     */
    public final ColumnStatisticsTaskRun columnStatisticsTaskRun() {
        return columnStatisticsTaskRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(columnStatisticsTaskRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetColumnStatisticsTaskRunResponse)) {
            return false;
        }
        GetColumnStatisticsTaskRunResponse other = (GetColumnStatisticsTaskRunResponse) obj;
        return Objects.equals(columnStatisticsTaskRun(), other.columnStatisticsTaskRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetColumnStatisticsTaskRunResponse").add("ColumnStatisticsTaskRun", columnStatisticsTaskRun())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnStatisticsTaskRun":
            return Optional.ofNullable(clazz.cast(columnStatisticsTaskRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ColumnStatisticsTaskRun", COLUMN_STATISTICS_TASK_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetColumnStatisticsTaskRunResponse, T> g) {
        return obj -> g.apply((GetColumnStatisticsTaskRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetColumnStatisticsTaskRunResponse> {
        /**
         * <p>
         * A <code>ColumnStatisticsTaskRun</code> object representing the details of the column stats run.
         * </p>
         * 
         * @param columnStatisticsTaskRun
         *        A <code>ColumnStatisticsTaskRun</code> object representing the details of the column stats run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnStatisticsTaskRun(ColumnStatisticsTaskRun columnStatisticsTaskRun);

        /**
         * <p>
         * A <code>ColumnStatisticsTaskRun</code> object representing the details of the column stats run.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnStatisticsTaskRun.Builder} avoiding
         * the need to create one manually via {@link ColumnStatisticsTaskRun#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnStatisticsTaskRun.Builder#build()} is called immediately
         * and its result is passed to {@link #columnStatisticsTaskRun(ColumnStatisticsTaskRun)}.
         * 
         * @param columnStatisticsTaskRun
         *        a consumer that will call methods on {@link ColumnStatisticsTaskRun.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnStatisticsTaskRun(ColumnStatisticsTaskRun)
         */
        default Builder columnStatisticsTaskRun(Consumer<ColumnStatisticsTaskRun.Builder> columnStatisticsTaskRun) {
            return columnStatisticsTaskRun(ColumnStatisticsTaskRun.builder().applyMutation(columnStatisticsTaskRun).build());
        }
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private ColumnStatisticsTaskRun columnStatisticsTaskRun;

        private BuilderImpl() {
        }

        private BuilderImpl(GetColumnStatisticsTaskRunResponse model) {
            super(model);
            columnStatisticsTaskRun(model.columnStatisticsTaskRun);
        }

        public final ColumnStatisticsTaskRun.Builder getColumnStatisticsTaskRun() {
            return columnStatisticsTaskRun != null ? columnStatisticsTaskRun.toBuilder() : null;
        }

        public final void setColumnStatisticsTaskRun(ColumnStatisticsTaskRun.BuilderImpl columnStatisticsTaskRun) {
            this.columnStatisticsTaskRun = columnStatisticsTaskRun != null ? columnStatisticsTaskRun.build() : null;
        }

        @Override
        public final Builder columnStatisticsTaskRun(ColumnStatisticsTaskRun columnStatisticsTaskRun) {
            this.columnStatisticsTaskRun = columnStatisticsTaskRun;
            return this;
        }

        @Override
        public GetColumnStatisticsTaskRunResponse build() {
            return new GetColumnStatisticsTaskRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
