/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that specifies data lake access properties and other custom properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CatalogProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<CatalogProperties.Builder, CatalogProperties> {
    private static final SdkField<DataLakeAccessProperties> DATA_LAKE_ACCESS_PROPERTIES_FIELD = SdkField
            .<DataLakeAccessProperties> builder(MarshallingType.SDK_POJO).memberName("DataLakeAccessProperties")
            .getter(getter(CatalogProperties::dataLakeAccessProperties)).setter(setter(Builder::dataLakeAccessProperties))
            .constructor(DataLakeAccessProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLakeAccessProperties").build())
            .build();

    private static final SdkField<IcebergOptimizationProperties> ICEBERG_OPTIMIZATION_PROPERTIES_FIELD = SdkField
            .<IcebergOptimizationProperties> builder(MarshallingType.SDK_POJO)
            .memberName("IcebergOptimizationProperties")
            .getter(getter(CatalogProperties::icebergOptimizationProperties))
            .setter(setter(Builder::icebergOptimizationProperties))
            .constructor(IcebergOptimizationProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IcebergOptimizationProperties")
                    .build()).build();

    private static final SdkField<Map<String, String>> CUSTOM_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("CustomProperties")
            .getter(getter(CatalogProperties::customProperties))
            .setter(setter(Builder::customProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATA_LAKE_ACCESS_PROPERTIES_FIELD, ICEBERG_OPTIMIZATION_PROPERTIES_FIELD, CUSTOM_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DataLakeAccessProperties dataLakeAccessProperties;

    private final IcebergOptimizationProperties icebergOptimizationProperties;

    private final Map<String, String> customProperties;

    private CatalogProperties(BuilderImpl builder) {
        this.dataLakeAccessProperties = builder.dataLakeAccessProperties;
        this.icebergOptimizationProperties = builder.icebergOptimizationProperties;
        this.customProperties = builder.customProperties;
    }

    /**
     * <p>
     * A <code>DataLakeAccessProperties</code> object that specifies properties to configure data lake access for your
     * catalog resource in the Glue Data Catalog.
     * </p>
     * 
     * @return A <code>DataLakeAccessProperties</code> object that specifies properties to configure data lake access
     *         for your catalog resource in the Glue Data Catalog.
     */
    public final DataLakeAccessProperties dataLakeAccessProperties() {
        return dataLakeAccessProperties;
    }

    /**
     * <p>
     * A structure that specifies Iceberg table optimization properties for the catalog. This includes configuration for
     * compaction, retention, and orphan file deletion operations that can be applied to Iceberg tables in this catalog.
     * </p>
     * 
     * @return A structure that specifies Iceberg table optimization properties for the catalog. This includes
     *         configuration for compaction, retention, and orphan file deletion operations that can be applied to
     *         Iceberg tables in this catalog.
     */
    public final IcebergOptimizationProperties icebergOptimizationProperties() {
        return icebergOptimizationProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomProperties() {
        return customProperties != null && !(customProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Additional key-value properties for the catalog, such as column statistics optimizations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomProperties} method.
     * </p>
     * 
     * @return Additional key-value properties for the catalog, such as column statistics optimizations.
     */
    public final Map<String, String> customProperties() {
        return customProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataLakeAccessProperties());
        hashCode = 31 * hashCode + Objects.hashCode(icebergOptimizationProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomProperties() ? customProperties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogProperties)) {
            return false;
        }
        CatalogProperties other = (CatalogProperties) obj;
        return Objects.equals(dataLakeAccessProperties(), other.dataLakeAccessProperties())
                && Objects.equals(icebergOptimizationProperties(), other.icebergOptimizationProperties())
                && hasCustomProperties() == other.hasCustomProperties()
                && Objects.equals(customProperties(), other.customProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CatalogProperties").add("DataLakeAccessProperties", dataLakeAccessProperties())
                .add("IcebergOptimizationProperties", icebergOptimizationProperties())
                .add("CustomProperties", hasCustomProperties() ? customProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataLakeAccessProperties":
            return Optional.ofNullable(clazz.cast(dataLakeAccessProperties()));
        case "IcebergOptimizationProperties":
            return Optional.ofNullable(clazz.cast(icebergOptimizationProperties()));
        case "CustomProperties":
            return Optional.ofNullable(clazz.cast(customProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataLakeAccessProperties", DATA_LAKE_ACCESS_PROPERTIES_FIELD);
        map.put("IcebergOptimizationProperties", ICEBERG_OPTIMIZATION_PROPERTIES_FIELD);
        map.put("CustomProperties", CUSTOM_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CatalogProperties, T> g) {
        return obj -> g.apply((CatalogProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CatalogProperties> {
        /**
         * <p>
         * A <code>DataLakeAccessProperties</code> object that specifies properties to configure data lake access for
         * your catalog resource in the Glue Data Catalog.
         * </p>
         * 
         * @param dataLakeAccessProperties
         *        A <code>DataLakeAccessProperties</code> object that specifies properties to configure data lake access
         *        for your catalog resource in the Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLakeAccessProperties(DataLakeAccessProperties dataLakeAccessProperties);

        /**
         * <p>
         * A <code>DataLakeAccessProperties</code> object that specifies properties to configure data lake access for
         * your catalog resource in the Glue Data Catalog.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLakeAccessProperties.Builder}
         * avoiding the need to create one manually via {@link DataLakeAccessProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLakeAccessProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #dataLakeAccessProperties(DataLakeAccessProperties)}.
         * 
         * @param dataLakeAccessProperties
         *        a consumer that will call methods on {@link DataLakeAccessProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataLakeAccessProperties(DataLakeAccessProperties)
         */
        default Builder dataLakeAccessProperties(Consumer<DataLakeAccessProperties.Builder> dataLakeAccessProperties) {
            return dataLakeAccessProperties(DataLakeAccessProperties.builder().applyMutation(dataLakeAccessProperties).build());
        }

        /**
         * <p>
         * A structure that specifies Iceberg table optimization properties for the catalog. This includes configuration
         * for compaction, retention, and orphan file deletion operations that can be applied to Iceberg tables in this
         * catalog.
         * </p>
         * 
         * @param icebergOptimizationProperties
         *        A structure that specifies Iceberg table optimization properties for the catalog. This includes
         *        configuration for compaction, retention, and orphan file deletion operations that can be applied to
         *        Iceberg tables in this catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder icebergOptimizationProperties(IcebergOptimizationProperties icebergOptimizationProperties);

        /**
         * <p>
         * A structure that specifies Iceberg table optimization properties for the catalog. This includes configuration
         * for compaction, retention, and orphan file deletion operations that can be applied to Iceberg tables in this
         * catalog.
         * </p>
         * This is a convenience method that creates an instance of the {@link IcebergOptimizationProperties.Builder}
         * avoiding the need to create one manually via {@link IcebergOptimizationProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IcebergOptimizationProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #icebergOptimizationProperties(IcebergOptimizationProperties)}.
         * 
         * @param icebergOptimizationProperties
         *        a consumer that will call methods on {@link IcebergOptimizationProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #icebergOptimizationProperties(IcebergOptimizationProperties)
         */
        default Builder icebergOptimizationProperties(
                Consumer<IcebergOptimizationProperties.Builder> icebergOptimizationProperties) {
            return icebergOptimizationProperties(IcebergOptimizationProperties.builder()
                    .applyMutation(icebergOptimizationProperties).build());
        }

        /**
         * <p>
         * Additional key-value properties for the catalog, such as column statistics optimizations.
         * </p>
         * 
         * @param customProperties
         *        Additional key-value properties for the catalog, such as column statistics optimizations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customProperties(Map<String, String> customProperties);
    }

    static final class BuilderImpl implements Builder {
        private DataLakeAccessProperties dataLakeAccessProperties;

        private IcebergOptimizationProperties icebergOptimizationProperties;

        private Map<String, String> customProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CatalogProperties model) {
            dataLakeAccessProperties(model.dataLakeAccessProperties);
            icebergOptimizationProperties(model.icebergOptimizationProperties);
            customProperties(model.customProperties);
        }

        public final DataLakeAccessProperties.Builder getDataLakeAccessProperties() {
            return dataLakeAccessProperties != null ? dataLakeAccessProperties.toBuilder() : null;
        }

        public final void setDataLakeAccessProperties(DataLakeAccessProperties.BuilderImpl dataLakeAccessProperties) {
            this.dataLakeAccessProperties = dataLakeAccessProperties != null ? dataLakeAccessProperties.build() : null;
        }

        @Override
        public final Builder dataLakeAccessProperties(DataLakeAccessProperties dataLakeAccessProperties) {
            this.dataLakeAccessProperties = dataLakeAccessProperties;
            return this;
        }

        public final IcebergOptimizationProperties.Builder getIcebergOptimizationProperties() {
            return icebergOptimizationProperties != null ? icebergOptimizationProperties.toBuilder() : null;
        }

        public final void setIcebergOptimizationProperties(IcebergOptimizationProperties.BuilderImpl icebergOptimizationProperties) {
            this.icebergOptimizationProperties = icebergOptimizationProperties != null ? icebergOptimizationProperties.build()
                    : null;
        }

        @Override
        public final Builder icebergOptimizationProperties(IcebergOptimizationProperties icebergOptimizationProperties) {
            this.icebergOptimizationProperties = icebergOptimizationProperties;
            return this;
        }

        public final Map<String, String> getCustomProperties() {
            if (customProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return customProperties;
        }

        public final void setCustomProperties(Map<String, String> customProperties) {
            this.customProperties = ParametersMapCopier.copy(customProperties);
        }

        @Override
        public final Builder customProperties(Map<String, String> customProperties) {
            this.customProperties = ParametersMapCopier.copy(customProperties);
            return this;
        }

        @Override
        public CatalogProperties build() {
            return new CatalogProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
