/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies code that runs when a job is run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobCommand implements SdkPojo, Serializable, ToCopyableBuilder<JobCommand.Builder, JobCommand> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(JobCommand::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SCRIPT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScriptLocation").getter(getter(JobCommand::scriptLocation)).setter(setter(Builder::scriptLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScriptLocation").build()).build();

    private static final SdkField<String> PYTHON_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PythonVersion").getter(getter(JobCommand::pythonVersion)).setter(setter(Builder::pythonVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PythonVersion").build()).build();

    private static final SdkField<String> RUNTIME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Runtime")
            .getter(getter(JobCommand::runtime)).setter(setter(Builder::runtime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Runtime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SCRIPT_LOCATION_FIELD, PYTHON_VERSION_FIELD, RUNTIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String scriptLocation;

    private final String pythonVersion;

    private final String runtime;

    private JobCommand(BuilderImpl builder) {
        this.name = builder.name;
        this.scriptLocation = builder.scriptLocation;
        this.pythonVersion = builder.pythonVersion;
        this.runtime = builder.runtime;
    }

    /**
     * <p>
     * The name of the job command. For an Apache Spark ETL job, this must be <code>glueetl</code>. For a Python shell
     * job, it must be <code>pythonshell</code>. For an Apache Spark streaming ETL job, this must be
     * <code>gluestreaming</code>. For a Ray job, this must be <code>glueray</code>.
     * </p>
     * 
     * @return The name of the job command. For an Apache Spark ETL job, this must be <code>glueetl</code>. For a Python
     *         shell job, it must be <code>pythonshell</code>. For an Apache Spark streaming ETL job, this must be
     *         <code>gluestreaming</code>. For a Ray job, this must be <code>glueray</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies the Amazon Simple Storage Service (Amazon S3) path to a script that runs a job.
     * </p>
     * 
     * @return Specifies the Amazon Simple Storage Service (Amazon S3) path to a script that runs a job.
     */
    public final String scriptLocation() {
        return scriptLocation;
    }

    /**
     * <p>
     * The Python version being used to run a Python shell job. Allowed values are 2 or 3.
     * </p>
     * 
     * @return The Python version being used to run a Python shell job. Allowed values are 2 or 3.
     */
    public final String pythonVersion() {
        return pythonVersion;
    }

    /**
     * <p>
     * In Ray jobs, Runtime is used to specify the versions of Ray, Python and additional libraries available in your
     * environment. This field is not used in other job types. For supported runtime environment values, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/ray-jobs-section.html">Supported Ray runtime environments</a> in
     * the Glue Developer Guide.
     * </p>
     * 
     * @return In Ray jobs, Runtime is used to specify the versions of Ray, Python and additional libraries available in
     *         your environment. This field is not used in other job types. For supported runtime environment values,
     *         see <a href="https://docs.aws.amazon.com/glue/latest/dg/ray-jobs-section.html">Supported Ray runtime
     *         environments</a> in the Glue Developer Guide.
     */
    public final String runtime() {
        return runtime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(scriptLocation());
        hashCode = 31 * hashCode + Objects.hashCode(pythonVersion());
        hashCode = 31 * hashCode + Objects.hashCode(runtime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobCommand)) {
            return false;
        }
        JobCommand other = (JobCommand) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(scriptLocation(), other.scriptLocation())
                && Objects.equals(pythonVersion(), other.pythonVersion()) && Objects.equals(runtime(), other.runtime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobCommand").add("Name", name()).add("ScriptLocation", scriptLocation())
                .add("PythonVersion", pythonVersion()).add("Runtime", runtime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ScriptLocation":
            return Optional.ofNullable(clazz.cast(scriptLocation()));
        case "PythonVersion":
            return Optional.ofNullable(clazz.cast(pythonVersion()));
        case "Runtime":
            return Optional.ofNullable(clazz.cast(runtime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("ScriptLocation", SCRIPT_LOCATION_FIELD);
        map.put("PythonVersion", PYTHON_VERSION_FIELD);
        map.put("Runtime", RUNTIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobCommand, T> g) {
        return obj -> g.apply((JobCommand) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobCommand> {
        /**
         * <p>
         * The name of the job command. For an Apache Spark ETL job, this must be <code>glueetl</code>. For a Python
         * shell job, it must be <code>pythonshell</code>. For an Apache Spark streaming ETL job, this must be
         * <code>gluestreaming</code>. For a Ray job, this must be <code>glueray</code>.
         * </p>
         * 
         * @param name
         *        The name of the job command. For an Apache Spark ETL job, this must be <code>glueetl</code>. For a
         *        Python shell job, it must be <code>pythonshell</code>. For an Apache Spark streaming ETL job, this
         *        must be <code>gluestreaming</code>. For a Ray job, this must be <code>glueray</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the Amazon Simple Storage Service (Amazon S3) path to a script that runs a job.
         * </p>
         * 
         * @param scriptLocation
         *        Specifies the Amazon Simple Storage Service (Amazon S3) path to a script that runs a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptLocation(String scriptLocation);

        /**
         * <p>
         * The Python version being used to run a Python shell job. Allowed values are 2 or 3.
         * </p>
         * 
         * @param pythonVersion
         *        The Python version being used to run a Python shell job. Allowed values are 2 or 3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pythonVersion(String pythonVersion);

        /**
         * <p>
         * In Ray jobs, Runtime is used to specify the versions of Ray, Python and additional libraries available in
         * your environment. This field is not used in other job types. For supported runtime environment values, see <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/ray-jobs-section.html">Supported Ray runtime
         * environments</a> in the Glue Developer Guide.
         * </p>
         * 
         * @param runtime
         *        In Ray jobs, Runtime is used to specify the versions of Ray, Python and additional libraries available
         *        in your environment. This field is not used in other job types. For supported runtime environment
         *        values, see <a href="https://docs.aws.amazon.com/glue/latest/dg/ray-jobs-section.html">Supported Ray
         *        runtime environments</a> in the Glue Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtime(String runtime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String scriptLocation;

        private String pythonVersion;

        private String runtime;

        private BuilderImpl() {
        }

        private BuilderImpl(JobCommand model) {
            name(model.name);
            scriptLocation(model.scriptLocation);
            pythonVersion(model.pythonVersion);
            runtime(model.runtime);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getScriptLocation() {
            return scriptLocation;
        }

        public final void setScriptLocation(String scriptLocation) {
            this.scriptLocation = scriptLocation;
        }

        @Override
        public final Builder scriptLocation(String scriptLocation) {
            this.scriptLocation = scriptLocation;
            return this;
        }

        public final String getPythonVersion() {
            return pythonVersion;
        }

        public final void setPythonVersion(String pythonVersion) {
            this.pythonVersion = pythonVersion;
        }

        @Override
        public final Builder pythonVersion(String pythonVersion) {
            this.pythonVersion = pythonVersion;
            return this;
        }

        public final String getRuntime() {
            return runtime;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public JobCommand build() {
            return new JobCommand(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
