/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the output properties of Iceberg table optimization configuration for your catalog resource
 * in the Glue Data Catalog.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IcebergOptimizationPropertiesOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<IcebergOptimizationPropertiesOutput.Builder, IcebergOptimizationPropertiesOutput> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(IcebergOptimizationPropertiesOutput::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<Map<String, String>> COMPACTION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Compaction")
            .getter(getter(IcebergOptimizationPropertiesOutput::compaction))
            .setter(setter(Builder::compaction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compaction").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> RETENTION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Retention")
            .getter(getter(IcebergOptimizationPropertiesOutput::retention))
            .setter(setter(Builder::retention))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Retention").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> ORPHAN_FILE_DELETION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("OrphanFileDeletion")
            .getter(getter(IcebergOptimizationPropertiesOutput::orphanFileDeletion))
            .setter(setter(Builder::orphanFileDeletion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrphanFileDeletion").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(IcebergOptimizationPropertiesOutput::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            COMPACTION_FIELD, RETENTION_FIELD, ORPHAN_FILE_DELETION_FIELD, LAST_UPDATED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final Map<String, String> compaction;

    private final Map<String, String> retention;

    private final Map<String, String> orphanFileDeletion;

    private final Instant lastUpdatedTime;

    private IcebergOptimizationPropertiesOutput(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.compaction = builder.compaction;
        this.retention = builder.retention;
        this.orphanFileDeletion = builder.orphanFileDeletion;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that is used to perform Iceberg table optimization operations.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that is used to perform Iceberg table optimization
     *         operations.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Compaction property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCompaction() {
        return compaction != null && !(compaction instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key-value pairs that specify configuration parameters for Iceberg table compaction operations, which
     * optimize the layout of data files to improve query performance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompaction} method.
     * </p>
     * 
     * @return A map of key-value pairs that specify configuration parameters for Iceberg table compaction operations,
     *         which optimize the layout of data files to improve query performance.
     */
    public final Map<String, String> compaction() {
        return compaction;
    }

    /**
     * For responses, this returns true if the service returned a value for the Retention property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRetention() {
        return retention != null && !(retention instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key-value pairs that specify configuration parameters for Iceberg table retention operations, which
     * manage the lifecycle of table snapshots to control storage costs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRetention} method.
     * </p>
     * 
     * @return A map of key-value pairs that specify configuration parameters for Iceberg table retention operations,
     *         which manage the lifecycle of table snapshots to control storage costs.
     */
    public final Map<String, String> retention() {
        return retention;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrphanFileDeletion property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOrphanFileDeletion() {
        return orphanFileDeletion != null && !(orphanFileDeletion instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key-value pairs that specify configuration parameters for Iceberg orphan file deletion operations, which
     * identify and remove files that are no longer referenced by the table metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrphanFileDeletion} method.
     * </p>
     * 
     * @return A map of key-value pairs that specify configuration parameters for Iceberg orphan file deletion
     *         operations, which identify and remove files that are no longer referenced by the table metadata.
     */
    public final Map<String, String> orphanFileDeletion() {
        return orphanFileDeletion;
    }

    /**
     * <p>
     * The timestamp when the Iceberg optimization properties were last updated.
     * </p>
     * 
     * @return The timestamp when the Iceberg optimization properties were last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasCompaction() ? compaction() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRetention() ? retention() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOrphanFileDeletion() ? orphanFileDeletion() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergOptimizationPropertiesOutput)) {
            return false;
        }
        IcebergOptimizationPropertiesOutput other = (IcebergOptimizationPropertiesOutput) obj;
        return Objects.equals(roleArn(), other.roleArn()) && hasCompaction() == other.hasCompaction()
                && Objects.equals(compaction(), other.compaction()) && hasRetention() == other.hasRetention()
                && Objects.equals(retention(), other.retention()) && hasOrphanFileDeletion() == other.hasOrphanFileDeletion()
                && Objects.equals(orphanFileDeletion(), other.orphanFileDeletion())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IcebergOptimizationPropertiesOutput").add("RoleArn", roleArn())
                .add("Compaction", hasCompaction() ? compaction() : null).add("Retention", hasRetention() ? retention() : null)
                .add("OrphanFileDeletion", hasOrphanFileDeletion() ? orphanFileDeletion() : null)
                .add("LastUpdatedTime", lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Compaction":
            return Optional.ofNullable(clazz.cast(compaction()));
        case "Retention":
            return Optional.ofNullable(clazz.cast(retention()));
        case "OrphanFileDeletion":
            return Optional.ofNullable(clazz.cast(orphanFileDeletion()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Compaction", COMPACTION_FIELD);
        map.put("Retention", RETENTION_FIELD);
        map.put("OrphanFileDeletion", ORPHAN_FILE_DELETION_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergOptimizationPropertiesOutput, T> g) {
        return obj -> g.apply((IcebergOptimizationPropertiesOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IcebergOptimizationPropertiesOutput> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that is used to perform Iceberg table optimization operations.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that is used to perform Iceberg table optimization
         *        operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A map of key-value pairs that specify configuration parameters for Iceberg table compaction operations, which
         * optimize the layout of data files to improve query performance.
         * </p>
         * 
         * @param compaction
         *        A map of key-value pairs that specify configuration parameters for Iceberg table compaction
         *        operations, which optimize the layout of data files to improve query performance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compaction(Map<String, String> compaction);

        /**
         * <p>
         * A map of key-value pairs that specify configuration parameters for Iceberg table retention operations, which
         * manage the lifecycle of table snapshots to control storage costs.
         * </p>
         * 
         * @param retention
         *        A map of key-value pairs that specify configuration parameters for Iceberg table retention operations,
         *        which manage the lifecycle of table snapshots to control storage costs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retention(Map<String, String> retention);

        /**
         * <p>
         * A map of key-value pairs that specify configuration parameters for Iceberg orphan file deletion operations,
         * which identify and remove files that are no longer referenced by the table metadata.
         * </p>
         * 
         * @param orphanFileDeletion
         *        A map of key-value pairs that specify configuration parameters for Iceberg orphan file deletion
         *        operations, which identify and remove files that are no longer referenced by the table metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orphanFileDeletion(Map<String, String> orphanFileDeletion);

        /**
         * <p>
         * The timestamp when the Iceberg optimization properties were last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The timestamp when the Iceberg optimization properties were last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private Map<String, String> compaction = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> retention = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> orphanFileDeletion = DefaultSdkAutoConstructMap.getInstance();

        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergOptimizationPropertiesOutput model) {
            roleArn(model.roleArn);
            compaction(model.compaction);
            retention(model.retention);
            orphanFileDeletion(model.orphanFileDeletion);
            lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, String> getCompaction() {
            if (compaction instanceof SdkAutoConstructMap) {
                return null;
            }
            return compaction;
        }

        public final void setCompaction(Map<String, String> compaction) {
            this.compaction = ParametersMapCopier.copy(compaction);
        }

        @Override
        public final Builder compaction(Map<String, String> compaction) {
            this.compaction = ParametersMapCopier.copy(compaction);
            return this;
        }

        public final Map<String, String> getRetention() {
            if (retention instanceof SdkAutoConstructMap) {
                return null;
            }
            return retention;
        }

        public final void setRetention(Map<String, String> retention) {
            this.retention = ParametersMapCopier.copy(retention);
        }

        @Override
        public final Builder retention(Map<String, String> retention) {
            this.retention = ParametersMapCopier.copy(retention);
            return this;
        }

        public final Map<String, String> getOrphanFileDeletion() {
            if (orphanFileDeletion instanceof SdkAutoConstructMap) {
                return null;
            }
            return orphanFileDeletion;
        }

        public final void setOrphanFileDeletion(Map<String, String> orphanFileDeletion) {
            this.orphanFileDeletion = ParametersMapCopier.copy(orphanFileDeletion);
        }

        @Override
        public final Builder orphanFileDeletion(Map<String, String> orphanFileDeletion) {
            this.orphanFileDeletion = ParametersMapCopier.copy(orphanFileDeletion);
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Override
        public IcebergOptimizationPropertiesOutput build() {
            return new IcebergOptimizationPropertiesOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
