/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of metrics showing the total counts of processed rows and rules, including their pass/fail statistics based
 * on row-level results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataQualityAggregatedMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<DataQualityAggregatedMetrics.Builder, DataQualityAggregatedMetrics> {
    private static final SdkField<Double> TOTAL_ROWS_PROCESSED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("TotalRowsProcessed").getter(getter(DataQualityAggregatedMetrics::totalRowsProcessed))
            .setter(setter(Builder::totalRowsProcessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRowsProcessed").build())
            .build();

    private static final SdkField<Double> TOTAL_ROWS_PASSED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("TotalRowsPassed").getter(getter(DataQualityAggregatedMetrics::totalRowsPassed))
            .setter(setter(Builder::totalRowsPassed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRowsPassed").build()).build();

    private static final SdkField<Double> TOTAL_ROWS_FAILED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("TotalRowsFailed").getter(getter(DataQualityAggregatedMetrics::totalRowsFailed))
            .setter(setter(Builder::totalRowsFailed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRowsFailed").build()).build();

    private static final SdkField<Double> TOTAL_RULES_PROCESSED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("TotalRulesProcessed").getter(getter(DataQualityAggregatedMetrics::totalRulesProcessed))
            .setter(setter(Builder::totalRulesProcessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRulesProcessed").build())
            .build();

    private static final SdkField<Double> TOTAL_RULES_PASSED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("TotalRulesPassed").getter(getter(DataQualityAggregatedMetrics::totalRulesPassed))
            .setter(setter(Builder::totalRulesPassed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRulesPassed").build()).build();

    private static final SdkField<Double> TOTAL_RULES_FAILED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("TotalRulesFailed").getter(getter(DataQualityAggregatedMetrics::totalRulesFailed))
            .setter(setter(Builder::totalRulesFailed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRulesFailed").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_ROWS_PROCESSED_FIELD,
            TOTAL_ROWS_PASSED_FIELD, TOTAL_ROWS_FAILED_FIELD, TOTAL_RULES_PROCESSED_FIELD, TOTAL_RULES_PASSED_FIELD,
            TOTAL_RULES_FAILED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double totalRowsProcessed;

    private final Double totalRowsPassed;

    private final Double totalRowsFailed;

    private final Double totalRulesProcessed;

    private final Double totalRulesPassed;

    private final Double totalRulesFailed;

    private DataQualityAggregatedMetrics(BuilderImpl builder) {
        this.totalRowsProcessed = builder.totalRowsProcessed;
        this.totalRowsPassed = builder.totalRowsPassed;
        this.totalRowsFailed = builder.totalRowsFailed;
        this.totalRulesProcessed = builder.totalRulesProcessed;
        this.totalRulesPassed = builder.totalRulesPassed;
        this.totalRulesFailed = builder.totalRulesFailed;
    }

    /**
     * <p>
     * The total number of rows that were processed during the data quality evaluation.
     * </p>
     * 
     * @return The total number of rows that were processed during the data quality evaluation.
     */
    public final Double totalRowsProcessed() {
        return totalRowsProcessed;
    }

    /**
     * <p>
     * The total number of rows that passed all applicable data quality rules.
     * </p>
     * 
     * @return The total number of rows that passed all applicable data quality rules.
     */
    public final Double totalRowsPassed() {
        return totalRowsPassed;
    }

    /**
     * <p>
     * The total number of rows that failed one or more data quality rules.
     * </p>
     * 
     * @return The total number of rows that failed one or more data quality rules.
     */
    public final Double totalRowsFailed() {
        return totalRowsFailed;
    }

    /**
     * <p>
     * The total number of data quality rules that were evaluated.
     * </p>
     * 
     * @return The total number of data quality rules that were evaluated.
     */
    public final Double totalRulesProcessed() {
        return totalRulesProcessed;
    }

    /**
     * <p>
     * The total number of data quality rules that passed their evaluation criteria.
     * </p>
     * 
     * @return The total number of data quality rules that passed their evaluation criteria.
     */
    public final Double totalRulesPassed() {
        return totalRulesPassed;
    }

    /**
     * <p>
     * The total number of data quality rules that failed their evaluation criteria.
     * </p>
     * 
     * @return The total number of data quality rules that failed their evaluation criteria.
     */
    public final Double totalRulesFailed() {
        return totalRulesFailed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalRowsProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(totalRowsPassed());
        hashCode = 31 * hashCode + Objects.hashCode(totalRowsFailed());
        hashCode = 31 * hashCode + Objects.hashCode(totalRulesProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(totalRulesPassed());
        hashCode = 31 * hashCode + Objects.hashCode(totalRulesFailed());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityAggregatedMetrics)) {
            return false;
        }
        DataQualityAggregatedMetrics other = (DataQualityAggregatedMetrics) obj;
        return Objects.equals(totalRowsProcessed(), other.totalRowsProcessed())
                && Objects.equals(totalRowsPassed(), other.totalRowsPassed())
                && Objects.equals(totalRowsFailed(), other.totalRowsFailed())
                && Objects.equals(totalRulesProcessed(), other.totalRulesProcessed())
                && Objects.equals(totalRulesPassed(), other.totalRulesPassed())
                && Objects.equals(totalRulesFailed(), other.totalRulesFailed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataQualityAggregatedMetrics").add("TotalRowsProcessed", totalRowsProcessed())
                .add("TotalRowsPassed", totalRowsPassed()).add("TotalRowsFailed", totalRowsFailed())
                .add("TotalRulesProcessed", totalRulesProcessed()).add("TotalRulesPassed", totalRulesPassed())
                .add("TotalRulesFailed", totalRulesFailed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalRowsProcessed":
            return Optional.ofNullable(clazz.cast(totalRowsProcessed()));
        case "TotalRowsPassed":
            return Optional.ofNullable(clazz.cast(totalRowsPassed()));
        case "TotalRowsFailed":
            return Optional.ofNullable(clazz.cast(totalRowsFailed()));
        case "TotalRulesProcessed":
            return Optional.ofNullable(clazz.cast(totalRulesProcessed()));
        case "TotalRulesPassed":
            return Optional.ofNullable(clazz.cast(totalRulesPassed()));
        case "TotalRulesFailed":
            return Optional.ofNullable(clazz.cast(totalRulesFailed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TotalRowsProcessed", TOTAL_ROWS_PROCESSED_FIELD);
        map.put("TotalRowsPassed", TOTAL_ROWS_PASSED_FIELD);
        map.put("TotalRowsFailed", TOTAL_ROWS_FAILED_FIELD);
        map.put("TotalRulesProcessed", TOTAL_RULES_PROCESSED_FIELD);
        map.put("TotalRulesPassed", TOTAL_RULES_PASSED_FIELD);
        map.put("TotalRulesFailed", TOTAL_RULES_FAILED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataQualityAggregatedMetrics, T> g) {
        return obj -> g.apply((DataQualityAggregatedMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataQualityAggregatedMetrics> {
        /**
         * <p>
         * The total number of rows that were processed during the data quality evaluation.
         * </p>
         * 
         * @param totalRowsProcessed
         *        The total number of rows that were processed during the data quality evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRowsProcessed(Double totalRowsProcessed);

        /**
         * <p>
         * The total number of rows that passed all applicable data quality rules.
         * </p>
         * 
         * @param totalRowsPassed
         *        The total number of rows that passed all applicable data quality rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRowsPassed(Double totalRowsPassed);

        /**
         * <p>
         * The total number of rows that failed one or more data quality rules.
         * </p>
         * 
         * @param totalRowsFailed
         *        The total number of rows that failed one or more data quality rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRowsFailed(Double totalRowsFailed);

        /**
         * <p>
         * The total number of data quality rules that were evaluated.
         * </p>
         * 
         * @param totalRulesProcessed
         *        The total number of data quality rules that were evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRulesProcessed(Double totalRulesProcessed);

        /**
         * <p>
         * The total number of data quality rules that passed their evaluation criteria.
         * </p>
         * 
         * @param totalRulesPassed
         *        The total number of data quality rules that passed their evaluation criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRulesPassed(Double totalRulesPassed);

        /**
         * <p>
         * The total number of data quality rules that failed their evaluation criteria.
         * </p>
         * 
         * @param totalRulesFailed
         *        The total number of data quality rules that failed their evaluation criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRulesFailed(Double totalRulesFailed);
    }

    static final class BuilderImpl implements Builder {
        private Double totalRowsProcessed;

        private Double totalRowsPassed;

        private Double totalRowsFailed;

        private Double totalRulesProcessed;

        private Double totalRulesPassed;

        private Double totalRulesFailed;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualityAggregatedMetrics model) {
            totalRowsProcessed(model.totalRowsProcessed);
            totalRowsPassed(model.totalRowsPassed);
            totalRowsFailed(model.totalRowsFailed);
            totalRulesProcessed(model.totalRulesProcessed);
            totalRulesPassed(model.totalRulesPassed);
            totalRulesFailed(model.totalRulesFailed);
        }

        public final Double getTotalRowsProcessed() {
            return totalRowsProcessed;
        }

        public final void setTotalRowsProcessed(Double totalRowsProcessed) {
            this.totalRowsProcessed = totalRowsProcessed;
        }

        @Override
        public final Builder totalRowsProcessed(Double totalRowsProcessed) {
            this.totalRowsProcessed = totalRowsProcessed;
            return this;
        }

        public final Double getTotalRowsPassed() {
            return totalRowsPassed;
        }

        public final void setTotalRowsPassed(Double totalRowsPassed) {
            this.totalRowsPassed = totalRowsPassed;
        }

        @Override
        public final Builder totalRowsPassed(Double totalRowsPassed) {
            this.totalRowsPassed = totalRowsPassed;
            return this;
        }

        public final Double getTotalRowsFailed() {
            return totalRowsFailed;
        }

        public final void setTotalRowsFailed(Double totalRowsFailed) {
            this.totalRowsFailed = totalRowsFailed;
        }

        @Override
        public final Builder totalRowsFailed(Double totalRowsFailed) {
            this.totalRowsFailed = totalRowsFailed;
            return this;
        }

        public final Double getTotalRulesProcessed() {
            return totalRulesProcessed;
        }

        public final void setTotalRulesProcessed(Double totalRulesProcessed) {
            this.totalRulesProcessed = totalRulesProcessed;
        }

        @Override
        public final Builder totalRulesProcessed(Double totalRulesProcessed) {
            this.totalRulesProcessed = totalRulesProcessed;
            return this;
        }

        public final Double getTotalRulesPassed() {
            return totalRulesPassed;
        }

        public final void setTotalRulesPassed(Double totalRulesPassed) {
            this.totalRulesPassed = totalRulesPassed;
        }

        @Override
        public final Builder totalRulesPassed(Double totalRulesPassed) {
            this.totalRulesPassed = totalRulesPassed;
            return this;
        }

        public final Double getTotalRulesFailed() {
            return totalRulesFailed;
        }

        public final void setTotalRulesFailed(Double totalRulesFailed) {
            this.totalRulesFailed = totalRulesFailed;
        }

        @Override
        public final Builder totalRulesFailed(Double totalRulesFailed) {
            this.totalRulesFailed = totalRulesFailed;
            return this;
        }

        @Override
        public DataQualityAggregatedMetrics build() {
            return new DataQualityAggregatedMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
