/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output properties of the data lake access configuration for your catalog resource in the Glue Data Catalog.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataLakeAccessPropertiesOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<DataLakeAccessPropertiesOutput.Builder, DataLakeAccessPropertiesOutput> {
    private static final SdkField<Boolean> DATA_LAKE_ACCESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DataLakeAccess").getter(getter(DataLakeAccessPropertiesOutput::dataLakeAccess))
            .setter(setter(Builder::dataLakeAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLakeAccess").build()).build();

    private static final SdkField<String> DATA_TRANSFER_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataTransferRole").getter(getter(DataLakeAccessPropertiesOutput::dataTransferRole))
            .setter(setter(Builder::dataTransferRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTransferRole").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KmsKey")
            .getter(getter(DataLakeAccessPropertiesOutput::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKey").build()).build();

    private static final SdkField<String> MANAGED_WORKGROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagedWorkgroupName").getter(getter(DataLakeAccessPropertiesOutput::managedWorkgroupName))
            .setter(setter(Builder::managedWorkgroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedWorkgroupName").build())
            .build();

    private static final SdkField<String> MANAGED_WORKGROUP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagedWorkgroupStatus").getter(getter(DataLakeAccessPropertiesOutput::managedWorkgroupStatus))
            .setter(setter(Builder::managedWorkgroupStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedWorkgroupStatus").build())
            .build();

    private static final SdkField<String> REDSHIFT_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RedshiftDatabaseName").getter(getter(DataLakeAccessPropertiesOutput::redshiftDatabaseName))
            .setter(setter(Builder::redshiftDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftDatabaseName").build())
            .build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(DataLakeAccessPropertiesOutput::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> CATALOG_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogType").getter(getter(DataLakeAccessPropertiesOutput::catalogType))
            .setter(setter(Builder::catalogType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_LAKE_ACCESS_FIELD,
            DATA_TRANSFER_ROLE_FIELD, KMS_KEY_FIELD, MANAGED_WORKGROUP_NAME_FIELD, MANAGED_WORKGROUP_STATUS_FIELD,
            REDSHIFT_DATABASE_NAME_FIELD, STATUS_MESSAGE_FIELD, CATALOG_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean dataLakeAccess;

    private final String dataTransferRole;

    private final String kmsKey;

    private final String managedWorkgroupName;

    private final String managedWorkgroupStatus;

    private final String redshiftDatabaseName;

    private final String statusMessage;

    private final String catalogType;

    private DataLakeAccessPropertiesOutput(BuilderImpl builder) {
        this.dataLakeAccess = builder.dataLakeAccess;
        this.dataTransferRole = builder.dataTransferRole;
        this.kmsKey = builder.kmsKey;
        this.managedWorkgroupName = builder.managedWorkgroupName;
        this.managedWorkgroupStatus = builder.managedWorkgroupStatus;
        this.redshiftDatabaseName = builder.redshiftDatabaseName;
        this.statusMessage = builder.statusMessage;
        this.catalogType = builder.catalogType;
    }

    /**
     * <p>
     * Turns on or off data lake access for Apache Spark applications that access Amazon Redshift databases in the Data
     * Catalog.
     * </p>
     * 
     * @return Turns on or off data lake access for Apache Spark applications that access Amazon Redshift databases in
     *         the Data Catalog.
     */
    public final Boolean dataLakeAccess() {
        return dataLakeAccess;
    }

    /**
     * <p>
     * A role that will be assumed by Glue for transferring data into/out of the staging bucket during a query.
     * </p>
     * 
     * @return A role that will be assumed by Glue for transferring data into/out of the staging bucket during a query.
     */
    public final String dataTransferRole() {
        return dataTransferRole;
    }

    /**
     * <p>
     * An encryption key that will be used for the staging bucket that will be created along with the catalog.
     * </p>
     * 
     * @return An encryption key that will be used for the staging bucket that will be created along with the catalog.
     */
    public final String kmsKey() {
        return kmsKey;
    }

    /**
     * <p>
     * The managed Redshift Serverless compute name that is created for your catalog resource.
     * </p>
     * 
     * @return The managed Redshift Serverless compute name that is created for your catalog resource.
     */
    public final String managedWorkgroupName() {
        return managedWorkgroupName;
    }

    /**
     * <p>
     * The managed Redshift Serverless compute status.
     * </p>
     * 
     * @return The managed Redshift Serverless compute status.
     */
    public final String managedWorkgroupStatus() {
        return managedWorkgroupStatus;
    }

    /**
     * <p>
     * The default Redshift database resource name in the managed compute.
     * </p>
     * 
     * @return The default Redshift database resource name in the managed compute.
     */
    public final String redshiftDatabaseName() {
        return redshiftDatabaseName;
    }

    /**
     * <p>
     * A message that gives more detailed information about the managed workgroup status.
     * </p>
     * 
     * @return A message that gives more detailed information about the managed workgroup status.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Specifies a federated catalog type for the native catalog resource. The currently supported type is
     * <code>aws:redshift</code>.
     * </p>
     * 
     * @return Specifies a federated catalog type for the native catalog resource. The currently supported type is
     *         <code>aws:redshift</code>.
     */
    public final String catalogType() {
        return catalogType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataLakeAccess());
        hashCode = 31 * hashCode + Objects.hashCode(dataTransferRole());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(managedWorkgroupName());
        hashCode = 31 * hashCode + Objects.hashCode(managedWorkgroupStatus());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(catalogType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeAccessPropertiesOutput)) {
            return false;
        }
        DataLakeAccessPropertiesOutput other = (DataLakeAccessPropertiesOutput) obj;
        return Objects.equals(dataLakeAccess(), other.dataLakeAccess())
                && Objects.equals(dataTransferRole(), other.dataTransferRole()) && Objects.equals(kmsKey(), other.kmsKey())
                && Objects.equals(managedWorkgroupName(), other.managedWorkgroupName())
                && Objects.equals(managedWorkgroupStatus(), other.managedWorkgroupStatus())
                && Objects.equals(redshiftDatabaseName(), other.redshiftDatabaseName())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(catalogType(), other.catalogType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataLakeAccessPropertiesOutput").add("DataLakeAccess", dataLakeAccess())
                .add("DataTransferRole", dataTransferRole()).add("KmsKey", kmsKey())
                .add("ManagedWorkgroupName", managedWorkgroupName()).add("ManagedWorkgroupStatus", managedWorkgroupStatus())
                .add("RedshiftDatabaseName", redshiftDatabaseName()).add("StatusMessage", statusMessage())
                .add("CatalogType", catalogType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataLakeAccess":
            return Optional.ofNullable(clazz.cast(dataLakeAccess()));
        case "DataTransferRole":
            return Optional.ofNullable(clazz.cast(dataTransferRole()));
        case "KmsKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "ManagedWorkgroupName":
            return Optional.ofNullable(clazz.cast(managedWorkgroupName()));
        case "ManagedWorkgroupStatus":
            return Optional.ofNullable(clazz.cast(managedWorkgroupStatus()));
        case "RedshiftDatabaseName":
            return Optional.ofNullable(clazz.cast(redshiftDatabaseName()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "CatalogType":
            return Optional.ofNullable(clazz.cast(catalogType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataLakeAccess", DATA_LAKE_ACCESS_FIELD);
        map.put("DataTransferRole", DATA_TRANSFER_ROLE_FIELD);
        map.put("KmsKey", KMS_KEY_FIELD);
        map.put("ManagedWorkgroupName", MANAGED_WORKGROUP_NAME_FIELD);
        map.put("ManagedWorkgroupStatus", MANAGED_WORKGROUP_STATUS_FIELD);
        map.put("RedshiftDatabaseName", REDSHIFT_DATABASE_NAME_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("CatalogType", CATALOG_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataLakeAccessPropertiesOutput, T> g) {
        return obj -> g.apply((DataLakeAccessPropertiesOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataLakeAccessPropertiesOutput> {
        /**
         * <p>
         * Turns on or off data lake access for Apache Spark applications that access Amazon Redshift databases in the
         * Data Catalog.
         * </p>
         * 
         * @param dataLakeAccess
         *        Turns on or off data lake access for Apache Spark applications that access Amazon Redshift databases
         *        in the Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLakeAccess(Boolean dataLakeAccess);

        /**
         * <p>
         * A role that will be assumed by Glue for transferring data into/out of the staging bucket during a query.
         * </p>
         * 
         * @param dataTransferRole
         *        A role that will be assumed by Glue for transferring data into/out of the staging bucket during a
         *        query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTransferRole(String dataTransferRole);

        /**
         * <p>
         * An encryption key that will be used for the staging bucket that will be created along with the catalog.
         * </p>
         * 
         * @param kmsKey
         *        An encryption key that will be used for the staging bucket that will be created along with the
         *        catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        /**
         * <p>
         * The managed Redshift Serverless compute name that is created for your catalog resource.
         * </p>
         * 
         * @param managedWorkgroupName
         *        The managed Redshift Serverless compute name that is created for your catalog resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedWorkgroupName(String managedWorkgroupName);

        /**
         * <p>
         * The managed Redshift Serverless compute status.
         * </p>
         * 
         * @param managedWorkgroupStatus
         *        The managed Redshift Serverless compute status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedWorkgroupStatus(String managedWorkgroupStatus);

        /**
         * <p>
         * The default Redshift database resource name in the managed compute.
         * </p>
         * 
         * @param redshiftDatabaseName
         *        The default Redshift database resource name in the managed compute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftDatabaseName(String redshiftDatabaseName);

        /**
         * <p>
         * A message that gives more detailed information about the managed workgroup status.
         * </p>
         * 
         * @param statusMessage
         *        A message that gives more detailed information about the managed workgroup status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Specifies a federated catalog type for the native catalog resource. The currently supported type is
         * <code>aws:redshift</code>.
         * </p>
         * 
         * @param catalogType
         *        Specifies a federated catalog type for the native catalog resource. The currently supported type is
         *        <code>aws:redshift</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogType(String catalogType);
    }

    static final class BuilderImpl implements Builder {
        private Boolean dataLakeAccess;

        private String dataTransferRole;

        private String kmsKey;

        private String managedWorkgroupName;

        private String managedWorkgroupStatus;

        private String redshiftDatabaseName;

        private String statusMessage;

        private String catalogType;

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeAccessPropertiesOutput model) {
            dataLakeAccess(model.dataLakeAccess);
            dataTransferRole(model.dataTransferRole);
            kmsKey(model.kmsKey);
            managedWorkgroupName(model.managedWorkgroupName);
            managedWorkgroupStatus(model.managedWorkgroupStatus);
            redshiftDatabaseName(model.redshiftDatabaseName);
            statusMessage(model.statusMessage);
            catalogType(model.catalogType);
        }

        public final Boolean getDataLakeAccess() {
            return dataLakeAccess;
        }

        public final void setDataLakeAccess(Boolean dataLakeAccess) {
            this.dataLakeAccess = dataLakeAccess;
        }

        @Override
        public final Builder dataLakeAccess(Boolean dataLakeAccess) {
            this.dataLakeAccess = dataLakeAccess;
            return this;
        }

        public final String getDataTransferRole() {
            return dataTransferRole;
        }

        public final void setDataTransferRole(String dataTransferRole) {
            this.dataTransferRole = dataTransferRole;
        }

        @Override
        public final Builder dataTransferRole(String dataTransferRole) {
            this.dataTransferRole = dataTransferRole;
            return this;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getManagedWorkgroupName() {
            return managedWorkgroupName;
        }

        public final void setManagedWorkgroupName(String managedWorkgroupName) {
            this.managedWorkgroupName = managedWorkgroupName;
        }

        @Override
        public final Builder managedWorkgroupName(String managedWorkgroupName) {
            this.managedWorkgroupName = managedWorkgroupName;
            return this;
        }

        public final String getManagedWorkgroupStatus() {
            return managedWorkgroupStatus;
        }

        public final void setManagedWorkgroupStatus(String managedWorkgroupStatus) {
            this.managedWorkgroupStatus = managedWorkgroupStatus;
        }

        @Override
        public final Builder managedWorkgroupStatus(String managedWorkgroupStatus) {
            this.managedWorkgroupStatus = managedWorkgroupStatus;
            return this;
        }

        public final String getRedshiftDatabaseName() {
            return redshiftDatabaseName;
        }

        public final void setRedshiftDatabaseName(String redshiftDatabaseName) {
            this.redshiftDatabaseName = redshiftDatabaseName;
        }

        @Override
        public final Builder redshiftDatabaseName(String redshiftDatabaseName) {
            this.redshiftDatabaseName = redshiftDatabaseName;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getCatalogType() {
            return catalogType;
        }

        public final void setCatalogType(String catalogType) {
            this.catalogType = catalogType;
        }

        @Override
        public final Builder catalogType(String catalogType) {
            this.catalogType = catalogType;
            return this;
        }

        @Override
        public DataLakeAccessPropertiesOutput build() {
            return new DataLakeAccessPropertiesOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
