/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDevEndpointResponse extends GlueResponse implements
        ToCopyableBuilder<CreateDevEndpointResponse.Builder, CreateDevEndpointResponse> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(CreateDevEndpointResponse::endpointName))
            .setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CreateDevEndpointResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(CreateDevEndpointResponse::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(CreateDevEndpointResponse::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateDevEndpointResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> YARN_ENDPOINT_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("YarnEndpointAddress").getter(getter(CreateDevEndpointResponse::yarnEndpointAddress))
            .setter(setter(Builder::yarnEndpointAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("YarnEndpointAddress").build())
            .build();

    private static final SdkField<Integer> ZEPPELIN_REMOTE_SPARK_INTERPRETER_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ZeppelinRemoteSparkInterpreterPort")
            .getter(getter(CreateDevEndpointResponse::zeppelinRemoteSparkInterpreterPort))
            .setter(setter(Builder::zeppelinRemoteSparkInterpreterPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZeppelinRemoteSparkInterpreterPort")
                    .build()).build();

    private static final SdkField<Integer> NUMBER_OF_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfNodes").getter(getter(CreateDevEndpointResponse::numberOfNodes))
            .setter(setter(Builder::numberOfNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNodes").build()).build();

    private static final SdkField<String> WORKER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkerType").getter(getter(CreateDevEndpointResponse::workerTypeAsString))
            .setter(setter(Builder::workerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerType").build()).build();

    private static final SdkField<String> GLUE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlueVersion").getter(getter(CreateDevEndpointResponse::glueVersion))
            .setter(setter(Builder::glueVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueVersion").build()).build();

    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfWorkers").getter(getter(CreateDevEndpointResponse::numberOfWorkers))
            .setter(setter(Builder::numberOfWorkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(CreateDevEndpointResponse::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(CreateDevEndpointResponse::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> EXTRA_PYTHON_LIBS_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExtraPythonLibsS3Path").getter(getter(CreateDevEndpointResponse::extraPythonLibsS3Path))
            .setter(setter(Builder::extraPythonLibsS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtraPythonLibsS3Path").build())
            .build();

    private static final SdkField<String> EXTRA_JARS_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExtraJarsS3Path").getter(getter(CreateDevEndpointResponse::extraJarsS3Path))
            .setter(setter(Builder::extraJarsS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtraJarsS3Path").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(CreateDevEndpointResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityConfiguration").getter(getter(CreateDevEndpointResponse::securityConfiguration))
            .setter(setter(Builder::securityConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build())
            .build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(CreateDevEndpointResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Map<String, String>> ARGUMENTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Arguments")
            .getter(getter(CreateDevEndpointResponse::arguments))
            .setter(setter(Builder::arguments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arguments").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD,
            STATUS_FIELD, SECURITY_GROUP_IDS_FIELD, SUBNET_ID_FIELD, ROLE_ARN_FIELD, YARN_ENDPOINT_ADDRESS_FIELD,
            ZEPPELIN_REMOTE_SPARK_INTERPRETER_PORT_FIELD, NUMBER_OF_NODES_FIELD, WORKER_TYPE_FIELD, GLUE_VERSION_FIELD,
            NUMBER_OF_WORKERS_FIELD, AVAILABILITY_ZONE_FIELD, VPC_ID_FIELD, EXTRA_PYTHON_LIBS_S3_PATH_FIELD,
            EXTRA_JARS_S3_PATH_FIELD, FAILURE_REASON_FIELD, SECURITY_CONFIGURATION_FIELD, CREATED_TIMESTAMP_FIELD,
            ARGUMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String endpointName;

    private final String status;

    private final List<String> securityGroupIds;

    private final String subnetId;

    private final String roleArn;

    private final String yarnEndpointAddress;

    private final Integer zeppelinRemoteSparkInterpreterPort;

    private final Integer numberOfNodes;

    private final String workerType;

    private final String glueVersion;

    private final Integer numberOfWorkers;

    private final String availabilityZone;

    private final String vpcId;

    private final String extraPythonLibsS3Path;

    private final String extraJarsS3Path;

    private final String failureReason;

    private final String securityConfiguration;

    private final Instant createdTimestamp;

    private final Map<String, String> arguments;

    private CreateDevEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.status = builder.status;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetId = builder.subnetId;
        this.roleArn = builder.roleArn;
        this.yarnEndpointAddress = builder.yarnEndpointAddress;
        this.zeppelinRemoteSparkInterpreterPort = builder.zeppelinRemoteSparkInterpreterPort;
        this.numberOfNodes = builder.numberOfNodes;
        this.workerType = builder.workerType;
        this.glueVersion = builder.glueVersion;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.availabilityZone = builder.availabilityZone;
        this.vpcId = builder.vpcId;
        this.extraPythonLibsS3Path = builder.extraPythonLibsS3Path;
        this.extraJarsS3Path = builder.extraJarsS3Path;
        this.failureReason = builder.failureReason;
        this.securityConfiguration = builder.securityConfiguration;
        this.createdTimestamp = builder.createdTimestamp;
        this.arguments = builder.arguments;
    }

    /**
     * <p>
     * The name assigned to the new <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The name assigned to the new <code>DevEndpoint</code>.
     */
    public final String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * The current status of the new <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The current status of the new <code>DevEndpoint</code>.
     */
    public final String status() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security groups assigned to the new <code>DevEndpoint</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return The security groups assigned to the new <code>DevEndpoint</code>.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The subnet ID assigned to the new <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The subnet ID assigned to the new <code>DevEndpoint</code>.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role assigned to the new <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role assigned to the new <code>DevEndpoint</code>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The address of the YARN endpoint used by this <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The address of the YARN endpoint used by this <code>DevEndpoint</code>.
     */
    public final String yarnEndpointAddress() {
        return yarnEndpointAddress;
    }

    /**
     * <p>
     * The Apache Zeppelin port for the remote Apache Spark interpreter.
     * </p>
     * 
     * @return The Apache Zeppelin port for the remote Apache Spark interpreter.
     */
    public final Integer zeppelinRemoteSparkInterpreterPort() {
        return zeppelinRemoteSparkInterpreterPort;
    }

    /**
     * <p>
     * The number of Glue Data Processing Units (DPUs) allocated to this DevEndpoint.
     * </p>
     * 
     * @return The number of Glue Data Processing Units (DPUs) allocated to this DevEndpoint.
     */
    public final Integer numberOfNodes() {
        return numberOfNodes;
    }

    /**
     * <p>
     * The type of predefined worker that is allocated to the development endpoint. May be a value of Standard, G.1X, or
     * G.2X.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workerType} will
     * return {@link WorkerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workerTypeAsString}.
     * </p>
     * 
     * @return The type of predefined worker that is allocated to the development endpoint. May be a value of Standard,
     *         G.1X, or G.2X.
     * @see WorkerType
     */
    public final WorkerType workerType() {
        return WorkerType.fromValue(workerType);
    }

    /**
     * <p>
     * The type of predefined worker that is allocated to the development endpoint. May be a value of Standard, G.1X, or
     * G.2X.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workerType} will
     * return {@link WorkerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workerTypeAsString}.
     * </p>
     * 
     * @return The type of predefined worker that is allocated to the development endpoint. May be a value of Standard,
     *         G.1X, or G.2X.
     * @see WorkerType
     */
    public final String workerTypeAsString() {
        return workerType;
    }

    /**
     * <p>
     * Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version indicates
     * the version supported for running your ETL scripts on development endpoints.
     * </p>
     * <p>
     * For more information about the available Glue versions and corresponding Spark and Python versions, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.
     * </p>
     * 
     * @return Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version
     *         indicates the version supported for running your ETL scripts on development endpoints. </p>
     *         <p>
     *         For more information about the available Glue versions and corresponding Spark and Python versions, see
     *         <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer
     *         guide.
     */
    public final String glueVersion() {
        return glueVersion;
    }

    /**
     * <p>
     * The number of workers of a defined <code>workerType</code> that are allocated to the development endpoint.
     * </p>
     * 
     * @return The number of workers of a defined <code>workerType</code> that are allocated to the development
     *         endpoint.
     */
    public final Integer numberOfWorkers() {
        return numberOfWorkers;
    }

    /**
     * <p>
     * The Amazon Web Services Availability Zone where this <code>DevEndpoint</code> is located.
     * </p>
     * 
     * @return The Amazon Web Services Availability Zone where this <code>DevEndpoint</code> is located.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The ID of the virtual private cloud (VPC) used by this <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The ID of the virtual private cloud (VPC) used by this <code>DevEndpoint</code>.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The paths to one or more Python libraries in an S3 bucket that will be loaded in your <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The paths to one or more Python libraries in an S3 bucket that will be loaded in your
     *         <code>DevEndpoint</code>.
     */
    public final String extraPythonLibsS3Path() {
        return extraPythonLibsS3Path;
    }

    /**
     * <p>
     * Path to one or more Java <code>.jar</code> files in an S3 bucket that will be loaded in your
     * <code>DevEndpoint</code>.
     * </p>
     * 
     * @return Path to one or more Java <code>.jar</code> files in an S3 bucket that will be loaded in your
     *         <code>DevEndpoint</code>.
     */
    public final String extraJarsS3Path() {
        return extraJarsS3Path;
    }

    /**
     * <p>
     * The reason for a current failure in this <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The reason for a current failure in this <code>DevEndpoint</code>.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The name of the <code>SecurityConfiguration</code> structure being used with this <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The name of the <code>SecurityConfiguration</code> structure being used with this
     *         <code>DevEndpoint</code>.
     */
    public final String securityConfiguration() {
        return securityConfiguration;
    }

    /**
     * <p>
     * The point in time at which this <code>DevEndpoint</code> was created.
     * </p>
     * 
     * @return The point in time at which this <code>DevEndpoint</code> was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the Arguments property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasArguments() {
        return arguments != null && !(arguments instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The map of arguments used to configure this <code>DevEndpoint</code>.
     * </p>
     * <p>
     * Valid arguments are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>"--enable-glue-datacatalog": ""</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can specify a version of Python support for development endpoints by using the <code>Arguments</code>
     * parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are
     * provided, the version defaults to Python 2.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArguments} method.
     * </p>
     * 
     * @return The map of arguments used to configure this <code>DevEndpoint</code>.</p>
     *         <p>
     *         Valid arguments are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>"--enable-glue-datacatalog": ""</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can specify a version of Python support for development endpoints by using the <code>Arguments</code>
     *         parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments
     *         are provided, the version defaults to Python 2.
     */
    public final Map<String, String> arguments() {
        return arguments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(yarnEndpointAddress());
        hashCode = 31 * hashCode + Objects.hashCode(zeppelinRemoteSparkInterpreterPort());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(workerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(glueVersion());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(extraPythonLibsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(extraJarsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(hasArguments() ? arguments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDevEndpointResponse)) {
            return false;
        }
        CreateDevEndpointResponse other = (CreateDevEndpointResponse) obj;
        return Objects.equals(endpointName(), other.endpointName()) && Objects.equals(status(), other.status())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(yarnEndpointAddress(), other.yarnEndpointAddress())
                && Objects.equals(zeppelinRemoteSparkInterpreterPort(), other.zeppelinRemoteSparkInterpreterPort())
                && Objects.equals(numberOfNodes(), other.numberOfNodes())
                && Objects.equals(workerTypeAsString(), other.workerTypeAsString())
                && Objects.equals(glueVersion(), other.glueVersion())
                && Objects.equals(numberOfWorkers(), other.numberOfWorkers())
                && Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(extraPythonLibsS3Path(), other.extraPythonLibsS3Path())
                && Objects.equals(extraJarsS3Path(), other.extraJarsS3Path())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(securityConfiguration(), other.securityConfiguration())
                && Objects.equals(createdTimestamp(), other.createdTimestamp()) && hasArguments() == other.hasArguments()
                && Objects.equals(arguments(), other.arguments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDevEndpointResponse").add("EndpointName", endpointName()).add("Status", status())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null).add("SubnetId", subnetId())
                .add("RoleArn", roleArn()).add("YarnEndpointAddress", yarnEndpointAddress())
                .add("ZeppelinRemoteSparkInterpreterPort", zeppelinRemoteSparkInterpreterPort())
                .add("NumberOfNodes", numberOfNodes()).add("WorkerType", workerTypeAsString()).add("GlueVersion", glueVersion())
                .add("NumberOfWorkers", numberOfWorkers()).add("AvailabilityZone", availabilityZone()).add("VpcId", vpcId())
                .add("ExtraPythonLibsS3Path", extraPythonLibsS3Path()).add("ExtraJarsS3Path", extraJarsS3Path())
                .add("FailureReason", failureReason()).add("SecurityConfiguration", securityConfiguration())
                .add("CreatedTimestamp", createdTimestamp()).add("Arguments", hasArguments() ? arguments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "YarnEndpointAddress":
            return Optional.ofNullable(clazz.cast(yarnEndpointAddress()));
        case "ZeppelinRemoteSparkInterpreterPort":
            return Optional.ofNullable(clazz.cast(zeppelinRemoteSparkInterpreterPort()));
        case "NumberOfNodes":
            return Optional.ofNullable(clazz.cast(numberOfNodes()));
        case "WorkerType":
            return Optional.ofNullable(clazz.cast(workerTypeAsString()));
        case "GlueVersion":
            return Optional.ofNullable(clazz.cast(glueVersion()));
        case "NumberOfWorkers":
            return Optional.ofNullable(clazz.cast(numberOfWorkers()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "ExtraPythonLibsS3Path":
            return Optional.ofNullable(clazz.cast(extraPythonLibsS3Path()));
        case "ExtraJarsS3Path":
            return Optional.ofNullable(clazz.cast(extraJarsS3Path()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "SecurityConfiguration":
            return Optional.ofNullable(clazz.cast(securityConfiguration()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "Arguments":
            return Optional.ofNullable(clazz.cast(arguments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EndpointName", ENDPOINT_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("YarnEndpointAddress", YARN_ENDPOINT_ADDRESS_FIELD);
        map.put("ZeppelinRemoteSparkInterpreterPort", ZEPPELIN_REMOTE_SPARK_INTERPRETER_PORT_FIELD);
        map.put("NumberOfNodes", NUMBER_OF_NODES_FIELD);
        map.put("WorkerType", WORKER_TYPE_FIELD);
        map.put("GlueVersion", GLUE_VERSION_FIELD);
        map.put("NumberOfWorkers", NUMBER_OF_WORKERS_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("ExtraPythonLibsS3Path", EXTRA_PYTHON_LIBS_S3_PATH_FIELD);
        map.put("ExtraJarsS3Path", EXTRA_JARS_S3_PATH_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("SecurityConfiguration", SECURITY_CONFIGURATION_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("Arguments", ARGUMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDevEndpointResponse, T> g) {
        return obj -> g.apply((CreateDevEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDevEndpointResponse> {
        /**
         * <p>
         * The name assigned to the new <code>DevEndpoint</code>.
         * </p>
         * 
         * @param endpointName
         *        The name assigned to the new <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * The current status of the new <code>DevEndpoint</code>.
         * </p>
         * 
         * @param status
         *        The current status of the new <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The security groups assigned to the new <code>DevEndpoint</code>.
         * </p>
         * 
         * @param securityGroupIds
         *        The security groups assigned to the new <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The security groups assigned to the new <code>DevEndpoint</code>.
         * </p>
         * 
         * @param securityGroupIds
         *        The security groups assigned to the new <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The subnet ID assigned to the new <code>DevEndpoint</code>.
         * </p>
         * 
         * @param subnetId
         *        The subnet ID assigned to the new <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role assigned to the new <code>DevEndpoint</code>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role assigned to the new <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The address of the YARN endpoint used by this <code>DevEndpoint</code>.
         * </p>
         * 
         * @param yarnEndpointAddress
         *        The address of the YARN endpoint used by this <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder yarnEndpointAddress(String yarnEndpointAddress);

        /**
         * <p>
         * The Apache Zeppelin port for the remote Apache Spark interpreter.
         * </p>
         * 
         * @param zeppelinRemoteSparkInterpreterPort
         *        The Apache Zeppelin port for the remote Apache Spark interpreter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zeppelinRemoteSparkInterpreterPort(Integer zeppelinRemoteSparkInterpreterPort);

        /**
         * <p>
         * The number of Glue Data Processing Units (DPUs) allocated to this DevEndpoint.
         * </p>
         * 
         * @param numberOfNodes
         *        The number of Glue Data Processing Units (DPUs) allocated to this DevEndpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfNodes(Integer numberOfNodes);

        /**
         * <p>
         * The type of predefined worker that is allocated to the development endpoint. May be a value of Standard,
         * G.1X, or G.2X.
         * </p>
         * 
         * @param workerType
         *        The type of predefined worker that is allocated to the development endpoint. May be a value of
         *        Standard, G.1X, or G.2X.
         * @see WorkerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerType
         */
        Builder workerType(String workerType);

        /**
         * <p>
         * The type of predefined worker that is allocated to the development endpoint. May be a value of Standard,
         * G.1X, or G.2X.
         * </p>
         * 
         * @param workerType
         *        The type of predefined worker that is allocated to the development endpoint. May be a value of
         *        Standard, G.1X, or G.2X.
         * @see WorkerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerType
         */
        Builder workerType(WorkerType workerType);

        /**
         * <p>
         * Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version
         * indicates the version supported for running your ETL scripts on development endpoints.
         * </p>
         * <p>
         * For more information about the available Glue versions and corresponding Spark and Python versions, see <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.
         * </p>
         * 
         * @param glueVersion
         *        Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version
         *        indicates the version supported for running your ETL scripts on development endpoints. </p>
         *        <p>
         *        For more information about the available Glue versions and corresponding Spark and Python versions,
         *        see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the
         *        developer guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueVersion(String glueVersion);

        /**
         * <p>
         * The number of workers of a defined <code>workerType</code> that are allocated to the development endpoint.
         * </p>
         * 
         * @param numberOfWorkers
         *        The number of workers of a defined <code>workerType</code> that are allocated to the development
         *        endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfWorkers(Integer numberOfWorkers);

        /**
         * <p>
         * The Amazon Web Services Availability Zone where this <code>DevEndpoint</code> is located.
         * </p>
         * 
         * @param availabilityZone
         *        The Amazon Web Services Availability Zone where this <code>DevEndpoint</code> is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The ID of the virtual private cloud (VPC) used by this <code>DevEndpoint</code>.
         * </p>
         * 
         * @param vpcId
         *        The ID of the virtual private cloud (VPC) used by this <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The paths to one or more Python libraries in an S3 bucket that will be loaded in your
         * <code>DevEndpoint</code>.
         * </p>
         * 
         * @param extraPythonLibsS3Path
         *        The paths to one or more Python libraries in an S3 bucket that will be loaded in your
         *        <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraPythonLibsS3Path(String extraPythonLibsS3Path);

        /**
         * <p>
         * Path to one or more Java <code>.jar</code> files in an S3 bucket that will be loaded in your
         * <code>DevEndpoint</code>.
         * </p>
         * 
         * @param extraJarsS3Path
         *        Path to one or more Java <code>.jar</code> files in an S3 bucket that will be loaded in your
         *        <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraJarsS3Path(String extraJarsS3Path);

        /**
         * <p>
         * The reason for a current failure in this <code>DevEndpoint</code>.
         * </p>
         * 
         * @param failureReason
         *        The reason for a current failure in this <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The name of the <code>SecurityConfiguration</code> structure being used with this <code>DevEndpoint</code>.
         * </p>
         * 
         * @param securityConfiguration
         *        The name of the <code>SecurityConfiguration</code> structure being used with this
         *        <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfiguration(String securityConfiguration);

        /**
         * <p>
         * The point in time at which this <code>DevEndpoint</code> was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The point in time at which this <code>DevEndpoint</code> was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The map of arguments used to configure this <code>DevEndpoint</code>.
         * </p>
         * <p>
         * Valid arguments are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>"--enable-glue-datacatalog": ""</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can specify a version of Python support for development endpoints by using the <code>Arguments</code>
         * parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are
         * provided, the version defaults to Python 2.
         * </p>
         * 
         * @param arguments
         *        The map of arguments used to configure this <code>DevEndpoint</code>.</p>
         *        <p>
         *        Valid arguments are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>"--enable-glue-datacatalog": ""</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can specify a version of Python support for development endpoints by using the
         *        <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or
         *        <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arguments(Map<String, String> arguments);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private String endpointName;

        private String status;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String subnetId;

        private String roleArn;

        private String yarnEndpointAddress;

        private Integer zeppelinRemoteSparkInterpreterPort;

        private Integer numberOfNodes;

        private String workerType;

        private String glueVersion;

        private Integer numberOfWorkers;

        private String availabilityZone;

        private String vpcId;

        private String extraPythonLibsS3Path;

        private String extraJarsS3Path;

        private String failureReason;

        private String securityConfiguration;

        private Instant createdTimestamp;

        private Map<String, String> arguments = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDevEndpointResponse model) {
            super(model);
            endpointName(model.endpointName);
            status(model.status);
            securityGroupIds(model.securityGroupIds);
            subnetId(model.subnetId);
            roleArn(model.roleArn);
            yarnEndpointAddress(model.yarnEndpointAddress);
            zeppelinRemoteSparkInterpreterPort(model.zeppelinRemoteSparkInterpreterPort);
            numberOfNodes(model.numberOfNodes);
            workerType(model.workerType);
            glueVersion(model.glueVersion);
            numberOfWorkers(model.numberOfWorkers);
            availabilityZone(model.availabilityZone);
            vpcId(model.vpcId);
            extraPythonLibsS3Path(model.extraPythonLibsS3Path);
            extraJarsS3Path(model.extraJarsS3Path);
            failureReason(model.failureReason);
            securityConfiguration(model.securityConfiguration);
            createdTimestamp(model.createdTimestamp);
            arguments(model.arguments);
        }

        public final String getEndpointName() {
            return endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getYarnEndpointAddress() {
            return yarnEndpointAddress;
        }

        public final void setYarnEndpointAddress(String yarnEndpointAddress) {
            this.yarnEndpointAddress = yarnEndpointAddress;
        }

        @Override
        public final Builder yarnEndpointAddress(String yarnEndpointAddress) {
            this.yarnEndpointAddress = yarnEndpointAddress;
            return this;
        }

        public final Integer getZeppelinRemoteSparkInterpreterPort() {
            return zeppelinRemoteSparkInterpreterPort;
        }

        public final void setZeppelinRemoteSparkInterpreterPort(Integer zeppelinRemoteSparkInterpreterPort) {
            this.zeppelinRemoteSparkInterpreterPort = zeppelinRemoteSparkInterpreterPort;
        }

        @Override
        public final Builder zeppelinRemoteSparkInterpreterPort(Integer zeppelinRemoteSparkInterpreterPort) {
            this.zeppelinRemoteSparkInterpreterPort = zeppelinRemoteSparkInterpreterPort;
            return this;
        }

        public final Integer getNumberOfNodes() {
            return numberOfNodes;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final String getWorkerType() {
            return workerType;
        }

        public final void setWorkerType(String workerType) {
            this.workerType = workerType;
        }

        @Override
        public final Builder workerType(String workerType) {
            this.workerType = workerType;
            return this;
        }

        @Override
        public final Builder workerType(WorkerType workerType) {
            this.workerType(workerType == null ? null : workerType.toString());
            return this;
        }

        public final String getGlueVersion() {
            return glueVersion;
        }

        public final void setGlueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
        }

        @Override
        public final Builder glueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
            return this;
        }

        public final Integer getNumberOfWorkers() {
            return numberOfWorkers;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getExtraPythonLibsS3Path() {
            return extraPythonLibsS3Path;
        }

        public final void setExtraPythonLibsS3Path(String extraPythonLibsS3Path) {
            this.extraPythonLibsS3Path = extraPythonLibsS3Path;
        }

        @Override
        public final Builder extraPythonLibsS3Path(String extraPythonLibsS3Path) {
            this.extraPythonLibsS3Path = extraPythonLibsS3Path;
            return this;
        }

        public final String getExtraJarsS3Path() {
            return extraJarsS3Path;
        }

        public final void setExtraJarsS3Path(String extraJarsS3Path) {
            this.extraJarsS3Path = extraJarsS3Path;
        }

        @Override
        public final Builder extraJarsS3Path(String extraJarsS3Path) {
            this.extraJarsS3Path = extraJarsS3Path;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getSecurityConfiguration() {
            return securityConfiguration;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Map<String, String> getArguments() {
            if (arguments instanceof SdkAutoConstructMap) {
                return null;
            }
            return arguments;
        }

        public final void setArguments(Map<String, String> arguments) {
            this.arguments = MapValueCopier.copy(arguments);
        }

        @Override
        public final Builder arguments(Map<String, String> arguments) {
            this.arguments = MapValueCopier.copy(arguments);
            return this;
        }

        @Override
        public CreateDevEndpointResponse build() {
            return new CreateDevEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
