/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.CompactionStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IcebergCompactionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IcebergCompactionConfiguration> {
    private static final SdkField<String> STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("strategy").getter(IcebergCompactionConfiguration.getter(IcebergCompactionConfiguration::strategyAsString)).setter(IcebergCompactionConfiguration.setter(Builder::strategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRATEGY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IcebergCompactionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String strategy;

    private IcebergCompactionConfiguration(BuilderImpl builder) {
        this.strategy = builder.strategy;
    }

    public final CompactionStrategy strategy() {
        return CompactionStrategy.fromValue(this.strategy);
    }

    public final String strategyAsString() {
        return this.strategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergCompactionConfiguration)) {
            return false;
        }
        IcebergCompactionConfiguration other = (IcebergCompactionConfiguration)obj;
        return Objects.equals(this.strategyAsString(), other.strategyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IcebergCompactionConfiguration").add("Strategy", (Object)this.strategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "strategy": {
                return Optional.ofNullable(clazz.cast(this.strategyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("strategy", STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergCompactionConfiguration, T> g) {
        return obj -> g.apply((IcebergCompactionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String strategy;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergCompactionConfiguration model) {
            this.strategy(model.strategy);
        }

        public final String getStrategy() {
            return this.strategy;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(CompactionStrategy strategy) {
            this.strategy(strategy == null ? null : strategy.toString());
            return this;
        }

        public IcebergCompactionConfiguration build() {
            return new IcebergCompactionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IcebergCompactionConfiguration> {
        public Builder strategy(String var1);

        public Builder strategy(CompactionStrategy var1);
    }
}

