/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an Amazon DocumentDB or MongoDB data store to crawl.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MongoDBTarget implements SdkPojo, Serializable, ToCopyableBuilder<MongoDBTarget.Builder, MongoDBTarget> {
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionName").getter(getter(MongoDBTarget::connectionName)).setter(setter(Builder::connectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(MongoDBTarget::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<Boolean> SCAN_ALL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ScanAll").getter(getter(MongoDBTarget::scanAll)).setter(setter(Builder::scanAll))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanAll").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_NAME_FIELD,
            PATH_FIELD, SCAN_ALL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connectionName;

    private final String path;

    private final Boolean scanAll;

    private MongoDBTarget(BuilderImpl builder) {
        this.connectionName = builder.connectionName;
        this.path = builder.path;
        this.scanAll = builder.scanAll;
    }

    /**
     * <p>
     * The name of the connection to use to connect to the Amazon DocumentDB or MongoDB target.
     * </p>
     * 
     * @return The name of the connection to use to connect to the Amazon DocumentDB or MongoDB target.
     */
    public final String connectionName() {
        return connectionName;
    }

    /**
     * <p>
     * The path of the Amazon DocumentDB or MongoDB target (database/collection).
     * </p>
     * 
     * @return The path of the Amazon DocumentDB or MongoDB target (database/collection).
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can take a
     * long time when the table is not a high throughput table.
     * </p>
     * <p>
     * A value of <code>true</code> means to scan all records, while a value of <code>false</code> means to sample the
     * records. If no value is specified, the value defaults to <code>true</code>.
     * </p>
     * 
     * @return Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can
     *         take a long time when the table is not a high throughput table.</p>
     *         <p>
     *         A value of <code>true</code> means to scan all records, while a value of <code>false</code> means to
     *         sample the records. If no value is specified, the value defaults to <code>true</code>.
     */
    public final Boolean scanAll() {
        return scanAll;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(scanAll());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MongoDBTarget)) {
            return false;
        }
        MongoDBTarget other = (MongoDBTarget) obj;
        return Objects.equals(connectionName(), other.connectionName()) && Objects.equals(path(), other.path())
                && Objects.equals(scanAll(), other.scanAll());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MongoDBTarget").add("ConnectionName", connectionName()).add("Path", path())
                .add("ScanAll", scanAll()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionName":
            return Optional.ofNullable(clazz.cast(connectionName()));
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "ScanAll":
            return Optional.ofNullable(clazz.cast(scanAll()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectionName", CONNECTION_NAME_FIELD);
        map.put("Path", PATH_FIELD);
        map.put("ScanAll", SCAN_ALL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MongoDBTarget, T> g) {
        return obj -> g.apply((MongoDBTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MongoDBTarget> {
        /**
         * <p>
         * The name of the connection to use to connect to the Amazon DocumentDB or MongoDB target.
         * </p>
         * 
         * @param connectionName
         *        The name of the connection to use to connect to the Amazon DocumentDB or MongoDB target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionName(String connectionName);

        /**
         * <p>
         * The path of the Amazon DocumentDB or MongoDB target (database/collection).
         * </p>
         * 
         * @param path
         *        The path of the Amazon DocumentDB or MongoDB target (database/collection).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can
         * take a long time when the table is not a high throughput table.
         * </p>
         * <p>
         * A value of <code>true</code> means to scan all records, while a value of <code>false</code> means to sample
         * the records. If no value is specified, the value defaults to <code>true</code>.
         * </p>
         * 
         * @param scanAll
         *        Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records
         *        can take a long time when the table is not a high throughput table.</p>
         *        <p>
         *        A value of <code>true</code> means to scan all records, while a value of <code>false</code> means to
         *        sample the records. If no value is specified, the value defaults to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanAll(Boolean scanAll);
    }

    static final class BuilderImpl implements Builder {
        private String connectionName;

        private String path;

        private Boolean scanAll;

        private BuilderImpl() {
        }

        private BuilderImpl(MongoDBTarget model) {
            connectionName(model.connectionName);
            path(model.path);
            scanAll(model.scanAll);
        }

        public final String getConnectionName() {
            return connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Boolean getScanAll() {
            return scanAll;
        }

        public final void setScanAll(Boolean scanAll) {
            this.scanAll = scanAll;
        }

        @Override
        public final Builder scanAll(Boolean scanAll) {
            this.scanAll = scanAll;
            return this;
        }

        @Override
        public MongoDBTarget build() {
            return new MongoDBTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
