/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEntityRequest extends GlueRequest implements
        ToCopyableBuilder<DescribeEntityRequest.Builder, DescribeEntityRequest> {
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionName").getter(getter(DescribeEntityRequest::connectionName))
            .setter(setter(Builder::connectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()).build();

    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(DescribeEntityRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> ENTITY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityName").getter(getter(DescribeEntityRequest::entityName)).setter(setter(Builder::entityName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityName").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeEntityRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> DATA_STORE_API_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataStoreApiVersion").getter(getter(DescribeEntityRequest::dataStoreApiVersion))
            .setter(setter(Builder::dataStoreApiVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStoreApiVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_NAME_FIELD,
            CATALOG_ID_FIELD, ENTITY_NAME_FIELD, NEXT_TOKEN_FIELD, DATA_STORE_API_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String connectionName;

    private final String catalogId;

    private final String entityName;

    private final String nextToken;

    private final String dataStoreApiVersion;

    private DescribeEntityRequest(BuilderImpl builder) {
        super(builder);
        this.connectionName = builder.connectionName;
        this.catalogId = builder.catalogId;
        this.entityName = builder.entityName;
        this.nextToken = builder.nextToken;
        this.dataStoreApiVersion = builder.dataStoreApiVersion;
    }

    /**
     * <p>
     * The name of the connection that contains the connection type credentials.
     * </p>
     * 
     * @return The name of the connection that contains the connection type credentials.
     */
    public final String connectionName() {
        return connectionName;
    }

    /**
     * <p>
     * The catalog ID of the catalog that contains the connection. This can be null, By default, the Amazon Web Services
     * Account ID is the catalog ID.
     * </p>
     * 
     * @return The catalog ID of the catalog that contains the connection. This can be null, By default, the Amazon Web
     *         Services Account ID is the catalog ID.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The name of the entity that you want to describe from the connection type.
     * </p>
     * 
     * @return The name of the entity that you want to describe from the connection type.
     */
    public final String entityName() {
        return entityName;
    }

    /**
     * <p>
     * A continuation token, included if this is a continuation call.
     * </p>
     * 
     * @return A continuation token, included if this is a continuation call.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The version of the API used for the data store.
     * </p>
     * 
     * @return The version of the API used for the data store.
     */
    public final String dataStoreApiVersion() {
        return dataStoreApiVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(entityName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(dataStoreApiVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEntityRequest)) {
            return false;
        }
        DescribeEntityRequest other = (DescribeEntityRequest) obj;
        return Objects.equals(connectionName(), other.connectionName()) && Objects.equals(catalogId(), other.catalogId())
                && Objects.equals(entityName(), other.entityName()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(dataStoreApiVersion(), other.dataStoreApiVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEntityRequest").add("ConnectionName", connectionName()).add("CatalogId", catalogId())
                .add("EntityName", entityName()).add("NextToken", nextToken()).add("DataStoreApiVersion", dataStoreApiVersion())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionName":
            return Optional.ofNullable(clazz.cast(connectionName()));
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "EntityName":
            return Optional.ofNullable(clazz.cast(entityName()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "DataStoreApiVersion":
            return Optional.ofNullable(clazz.cast(dataStoreApiVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectionName", CONNECTION_NAME_FIELD);
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("EntityName", ENTITY_NAME_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("DataStoreApiVersion", DATA_STORE_API_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEntityRequest, T> g) {
        return obj -> g.apply((DescribeEntityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEntityRequest> {
        /**
         * <p>
         * The name of the connection that contains the connection type credentials.
         * </p>
         * 
         * @param connectionName
         *        The name of the connection that contains the connection type credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionName(String connectionName);

        /**
         * <p>
         * The catalog ID of the catalog that contains the connection. This can be null, By default, the Amazon Web
         * Services Account ID is the catalog ID.
         * </p>
         * 
         * @param catalogId
         *        The catalog ID of the catalog that contains the connection. This can be null, By default, the Amazon
         *        Web Services Account ID is the catalog ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The name of the entity that you want to describe from the connection type.
         * </p>
         * 
         * @param entityName
         *        The name of the entity that you want to describe from the connection type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityName(String entityName);

        /**
         * <p>
         * A continuation token, included if this is a continuation call.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, included if this is a continuation call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The version of the API used for the data store.
         * </p>
         * 
         * @param dataStoreApiVersion
         *        The version of the API used for the data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataStoreApiVersion(String dataStoreApiVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String connectionName;

        private String catalogId;

        private String entityName;

        private String nextToken;

        private String dataStoreApiVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEntityRequest model) {
            super(model);
            connectionName(model.connectionName);
            catalogId(model.catalogId);
            entityName(model.entityName);
            nextToken(model.nextToken);
            dataStoreApiVersion(model.dataStoreApiVersion);
        }

        public final String getConnectionName() {
            return connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getEntityName() {
            return entityName;
        }

        public final void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public final Builder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getDataStoreApiVersion() {
            return dataStoreApiVersion;
        }

        public final void setDataStoreApiVersion(String dataStoreApiVersion) {
            this.dataStoreApiVersion = dataStoreApiVersion;
        }

        @Override
        public final Builder dataStoreApiVersion(String dataStoreApiVersion) {
            this.dataStoreApiVersion = dataStoreApiVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEntityRequest build() {
            return new DescribeEntityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
