/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The confusion matrix shows you what your transform is predicting accurately and what types of errors it is making.
 * </p>
 * <p>
 * For more information, see <a href="https://en.wikipedia.org/wiki/Confusion_matrix">Confusion matrix</a> in Wikipedia.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfusionMatrix implements SdkPojo, Serializable, ToCopyableBuilder<ConfusionMatrix.Builder, ConfusionMatrix> {
    private static final SdkField<Long> NUM_TRUE_POSITIVES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumTruePositives").getter(getter(ConfusionMatrix::numTruePositives))
            .setter(setter(Builder::numTruePositives))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumTruePositives").build()).build();

    private static final SdkField<Long> NUM_FALSE_POSITIVES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumFalsePositives").getter(getter(ConfusionMatrix::numFalsePositives))
            .setter(setter(Builder::numFalsePositives))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumFalsePositives").build()).build();

    private static final SdkField<Long> NUM_TRUE_NEGATIVES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumTrueNegatives").getter(getter(ConfusionMatrix::numTrueNegatives))
            .setter(setter(Builder::numTrueNegatives))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumTrueNegatives").build()).build();

    private static final SdkField<Long> NUM_FALSE_NEGATIVES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumFalseNegatives").getter(getter(ConfusionMatrix::numFalseNegatives))
            .setter(setter(Builder::numFalseNegatives))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumFalseNegatives").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUM_TRUE_POSITIVES_FIELD,
            NUM_FALSE_POSITIVES_FIELD, NUM_TRUE_NEGATIVES_FIELD, NUM_FALSE_NEGATIVES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long numTruePositives;

    private final Long numFalsePositives;

    private final Long numTrueNegatives;

    private final Long numFalseNegatives;

    private ConfusionMatrix(BuilderImpl builder) {
        this.numTruePositives = builder.numTruePositives;
        this.numFalsePositives = builder.numFalsePositives;
        this.numTrueNegatives = builder.numTrueNegatives;
        this.numFalseNegatives = builder.numFalseNegatives;
    }

    /**
     * <p>
     * The number of matches in the data that the transform correctly found, in the confusion matrix for your transform.
     * </p>
     * 
     * @return The number of matches in the data that the transform correctly found, in the confusion matrix for your
     *         transform.
     */
    public final Long numTruePositives() {
        return numTruePositives;
    }

    /**
     * <p>
     * The number of nonmatches in the data that the transform incorrectly classified as a match, in the confusion
     * matrix for your transform.
     * </p>
     * 
     * @return The number of nonmatches in the data that the transform incorrectly classified as a match, in the
     *         confusion matrix for your transform.
     */
    public final Long numFalsePositives() {
        return numFalsePositives;
    }

    /**
     * <p>
     * The number of nonmatches in the data that the transform correctly rejected, in the confusion matrix for your
     * transform.
     * </p>
     * 
     * @return The number of nonmatches in the data that the transform correctly rejected, in the confusion matrix for
     *         your transform.
     */
    public final Long numTrueNegatives() {
        return numTrueNegatives;
    }

    /**
     * <p>
     * The number of matches in the data that the transform didn't find, in the confusion matrix for your transform.
     * </p>
     * 
     * @return The number of matches in the data that the transform didn't find, in the confusion matrix for your
     *         transform.
     */
    public final Long numFalseNegatives() {
        return numFalseNegatives;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numTruePositives());
        hashCode = 31 * hashCode + Objects.hashCode(numFalsePositives());
        hashCode = 31 * hashCode + Objects.hashCode(numTrueNegatives());
        hashCode = 31 * hashCode + Objects.hashCode(numFalseNegatives());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfusionMatrix)) {
            return false;
        }
        ConfusionMatrix other = (ConfusionMatrix) obj;
        return Objects.equals(numTruePositives(), other.numTruePositives())
                && Objects.equals(numFalsePositives(), other.numFalsePositives())
                && Objects.equals(numTrueNegatives(), other.numTrueNegatives())
                && Objects.equals(numFalseNegatives(), other.numFalseNegatives());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfusionMatrix").add("NumTruePositives", numTruePositives())
                .add("NumFalsePositives", numFalsePositives()).add("NumTrueNegatives", numTrueNegatives())
                .add("NumFalseNegatives", numFalseNegatives()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumTruePositives":
            return Optional.ofNullable(clazz.cast(numTruePositives()));
        case "NumFalsePositives":
            return Optional.ofNullable(clazz.cast(numFalsePositives()));
        case "NumTrueNegatives":
            return Optional.ofNullable(clazz.cast(numTrueNegatives()));
        case "NumFalseNegatives":
            return Optional.ofNullable(clazz.cast(numFalseNegatives()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NumTruePositives", NUM_TRUE_POSITIVES_FIELD);
        map.put("NumFalsePositives", NUM_FALSE_POSITIVES_FIELD);
        map.put("NumTrueNegatives", NUM_TRUE_NEGATIVES_FIELD);
        map.put("NumFalseNegatives", NUM_FALSE_NEGATIVES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfusionMatrix, T> g) {
        return obj -> g.apply((ConfusionMatrix) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfusionMatrix> {
        /**
         * <p>
         * The number of matches in the data that the transform correctly found, in the confusion matrix for your
         * transform.
         * </p>
         * 
         * @param numTruePositives
         *        The number of matches in the data that the transform correctly found, in the confusion matrix for your
         *        transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numTruePositives(Long numTruePositives);

        /**
         * <p>
         * The number of nonmatches in the data that the transform incorrectly classified as a match, in the confusion
         * matrix for your transform.
         * </p>
         * 
         * @param numFalsePositives
         *        The number of nonmatches in the data that the transform incorrectly classified as a match, in the
         *        confusion matrix for your transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numFalsePositives(Long numFalsePositives);

        /**
         * <p>
         * The number of nonmatches in the data that the transform correctly rejected, in the confusion matrix for your
         * transform.
         * </p>
         * 
         * @param numTrueNegatives
         *        The number of nonmatches in the data that the transform correctly rejected, in the confusion matrix
         *        for your transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numTrueNegatives(Long numTrueNegatives);

        /**
         * <p>
         * The number of matches in the data that the transform didn't find, in the confusion matrix for your transform.
         * </p>
         * 
         * @param numFalseNegatives
         *        The number of matches in the data that the transform didn't find, in the confusion matrix for your
         *        transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numFalseNegatives(Long numFalseNegatives);
    }

    static final class BuilderImpl implements Builder {
        private Long numTruePositives;

        private Long numFalsePositives;

        private Long numTrueNegatives;

        private Long numFalseNegatives;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfusionMatrix model) {
            numTruePositives(model.numTruePositives);
            numFalsePositives(model.numFalsePositives);
            numTrueNegatives(model.numTrueNegatives);
            numFalseNegatives(model.numFalseNegatives);
        }

        public final Long getNumTruePositives() {
            return numTruePositives;
        }

        public final void setNumTruePositives(Long numTruePositives) {
            this.numTruePositives = numTruePositives;
        }

        @Override
        public final Builder numTruePositives(Long numTruePositives) {
            this.numTruePositives = numTruePositives;
            return this;
        }

        public final Long getNumFalsePositives() {
            return numFalsePositives;
        }

        public final void setNumFalsePositives(Long numFalsePositives) {
            this.numFalsePositives = numFalsePositives;
        }

        @Override
        public final Builder numFalsePositives(Long numFalsePositives) {
            this.numFalsePositives = numFalsePositives;
            return this;
        }

        public final Long getNumTrueNegatives() {
            return numTrueNegatives;
        }

        public final void setNumTrueNegatives(Long numTrueNegatives) {
            this.numTrueNegatives = numTrueNegatives;
        }

        @Override
        public final Builder numTrueNegatives(Long numTrueNegatives) {
            this.numTrueNegatives = numTrueNegatives;
            return this;
        }

        public final Long getNumFalseNegatives() {
            return numFalseNegatives;
        }

        public final void setNumFalseNegatives(Long numFalseNegatives) {
            this.numFalseNegatives = numFalseNegatives;
        }

        @Override
        public final Builder numFalseNegatives(Long numFalseNegatives) {
            this.numFalseNegatives = numFalseNegatives;
            return this;
        }

        @Override
        public ConfusionMatrix build() {
            return new ConfusionMatrix(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
