/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSchemaResponse extends GlueResponse implements
        ToCopyableBuilder<GetSchemaResponse.Builder, GetSchemaResponse> {
    private static final SdkField<String> REGISTRY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistryName").getter(getter(GetSchemaResponse::registryName)).setter(setter(Builder::registryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryName").build()).build();

    private static final SdkField<String> REGISTRY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistryArn").getter(getter(GetSchemaResponse::registryArn)).setter(setter(Builder::registryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryArn").build()).build();

    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaName").getter(getter(GetSchemaResponse::schemaName)).setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaName").build()).build();

    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaArn").getter(getter(GetSchemaResponse::schemaArn)).setter(setter(Builder::schemaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetSchemaResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataFormat").getter(getter(GetSchemaResponse::dataFormatAsString)).setter(setter(Builder::dataFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormat").build()).build();

    private static final SdkField<String> COMPATIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Compatibility").getter(getter(GetSchemaResponse::compatibilityAsString))
            .setter(setter(Builder::compatibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compatibility").build()).build();

    private static final SdkField<Long> SCHEMA_CHECKPOINT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("SchemaCheckpoint").getter(getter(GetSchemaResponse::schemaCheckpoint))
            .setter(setter(Builder::schemaCheckpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaCheckpoint").build()).build();

    private static final SdkField<Long> LATEST_SCHEMA_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("LatestSchemaVersion").getter(getter(GetSchemaResponse::latestSchemaVersion))
            .setter(setter(Builder::latestSchemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestSchemaVersion").build())
            .build();

    private static final SdkField<Long> NEXT_SCHEMA_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NextSchemaVersion").getter(getter(GetSchemaResponse::nextSchemaVersion))
            .setter(setter(Builder::nextSchemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextSchemaVersion").build()).build();

    private static final SdkField<String> SCHEMA_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaStatus").getter(getter(GetSchemaResponse::schemaStatusAsString))
            .setter(setter(Builder::schemaStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaStatus").build()).build();

    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedTime").getter(getter(GetSchemaResponse::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> UPDATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdatedTime").getter(getter(GetSchemaResponse::updatedTime)).setter(setter(Builder::updatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_NAME_FIELD,
            REGISTRY_ARN_FIELD, SCHEMA_NAME_FIELD, SCHEMA_ARN_FIELD, DESCRIPTION_FIELD, DATA_FORMAT_FIELD, COMPATIBILITY_FIELD,
            SCHEMA_CHECKPOINT_FIELD, LATEST_SCHEMA_VERSION_FIELD, NEXT_SCHEMA_VERSION_FIELD, SCHEMA_STATUS_FIELD,
            CREATED_TIME_FIELD, UPDATED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String registryName;

    private final String registryArn;

    private final String schemaName;

    private final String schemaArn;

    private final String description;

    private final String dataFormat;

    private final String compatibility;

    private final Long schemaCheckpoint;

    private final Long latestSchemaVersion;

    private final Long nextSchemaVersion;

    private final String schemaStatus;

    private final String createdTime;

    private final String updatedTime;

    private GetSchemaResponse(BuilderImpl builder) {
        super(builder);
        this.registryName = builder.registryName;
        this.registryArn = builder.registryArn;
        this.schemaName = builder.schemaName;
        this.schemaArn = builder.schemaArn;
        this.description = builder.description;
        this.dataFormat = builder.dataFormat;
        this.compatibility = builder.compatibility;
        this.schemaCheckpoint = builder.schemaCheckpoint;
        this.latestSchemaVersion = builder.latestSchemaVersion;
        this.nextSchemaVersion = builder.nextSchemaVersion;
        this.schemaStatus = builder.schemaStatus;
        this.createdTime = builder.createdTime;
        this.updatedTime = builder.updatedTime;
    }

    /**
     * <p>
     * The name of the registry.
     * </p>
     * 
     * @return The name of the registry.
     */
    public final String registryName() {
        return registryName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the registry.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the registry.
     */
    public final String registryArn() {
        return registryArn;
    }

    /**
     * <p>
     * The name of the schema.
     * </p>
     * 
     * @return The name of the schema.
     */
    public final String schemaName() {
        return schemaName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the schema.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the schema.
     */
    public final String schemaArn() {
        return schemaArn;
    }

    /**
     * <p>
     * A description of schema if specified when created
     * </p>
     * 
     * @return A description of schema if specified when created
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The data format of the schema definition. Currently <code>AVRO</code>, <code>JSON</code> and
     * <code>PROTOBUF</code> are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataFormat} will
     * return {@link DataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataFormatAsString}.
     * </p>
     * 
     * @return The data format of the schema definition. Currently <code>AVRO</code>, <code>JSON</code> and
     *         <code>PROTOBUF</code> are supported.
     * @see DataFormat
     */
    public final DataFormat dataFormat() {
        return DataFormat.fromValue(dataFormat);
    }

    /**
     * <p>
     * The data format of the schema definition. Currently <code>AVRO</code>, <code>JSON</code> and
     * <code>PROTOBUF</code> are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataFormat} will
     * return {@link DataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataFormatAsString}.
     * </p>
     * 
     * @return The data format of the schema definition. Currently <code>AVRO</code>, <code>JSON</code> and
     *         <code>PROTOBUF</code> are supported.
     * @see DataFormat
     */
    public final String dataFormatAsString() {
        return dataFormat;
    }

    /**
     * <p>
     * The compatibility mode of the schema.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compatibility}
     * will return {@link Compatibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #compatibilityAsString}.
     * </p>
     * 
     * @return The compatibility mode of the schema.
     * @see Compatibility
     */
    public final Compatibility compatibility() {
        return Compatibility.fromValue(compatibility);
    }

    /**
     * <p>
     * The compatibility mode of the schema.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compatibility}
     * will return {@link Compatibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #compatibilityAsString}.
     * </p>
     * 
     * @return The compatibility mode of the schema.
     * @see Compatibility
     */
    public final String compatibilityAsString() {
        return compatibility;
    }

    /**
     * <p>
     * The version number of the checkpoint (the last time the compatibility mode was changed).
     * </p>
     * 
     * @return The version number of the checkpoint (the last time the compatibility mode was changed).
     */
    public final Long schemaCheckpoint() {
        return schemaCheckpoint;
    }

    /**
     * <p>
     * The latest version of the schema associated with the returned schema definition.
     * </p>
     * 
     * @return The latest version of the schema associated with the returned schema definition.
     */
    public final Long latestSchemaVersion() {
        return latestSchemaVersion;
    }

    /**
     * <p>
     * The next version of the schema associated with the returned schema definition.
     * </p>
     * 
     * @return The next version of the schema associated with the returned schema definition.
     */
    public final Long nextSchemaVersion() {
        return nextSchemaVersion;
    }

    /**
     * <p>
     * The status of the schema.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #schemaStatus} will
     * return {@link SchemaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #schemaStatusAsString}.
     * </p>
     * 
     * @return The status of the schema.
     * @see SchemaStatus
     */
    public final SchemaStatus schemaStatus() {
        return SchemaStatus.fromValue(schemaStatus);
    }

    /**
     * <p>
     * The status of the schema.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #schemaStatus} will
     * return {@link SchemaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #schemaStatusAsString}.
     * </p>
     * 
     * @return The status of the schema.
     * @see SchemaStatus
     */
    public final String schemaStatusAsString() {
        return schemaStatus;
    }

    /**
     * <p>
     * The date and time the schema was created.
     * </p>
     * 
     * @return The date and time the schema was created.
     */
    public final String createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The date and time the schema was updated.
     * </p>
     * 
     * @return The date and time the schema was updated.
     */
    public final String updatedTime() {
        return updatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryName());
        hashCode = 31 * hashCode + Objects.hashCode(registryArn());
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dataFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(compatibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(schemaCheckpoint());
        hashCode = 31 * hashCode + Objects.hashCode(latestSchemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(nextSchemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(schemaStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSchemaResponse)) {
            return false;
        }
        GetSchemaResponse other = (GetSchemaResponse) obj;
        return Objects.equals(registryName(), other.registryName()) && Objects.equals(registryArn(), other.registryArn())
                && Objects.equals(schemaName(), other.schemaName()) && Objects.equals(schemaArn(), other.schemaArn())
                && Objects.equals(description(), other.description())
                && Objects.equals(dataFormatAsString(), other.dataFormatAsString())
                && Objects.equals(compatibilityAsString(), other.compatibilityAsString())
                && Objects.equals(schemaCheckpoint(), other.schemaCheckpoint())
                && Objects.equals(latestSchemaVersion(), other.latestSchemaVersion())
                && Objects.equals(nextSchemaVersion(), other.nextSchemaVersion())
                && Objects.equals(schemaStatusAsString(), other.schemaStatusAsString())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(updatedTime(), other.updatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSchemaResponse").add("RegistryName", registryName()).add("RegistryArn", registryArn())
                .add("SchemaName", schemaName()).add("SchemaArn", schemaArn()).add("Description", description())
                .add("DataFormat", dataFormatAsString()).add("Compatibility", compatibilityAsString())
                .add("SchemaCheckpoint", schemaCheckpoint()).add("LatestSchemaVersion", latestSchemaVersion())
                .add("NextSchemaVersion", nextSchemaVersion()).add("SchemaStatus", schemaStatusAsString())
                .add("CreatedTime", createdTime()).add("UpdatedTime", updatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegistryName":
            return Optional.ofNullable(clazz.cast(registryName()));
        case "RegistryArn":
            return Optional.ofNullable(clazz.cast(registryArn()));
        case "SchemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        case "SchemaArn":
            return Optional.ofNullable(clazz.cast(schemaArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DataFormat":
            return Optional.ofNullable(clazz.cast(dataFormatAsString()));
        case "Compatibility":
            return Optional.ofNullable(clazz.cast(compatibilityAsString()));
        case "SchemaCheckpoint":
            return Optional.ofNullable(clazz.cast(schemaCheckpoint()));
        case "LatestSchemaVersion":
            return Optional.ofNullable(clazz.cast(latestSchemaVersion()));
        case "NextSchemaVersion":
            return Optional.ofNullable(clazz.cast(nextSchemaVersion()));
        case "SchemaStatus":
            return Optional.ofNullable(clazz.cast(schemaStatusAsString()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "UpdatedTime":
            return Optional.ofNullable(clazz.cast(updatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RegistryName", REGISTRY_NAME_FIELD);
        map.put("RegistryArn", REGISTRY_ARN_FIELD);
        map.put("SchemaName", SCHEMA_NAME_FIELD);
        map.put("SchemaArn", SCHEMA_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DataFormat", DATA_FORMAT_FIELD);
        map.put("Compatibility", COMPATIBILITY_FIELD);
        map.put("SchemaCheckpoint", SCHEMA_CHECKPOINT_FIELD);
        map.put("LatestSchemaVersion", LATEST_SCHEMA_VERSION_FIELD);
        map.put("NextSchemaVersion", NEXT_SCHEMA_VERSION_FIELD);
        map.put("SchemaStatus", SCHEMA_STATUS_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("UpdatedTime", UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSchemaResponse, T> g) {
        return obj -> g.apply((GetSchemaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSchemaResponse> {
        /**
         * <p>
         * The name of the registry.
         * </p>
         * 
         * @param registryName
         *        The name of the registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryName(String registryName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the registry.
         * </p>
         * 
         * @param registryArn
         *        The Amazon Resource Name (ARN) of the registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryArn(String registryArn);

        /**
         * <p>
         * The name of the schema.
         * </p>
         * 
         * @param schemaName
         *        The name of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the schema.
         * </p>
         * 
         * @param schemaArn
         *        The Amazon Resource Name (ARN) of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaArn(String schemaArn);

        /**
         * <p>
         * A description of schema if specified when created
         * </p>
         * 
         * @param description
         *        A description of schema if specified when created
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The data format of the schema definition. Currently <code>AVRO</code>, <code>JSON</code> and
         * <code>PROTOBUF</code> are supported.
         * </p>
         * 
         * @param dataFormat
         *        The data format of the schema definition. Currently <code>AVRO</code>, <code>JSON</code> and
         *        <code>PROTOBUF</code> are supported.
         * @see DataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataFormat
         */
        Builder dataFormat(String dataFormat);

        /**
         * <p>
         * The data format of the schema definition. Currently <code>AVRO</code>, <code>JSON</code> and
         * <code>PROTOBUF</code> are supported.
         * </p>
         * 
         * @param dataFormat
         *        The data format of the schema definition. Currently <code>AVRO</code>, <code>JSON</code> and
         *        <code>PROTOBUF</code> are supported.
         * @see DataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataFormat
         */
        Builder dataFormat(DataFormat dataFormat);

        /**
         * <p>
         * The compatibility mode of the schema.
         * </p>
         * 
         * @param compatibility
         *        The compatibility mode of the schema.
         * @see Compatibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Compatibility
         */
        Builder compatibility(String compatibility);

        /**
         * <p>
         * The compatibility mode of the schema.
         * </p>
         * 
         * @param compatibility
         *        The compatibility mode of the schema.
         * @see Compatibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Compatibility
         */
        Builder compatibility(Compatibility compatibility);

        /**
         * <p>
         * The version number of the checkpoint (the last time the compatibility mode was changed).
         * </p>
         * 
         * @param schemaCheckpoint
         *        The version number of the checkpoint (the last time the compatibility mode was changed).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaCheckpoint(Long schemaCheckpoint);

        /**
         * <p>
         * The latest version of the schema associated with the returned schema definition.
         * </p>
         * 
         * @param latestSchemaVersion
         *        The latest version of the schema associated with the returned schema definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestSchemaVersion(Long latestSchemaVersion);

        /**
         * <p>
         * The next version of the schema associated with the returned schema definition.
         * </p>
         * 
         * @param nextSchemaVersion
         *        The next version of the schema associated with the returned schema definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextSchemaVersion(Long nextSchemaVersion);

        /**
         * <p>
         * The status of the schema.
         * </p>
         * 
         * @param schemaStatus
         *        The status of the schema.
         * @see SchemaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaStatus
         */
        Builder schemaStatus(String schemaStatus);

        /**
         * <p>
         * The status of the schema.
         * </p>
         * 
         * @param schemaStatus
         *        The status of the schema.
         * @see SchemaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaStatus
         */
        Builder schemaStatus(SchemaStatus schemaStatus);

        /**
         * <p>
         * The date and time the schema was created.
         * </p>
         * 
         * @param createdTime
         *        The date and time the schema was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(String createdTime);

        /**
         * <p>
         * The date and time the schema was updated.
         * </p>
         * 
         * @param updatedTime
         *        The date and time the schema was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTime(String updatedTime);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private String registryName;

        private String registryArn;

        private String schemaName;

        private String schemaArn;

        private String description;

        private String dataFormat;

        private String compatibility;

        private Long schemaCheckpoint;

        private Long latestSchemaVersion;

        private Long nextSchemaVersion;

        private String schemaStatus;

        private String createdTime;

        private String updatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSchemaResponse model) {
            super(model);
            registryName(model.registryName);
            registryArn(model.registryArn);
            schemaName(model.schemaName);
            schemaArn(model.schemaArn);
            description(model.description);
            dataFormat(model.dataFormat);
            compatibility(model.compatibility);
            schemaCheckpoint(model.schemaCheckpoint);
            latestSchemaVersion(model.latestSchemaVersion);
            nextSchemaVersion(model.nextSchemaVersion);
            schemaStatus(model.schemaStatus);
            createdTime(model.createdTime);
            updatedTime(model.updatedTime);
        }

        public final String getRegistryName() {
            return registryName;
        }

        public final void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        @Override
        public final Builder registryName(String registryName) {
            this.registryName = registryName;
            return this;
        }

        public final String getRegistryArn() {
            return registryArn;
        }

        public final void setRegistryArn(String registryArn) {
            this.registryArn = registryArn;
        }

        @Override
        public final Builder registryArn(String registryArn) {
            this.registryArn = registryArn;
            return this;
        }

        public final String getSchemaName() {
            return schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final String getSchemaArn() {
            return schemaArn;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDataFormat() {
            return dataFormat;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        @Override
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        public final Builder dataFormat(DataFormat dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        public final String getCompatibility() {
            return compatibility;
        }

        public final void setCompatibility(String compatibility) {
            this.compatibility = compatibility;
        }

        @Override
        public final Builder compatibility(String compatibility) {
            this.compatibility = compatibility;
            return this;
        }

        @Override
        public final Builder compatibility(Compatibility compatibility) {
            this.compatibility(compatibility == null ? null : compatibility.toString());
            return this;
        }

        public final Long getSchemaCheckpoint() {
            return schemaCheckpoint;
        }

        public final void setSchemaCheckpoint(Long schemaCheckpoint) {
            this.schemaCheckpoint = schemaCheckpoint;
        }

        @Override
        public final Builder schemaCheckpoint(Long schemaCheckpoint) {
            this.schemaCheckpoint = schemaCheckpoint;
            return this;
        }

        public final Long getLatestSchemaVersion() {
            return latestSchemaVersion;
        }

        public final void setLatestSchemaVersion(Long latestSchemaVersion) {
            this.latestSchemaVersion = latestSchemaVersion;
        }

        @Override
        public final Builder latestSchemaVersion(Long latestSchemaVersion) {
            this.latestSchemaVersion = latestSchemaVersion;
            return this;
        }

        public final Long getNextSchemaVersion() {
            return nextSchemaVersion;
        }

        public final void setNextSchemaVersion(Long nextSchemaVersion) {
            this.nextSchemaVersion = nextSchemaVersion;
        }

        @Override
        public final Builder nextSchemaVersion(Long nextSchemaVersion) {
            this.nextSchemaVersion = nextSchemaVersion;
            return this;
        }

        public final String getSchemaStatus() {
            return schemaStatus;
        }

        public final void setSchemaStatus(String schemaStatus) {
            this.schemaStatus = schemaStatus;
        }

        @Override
        public final Builder schemaStatus(String schemaStatus) {
            this.schemaStatus = schemaStatus;
            return this;
        }

        @Override
        public final Builder schemaStatus(SchemaStatus schemaStatus) {
            this.schemaStatus(schemaStatus == null ? null : schemaStatus.toString());
            return this;
        }

        public final String getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getUpdatedTime() {
            return updatedTime;
        }

        public final void setUpdatedTime(String updatedTime) {
            this.updatedTime = updatedTime;
        }

        @Override
        public final Builder updatedTime(String updatedTime) {
            this.updatedTime = updatedTime;
            return this;
        }

        @Override
        public GetSchemaResponse build() {
            return new GetSchemaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
