/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IcebergOrphanFileDeletionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IcebergOrphanFileDeletionConfiguration> {
    private static final SdkField<Integer> ORPHAN_FILE_RETENTION_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("orphanFileRetentionPeriodInDays").getter(IcebergOrphanFileDeletionConfiguration.getter(IcebergOrphanFileDeletionConfiguration::orphanFileRetentionPeriodInDays)).setter(IcebergOrphanFileDeletionConfiguration.setter(Builder::orphanFileRetentionPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orphanFileRetentionPeriodInDays").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("location").getter(IcebergOrphanFileDeletionConfiguration.getter(IcebergOrphanFileDeletionConfiguration::location)).setter(IcebergOrphanFileDeletionConfiguration.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORPHAN_FILE_RETENTION_PERIOD_IN_DAYS_FIELD, LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IcebergOrphanFileDeletionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer orphanFileRetentionPeriodInDays;
    private final String location;

    private IcebergOrphanFileDeletionConfiguration(BuilderImpl builder) {
        this.orphanFileRetentionPeriodInDays = builder.orphanFileRetentionPeriodInDays;
        this.location = builder.location;
    }

    public final Integer orphanFileRetentionPeriodInDays() {
        return this.orphanFileRetentionPeriodInDays;
    }

    public final String location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.orphanFileRetentionPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergOrphanFileDeletionConfiguration)) {
            return false;
        }
        IcebergOrphanFileDeletionConfiguration other = (IcebergOrphanFileDeletionConfiguration)obj;
        return Objects.equals(this.orphanFileRetentionPeriodInDays(), other.orphanFileRetentionPeriodInDays()) && Objects.equals(this.location(), other.location());
    }

    public final String toString() {
        return ToString.builder((String)"IcebergOrphanFileDeletionConfiguration").add("OrphanFileRetentionPeriodInDays", (Object)this.orphanFileRetentionPeriodInDays()).add("Location", (Object)this.location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "orphanFileRetentionPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.orphanFileRetentionPeriodInDays()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orphanFileRetentionPeriodInDays", ORPHAN_FILE_RETENTION_PERIOD_IN_DAYS_FIELD);
        map.put("location", LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergOrphanFileDeletionConfiguration, T> g) {
        return obj -> g.apply((IcebergOrphanFileDeletionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer orphanFileRetentionPeriodInDays;
        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergOrphanFileDeletionConfiguration model) {
            this.orphanFileRetentionPeriodInDays(model.orphanFileRetentionPeriodInDays);
            this.location(model.location);
        }

        public final Integer getOrphanFileRetentionPeriodInDays() {
            return this.orphanFileRetentionPeriodInDays;
        }

        public final void setOrphanFileRetentionPeriodInDays(Integer orphanFileRetentionPeriodInDays) {
            this.orphanFileRetentionPeriodInDays = orphanFileRetentionPeriodInDays;
        }

        @Override
        public final Builder orphanFileRetentionPeriodInDays(Integer orphanFileRetentionPeriodInDays) {
            this.orphanFileRetentionPeriodInDays = orphanFileRetentionPeriodInDays;
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public IcebergOrphanFileDeletionConfiguration build() {
            return new IcebergOrphanFileDeletionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IcebergOrphanFileDeletionConfiguration> {
        public Builder orphanFileRetentionPeriodInDays(Integer var1);

        public Builder location(String var1);
    }
}

