/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.EnclosedInStringPropertiesCopier;
import software.amazon.awssdk.services.glue.model.OneInputCopier;
import software.amazon.awssdk.services.glue.model.PiiType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PIIDetection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PIIDetection> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(PIIDetection.getter(PIIDetection::name)).setter(PIIDetection.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Inputs").getter(PIIDetection.getter(PIIDetection::inputs)).setter(PIIDetection.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PII_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PiiType").getter(PIIDetection.getter(PIIDetection::piiTypeAsString)).setter(PIIDetection.setter(Builder::piiType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PiiType").build()}).build();
    private static final SdkField<List<String>> ENTITY_TYPES_TO_DETECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntityTypesToDetect").getter(PIIDetection.getter(PIIDetection::entityTypesToDetect)).setter(PIIDetection.setter(Builder::entityTypesToDetect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityTypesToDetect").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OUTPUT_COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputColumnName").getter(PIIDetection.getter(PIIDetection::outputColumnName)).setter(PIIDetection.setter(Builder::outputColumnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputColumnName").build()}).build();
    private static final SdkField<Double> SAMPLE_FRACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("SampleFraction").getter(PIIDetection.getter(PIIDetection::sampleFraction)).setter(PIIDetection.setter(Builder::sampleFraction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleFraction").build()}).build();
    private static final SdkField<Double> THRESHOLD_FRACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ThresholdFraction").getter(PIIDetection.getter(PIIDetection::thresholdFraction)).setter(PIIDetection.setter(Builder::thresholdFraction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThresholdFraction").build()}).build();
    private static final SdkField<String> MASK_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaskValue").getter(PIIDetection.getter(PIIDetection::maskValue)).setter(PIIDetection.setter(Builder::maskValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaskValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD, PII_TYPE_FIELD, ENTITY_TYPES_TO_DETECT_FIELD, OUTPUT_COLUMN_NAME_FIELD, SAMPLE_FRACTION_FIELD, THRESHOLD_FRACTION_FIELD, MASK_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PIIDetection.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> inputs;
    private final String piiType;
    private final List<String> entityTypesToDetect;
    private final String outputColumnName;
    private final Double sampleFraction;
    private final Double thresholdFraction;
    private final String maskValue;

    private PIIDetection(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.piiType = builder.piiType;
        this.entityTypesToDetect = builder.entityTypesToDetect;
        this.outputColumnName = builder.outputColumnName;
        this.sampleFraction = builder.sampleFraction;
        this.thresholdFraction = builder.thresholdFraction;
        this.maskValue = builder.maskValue;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<String> inputs() {
        return this.inputs;
    }

    public final PiiType piiType() {
        return PiiType.fromValue(this.piiType);
    }

    public final String piiTypeAsString() {
        return this.piiType;
    }

    public final boolean hasEntityTypesToDetect() {
        return this.entityTypesToDetect != null && !(this.entityTypesToDetect instanceof SdkAutoConstructList);
    }

    public final List<String> entityTypesToDetect() {
        return this.entityTypesToDetect;
    }

    public final String outputColumnName() {
        return this.outputColumnName;
    }

    public final Double sampleFraction() {
        return this.sampleFraction;
    }

    public final Double thresholdFraction() {
        return this.thresholdFraction;
    }

    public final String maskValue() {
        return this.maskValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.piiTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntityTypesToDetect() ? this.entityTypesToDetect() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.outputColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleFraction());
        hashCode = 31 * hashCode + Objects.hashCode(this.thresholdFraction());
        hashCode = 31 * hashCode + Objects.hashCode(this.maskValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PIIDetection)) {
            return false;
        }
        PIIDetection other = (PIIDetection)obj;
        return Objects.equals(this.name(), other.name()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && Objects.equals(this.piiTypeAsString(), other.piiTypeAsString()) && this.hasEntityTypesToDetect() == other.hasEntityTypesToDetect() && Objects.equals(this.entityTypesToDetect(), other.entityTypesToDetect()) && Objects.equals(this.outputColumnName(), other.outputColumnName()) && Objects.equals(this.sampleFraction(), other.sampleFraction()) && Objects.equals(this.thresholdFraction(), other.thresholdFraction()) && Objects.equals(this.maskValue(), other.maskValue());
    }

    public final String toString() {
        return ToString.builder((String)"PIIDetection").add("Name", (Object)this.name()).add("Inputs", this.hasInputs() ? this.inputs() : null).add("PiiType", (Object)this.piiTypeAsString()).add("EntityTypesToDetect", this.hasEntityTypesToDetect() ? this.entityTypesToDetect() : null).add("OutputColumnName", (Object)this.outputColumnName()).add("SampleFraction", (Object)this.sampleFraction()).add("ThresholdFraction", (Object)this.thresholdFraction()).add("MaskValue", (Object)this.maskValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "PiiType": {
                return Optional.ofNullable(clazz.cast(this.piiTypeAsString()));
            }
            case "EntityTypesToDetect": {
                return Optional.ofNullable(clazz.cast(this.entityTypesToDetect()));
            }
            case "OutputColumnName": {
                return Optional.ofNullable(clazz.cast(this.outputColumnName()));
            }
            case "SampleFraction": {
                return Optional.ofNullable(clazz.cast(this.sampleFraction()));
            }
            case "ThresholdFraction": {
                return Optional.ofNullable(clazz.cast(this.thresholdFraction()));
            }
            case "MaskValue": {
                return Optional.ofNullable(clazz.cast(this.maskValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Inputs", INPUTS_FIELD);
        map.put("PiiType", PII_TYPE_FIELD);
        map.put("EntityTypesToDetect", ENTITY_TYPES_TO_DETECT_FIELD);
        map.put("OutputColumnName", OUTPUT_COLUMN_NAME_FIELD);
        map.put("SampleFraction", SAMPLE_FRACTION_FIELD);
        map.put("ThresholdFraction", THRESHOLD_FRACTION_FIELD);
        map.put("MaskValue", MASK_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PIIDetection, T> g) {
        return obj -> g.apply((PIIDetection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();
        private String piiType;
        private List<String> entityTypesToDetect = DefaultSdkAutoConstructList.getInstance();
        private String outputColumnName;
        private Double sampleFraction;
        private Double thresholdFraction;
        private String maskValue;

        private BuilderImpl() {
        }

        private BuilderImpl(PIIDetection model) {
            this.name(model.name);
            this.inputs(model.inputs);
            this.piiType(model.piiType);
            this.entityTypesToDetect(model.entityTypesToDetect);
            this.outputColumnName(model.outputColumnName);
            this.sampleFraction(model.sampleFraction);
            this.thresholdFraction(model.thresholdFraction);
            this.maskValue(model.maskValue);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (this.inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        public final String getPiiType() {
            return this.piiType;
        }

        public final void setPiiType(String piiType) {
            this.piiType = piiType;
        }

        @Override
        public final Builder piiType(String piiType) {
            this.piiType = piiType;
            return this;
        }

        @Override
        public final Builder piiType(PiiType piiType) {
            this.piiType(piiType == null ? null : piiType.toString());
            return this;
        }

        public final Collection<String> getEntityTypesToDetect() {
            if (this.entityTypesToDetect instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entityTypesToDetect;
        }

        public final void setEntityTypesToDetect(Collection<String> entityTypesToDetect) {
            this.entityTypesToDetect = EnclosedInStringPropertiesCopier.copy(entityTypesToDetect);
        }

        @Override
        public final Builder entityTypesToDetect(Collection<String> entityTypesToDetect) {
            this.entityTypesToDetect = EnclosedInStringPropertiesCopier.copy(entityTypesToDetect);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypesToDetect(String ... entityTypesToDetect) {
            this.entityTypesToDetect(Arrays.asList(entityTypesToDetect));
            return this;
        }

        public final String getOutputColumnName() {
            return this.outputColumnName;
        }

        public final void setOutputColumnName(String outputColumnName) {
            this.outputColumnName = outputColumnName;
        }

        @Override
        public final Builder outputColumnName(String outputColumnName) {
            this.outputColumnName = outputColumnName;
            return this;
        }

        public final Double getSampleFraction() {
            return this.sampleFraction;
        }

        public final void setSampleFraction(Double sampleFraction) {
            this.sampleFraction = sampleFraction;
        }

        @Override
        public final Builder sampleFraction(Double sampleFraction) {
            this.sampleFraction = sampleFraction;
            return this;
        }

        public final Double getThresholdFraction() {
            return this.thresholdFraction;
        }

        public final void setThresholdFraction(Double thresholdFraction) {
            this.thresholdFraction = thresholdFraction;
        }

        @Override
        public final Builder thresholdFraction(Double thresholdFraction) {
            this.thresholdFraction = thresholdFraction;
            return this;
        }

        public final String getMaskValue() {
            return this.maskValue;
        }

        public final void setMaskValue(String maskValue) {
            this.maskValue = maskValue;
        }

        @Override
        public final Builder maskValue(String maskValue) {
            this.maskValue = maskValue;
            return this;
        }

        public PIIDetection build() {
            return new PIIDetection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PIIDetection> {
        public Builder name(String var1);

        public Builder inputs(Collection<String> var1);

        public Builder inputs(String ... var1);

        public Builder piiType(String var1);

        public Builder piiType(PiiType var1);

        public Builder entityTypesToDetect(Collection<String> var1);

        public Builder entityTypesToDetect(String ... var1);

        public Builder outputColumnName(String var1);

        public Builder sampleFraction(Double var1);

        public Builder thresholdFraction(Double var1);

        public Builder maskValue(String var1);
    }
}

