/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.JDBCConnectionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DirectJDBCSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DirectJDBCSource> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DirectJDBCSource.getter(DirectJDBCSource::name)).setter(DirectJDBCSource.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(DirectJDBCSource.getter(DirectJDBCSource::database)).setter(DirectJDBCSource.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<String> TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Table").getter(DirectJDBCSource.getter(DirectJDBCSource::table)).setter(DirectJDBCSource.setter(Builder::table)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()}).build();
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionName").getter(DirectJDBCSource.getter(DirectJDBCSource::connectionName)).setter(DirectJDBCSource.setter(Builder::connectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()}).build();
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionType").getter(DirectJDBCSource.getter(DirectJDBCSource::connectionTypeAsString)).setter(DirectJDBCSource.setter(Builder::connectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()}).build();
    private static final SdkField<String> REDSHIFT_TMP_DIR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RedshiftTmpDir").getter(DirectJDBCSource.getter(DirectJDBCSource::redshiftTmpDir)).setter(DirectJDBCSource.setter(Builder::redshiftTmpDir)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftTmpDir").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DATABASE_FIELD, TABLE_FIELD, CONNECTION_NAME_FIELD, CONNECTION_TYPE_FIELD, REDSHIFT_TMP_DIR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DirectJDBCSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String database;
    private final String table;
    private final String connectionName;
    private final String connectionType;
    private final String redshiftTmpDir;

    private DirectJDBCSource(BuilderImpl builder) {
        this.name = builder.name;
        this.database = builder.database;
        this.table = builder.table;
        this.connectionName = builder.connectionName;
        this.connectionType = builder.connectionType;
        this.redshiftTmpDir = builder.redshiftTmpDir;
    }

    public final String name() {
        return this.name;
    }

    public final String database() {
        return this.database;
    }

    public final String table() {
        return this.table;
    }

    public final String connectionName() {
        return this.connectionName;
    }

    public final JDBCConnectionType connectionType() {
        return JDBCConnectionType.fromValue(this.connectionType);
    }

    public final String connectionTypeAsString() {
        return this.connectionType;
    }

    public final String redshiftTmpDir() {
        return this.redshiftTmpDir;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftTmpDir());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectJDBCSource)) {
            return false;
        }
        DirectJDBCSource other = (DirectJDBCSource)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.table(), other.table()) && Objects.equals(this.connectionName(), other.connectionName()) && Objects.equals(this.connectionTypeAsString(), other.connectionTypeAsString()) && Objects.equals(this.redshiftTmpDir(), other.redshiftTmpDir());
    }

    public final String toString() {
        return ToString.builder((String)"DirectJDBCSource").add("Name", (Object)this.name()).add("Database", (Object)this.database()).add("Table", (Object)this.table()).add("ConnectionName", (Object)this.connectionName()).add("ConnectionType", (Object)this.connectionTypeAsString()).add("RedshiftTmpDir", (Object)this.redshiftTmpDir()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "Table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
            case "ConnectionName": {
                return Optional.ofNullable(clazz.cast(this.connectionName()));
            }
            case "ConnectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionTypeAsString()));
            }
            case "RedshiftTmpDir": {
                return Optional.ofNullable(clazz.cast(this.redshiftTmpDir()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Name", NAME_FIELD);
        map.put("Database", DATABASE_FIELD);
        map.put("Table", TABLE_FIELD);
        map.put("ConnectionName", CONNECTION_NAME_FIELD);
        map.put("ConnectionType", CONNECTION_TYPE_FIELD);
        map.put("RedshiftTmpDir", REDSHIFT_TMP_DIR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DirectJDBCSource, T> g) {
        return obj -> g.apply((DirectJDBCSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String database;
        private String table;
        private String connectionName;
        private String connectionType;
        private String redshiftTmpDir;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectJDBCSource model) {
            this.name(model.name);
            this.database(model.database);
            this.table(model.table);
            this.connectionName(model.connectionName);
            this.connectionType(model.connectionType);
            this.redshiftTmpDir(model.redshiftTmpDir);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getTable() {
            return this.table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(JDBCConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final String getRedshiftTmpDir() {
            return this.redshiftTmpDir;
        }

        public final void setRedshiftTmpDir(String redshiftTmpDir) {
            this.redshiftTmpDir = redshiftTmpDir;
        }

        @Override
        public final Builder redshiftTmpDir(String redshiftTmpDir) {
            this.redshiftTmpDir = redshiftTmpDir;
            return this;
        }

        public DirectJDBCSource build() {
            return new DirectJDBCSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DirectJDBCSource> {
        public Builder name(String var1);

        public Builder database(String var1);

        public Builder table(String var1);

        public Builder connectionName(String var1);

        public Builder connectionType(String var1);

        public Builder connectionType(JDBCConnectionType var1);

        public Builder redshiftTmpDir(String var1);
    }
}

