/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsRequest;
import software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsResponse;
import software.amazon.awssdk.services.glue.model.SecurityConfiguration;

public class GetSecurityConfigurationsPublisher
implements SdkPublisher<GetSecurityConfigurationsResponse> {
    private final GlueAsyncClient client;
    private final GetSecurityConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetSecurityConfigurationsPublisher(GlueAsyncClient client, GetSecurityConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetSecurityConfigurationsPublisher(GlueAsyncClient client, GetSecurityConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetSecurityConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetSecurityConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SecurityConfiguration> securityConfigurations() {
        Function<GetSecurityConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityConfigurations() != null) {
                return response.securityConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetSecurityConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetSecurityConfigurationsResponseFetcher
    implements AsyncPageFetcher<GetSecurityConfigurationsResponse> {
        private GetSecurityConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(GetSecurityConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetSecurityConfigurationsResponse> nextPage(GetSecurityConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return GetSecurityConfigurationsPublisher.this.client.getSecurityConfigurations(GetSecurityConfigurationsPublisher.this.firstRequest);
            }
            return GetSecurityConfigurationsPublisher.this.client.getSecurityConfigurations((GetSecurityConfigurationsRequest)((Object)GetSecurityConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

