/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEntityRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, DescribeEntityRequest> {
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionName").getter(DescribeEntityRequest.getter(DescribeEntityRequest::connectionName)).setter(DescribeEntityRequest.setter(Builder::connectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()}).build();
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(DescribeEntityRequest.getter(DescribeEntityRequest::catalogId)).setter(DescribeEntityRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> ENTITY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityName").getter(DescribeEntityRequest.getter(DescribeEntityRequest::entityName)).setter(DescribeEntityRequest.setter(Builder::entityName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityName").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeEntityRequest.getter(DescribeEntityRequest::nextToken)).setter(DescribeEntityRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> DATA_STORE_API_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataStoreApiVersion").getter(DescribeEntityRequest.getter(DescribeEntityRequest::dataStoreApiVersion)).setter(DescribeEntityRequest.setter(Builder::dataStoreApiVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStoreApiVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_NAME_FIELD, CATALOG_ID_FIELD, ENTITY_NAME_FIELD, NEXT_TOKEN_FIELD, DATA_STORE_API_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeEntityRequest.memberNameToFieldInitializer();
    private final String connectionName;
    private final String catalogId;
    private final String entityName;
    private final String nextToken;
    private final String dataStoreApiVersion;

    private DescribeEntityRequest(BuilderImpl builder) {
        super(builder);
        this.connectionName = builder.connectionName;
        this.catalogId = builder.catalogId;
        this.entityName = builder.entityName;
        this.nextToken = builder.nextToken;
        this.dataStoreApiVersion = builder.dataStoreApiVersion;
    }

    public final String connectionName() {
        return this.connectionName;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String entityName() {
        return this.entityName;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String dataStoreApiVersion() {
        return this.dataStoreApiVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataStoreApiVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEntityRequest)) {
            return false;
        }
        DescribeEntityRequest other = (DescribeEntityRequest)((Object)obj);
        return Objects.equals(this.connectionName(), other.connectionName()) && Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.entityName(), other.entityName()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.dataStoreApiVersion(), other.dataStoreApiVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEntityRequest").add("ConnectionName", (Object)this.connectionName()).add("CatalogId", (Object)this.catalogId()).add("EntityName", (Object)this.entityName()).add("NextToken", (Object)this.nextToken()).add("DataStoreApiVersion", (Object)this.dataStoreApiVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionName": {
                return Optional.ofNullable(clazz.cast(this.connectionName()));
            }
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "EntityName": {
                return Optional.ofNullable(clazz.cast(this.entityName()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "DataStoreApiVersion": {
                return Optional.ofNullable(clazz.cast(this.dataStoreApiVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ConnectionName", CONNECTION_NAME_FIELD);
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("EntityName", ENTITY_NAME_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("DataStoreApiVersion", DATA_STORE_API_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEntityRequest, T> g) {
        return obj -> g.apply((DescribeEntityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String connectionName;
        private String catalogId;
        private String entityName;
        private String nextToken;
        private String dataStoreApiVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEntityRequest model) {
            super(model);
            this.connectionName(model.connectionName);
            this.catalogId(model.catalogId);
            this.entityName(model.entityName);
            this.nextToken(model.nextToken);
            this.dataStoreApiVersion(model.dataStoreApiVersion);
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getEntityName() {
            return this.entityName;
        }

        public final void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public final Builder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getDataStoreApiVersion() {
            return this.dataStoreApiVersion;
        }

        public final void setDataStoreApiVersion(String dataStoreApiVersion) {
            this.dataStoreApiVersion = dataStoreApiVersion;
        }

        @Override
        public final Builder dataStoreApiVersion(String dataStoreApiVersion) {
            this.dataStoreApiVersion = dataStoreApiVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEntityRequest build() {
            return new DescribeEntityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEntityRequest> {
        public Builder connectionName(String var1);

        public Builder catalogId(String var1);

        public Builder entityName(String var1);

        public Builder nextToken(String var1);

        public Builder dataStoreApiVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

