/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.ColumnNameListCopier;
import software.amazon.awssdk.services.glue.model.ExecutionAttempt;
import software.amazon.awssdk.services.glue.model.Schedule;
import software.amazon.awssdk.services.glue.model.ScheduleType;
import software.amazon.awssdk.services.glue.model.SettingSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ColumnStatisticsTaskSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ColumnStatisticsTaskSettings> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(ColumnStatisticsTaskSettings.getter(ColumnStatisticsTaskSettings::databaseName)).setter(ColumnStatisticsTaskSettings.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(ColumnStatisticsTaskSettings.getter(ColumnStatisticsTaskSettings::tableName)).setter(ColumnStatisticsTaskSettings.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Schedule").getter(ColumnStatisticsTaskSettings.getter(ColumnStatisticsTaskSettings::schedule)).setter(ColumnStatisticsTaskSettings.setter(Builder::schedule)).constructor(Schedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<List<String>> COLUMN_NAME_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnNameList").getter(ColumnStatisticsTaskSettings.getter(ColumnStatisticsTaskSettings::columnNameList)).setter(ColumnStatisticsTaskSettings.setter(Builder::columnNameList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnNameList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogID").getter(ColumnStatisticsTaskSettings.getter(ColumnStatisticsTaskSettings::catalogID)).setter(ColumnStatisticsTaskSettings.setter(Builder::catalogID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogID").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(ColumnStatisticsTaskSettings.getter(ColumnStatisticsTaskSettings::role)).setter(ColumnStatisticsTaskSettings.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<Double> SAMPLE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("SampleSize").getter(ColumnStatisticsTaskSettings.getter(ColumnStatisticsTaskSettings::sampleSize)).setter(ColumnStatisticsTaskSettings.setter(Builder::sampleSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleSize").build()}).build();
    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityConfiguration").getter(ColumnStatisticsTaskSettings.getter(ColumnStatisticsTaskSettings::securityConfiguration)).setter(ColumnStatisticsTaskSettings.setter(Builder::securityConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build()}).build();
    private static final SdkField<String> SCHEDULE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleType").getter(ColumnStatisticsTaskSettings.getter(ColumnStatisticsTaskSettings::scheduleTypeAsString)).setter(ColumnStatisticsTaskSettings.setter(Builder::scheduleType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleType").build()}).build();
    private static final SdkField<String> SETTING_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SettingSource").getter(ColumnStatisticsTaskSettings.getter(ColumnStatisticsTaskSettings::settingSourceAsString)).setter(ColumnStatisticsTaskSettings.setter(Builder::settingSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SettingSource").build()}).build();
    private static final SdkField<ExecutionAttempt> LAST_EXECUTION_ATTEMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastExecutionAttempt").getter(ColumnStatisticsTaskSettings.getter(ColumnStatisticsTaskSettings::lastExecutionAttempt)).setter(ColumnStatisticsTaskSettings.setter(Builder::lastExecutionAttempt)).constructor(ExecutionAttempt::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastExecutionAttempt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD, TABLE_NAME_FIELD, SCHEDULE_FIELD, COLUMN_NAME_LIST_FIELD, CATALOG_ID_FIELD, ROLE_FIELD, SAMPLE_SIZE_FIELD, SECURITY_CONFIGURATION_FIELD, SCHEDULE_TYPE_FIELD, SETTING_SOURCE_FIELD, LAST_EXECUTION_ATTEMPT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ColumnStatisticsTaskSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String databaseName;
    private final String tableName;
    private final Schedule schedule;
    private final List<String> columnNameList;
    private final String catalogID;
    private final String role;
    private final Double sampleSize;
    private final String securityConfiguration;
    private final String scheduleType;
    private final String settingSource;
    private final ExecutionAttempt lastExecutionAttempt;

    private ColumnStatisticsTaskSettings(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.schedule = builder.schedule;
        this.columnNameList = builder.columnNameList;
        this.catalogID = builder.catalogID;
        this.role = builder.role;
        this.sampleSize = builder.sampleSize;
        this.securityConfiguration = builder.securityConfiguration;
        this.scheduleType = builder.scheduleType;
        this.settingSource = builder.settingSource;
        this.lastExecutionAttempt = builder.lastExecutionAttempt;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final Schedule schedule() {
        return this.schedule;
    }

    public final boolean hasColumnNameList() {
        return this.columnNameList != null && !(this.columnNameList instanceof SdkAutoConstructList);
    }

    public final List<String> columnNameList() {
        return this.columnNameList;
    }

    public final String catalogID() {
        return this.catalogID;
    }

    public final String role() {
        return this.role;
    }

    public final Double sampleSize() {
        return this.sampleSize;
    }

    public final String securityConfiguration() {
        return this.securityConfiguration;
    }

    public final ScheduleType scheduleType() {
        return ScheduleType.fromValue(this.scheduleType);
    }

    public final String scheduleTypeAsString() {
        return this.scheduleType;
    }

    public final SettingSource settingSource() {
        return SettingSource.fromValue(this.settingSource);
    }

    public final String settingSourceAsString() {
        return this.settingSource;
    }

    public final ExecutionAttempt lastExecutionAttempt() {
        return this.lastExecutionAttempt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnNameList() ? this.columnNameList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogID());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.settingSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastExecutionAttempt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnStatisticsTaskSettings)) {
            return false;
        }
        ColumnStatisticsTaskSettings other = (ColumnStatisticsTaskSettings)obj;
        return Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.schedule(), other.schedule()) && this.hasColumnNameList() == other.hasColumnNameList() && Objects.equals(this.columnNameList(), other.columnNameList()) && Objects.equals(this.catalogID(), other.catalogID()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.sampleSize(), other.sampleSize()) && Objects.equals(this.securityConfiguration(), other.securityConfiguration()) && Objects.equals(this.scheduleTypeAsString(), other.scheduleTypeAsString()) && Objects.equals(this.settingSourceAsString(), other.settingSourceAsString()) && Objects.equals(this.lastExecutionAttempt(), other.lastExecutionAttempt());
    }

    public final String toString() {
        return ToString.builder((String)"ColumnStatisticsTaskSettings").add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("Schedule", (Object)this.schedule()).add("ColumnNameList", this.hasColumnNameList() ? this.columnNameList() : null).add("CatalogID", (Object)this.catalogID()).add("Role", (Object)this.role()).add("SampleSize", (Object)this.sampleSize()).add("SecurityConfiguration", (Object)this.securityConfiguration()).add("ScheduleType", (Object)this.scheduleTypeAsString()).add("SettingSource", (Object)this.settingSourceAsString()).add("LastExecutionAttempt", (Object)this.lastExecutionAttempt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "ColumnNameList": {
                return Optional.ofNullable(clazz.cast(this.columnNameList()));
            }
            case "CatalogID": {
                return Optional.ofNullable(clazz.cast(this.catalogID()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "SampleSize": {
                return Optional.ofNullable(clazz.cast(this.sampleSize()));
            }
            case "SecurityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.securityConfiguration()));
            }
            case "ScheduleType": {
                return Optional.ofNullable(clazz.cast(this.scheduleTypeAsString()));
            }
            case "SettingSource": {
                return Optional.ofNullable(clazz.cast(this.settingSourceAsString()));
            }
            case "LastExecutionAttempt": {
                return Optional.ofNullable(clazz.cast(this.lastExecutionAttempt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("Schedule", SCHEDULE_FIELD);
        map.put("ColumnNameList", COLUMN_NAME_LIST_FIELD);
        map.put("CatalogID", CATALOG_ID_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("SampleSize", SAMPLE_SIZE_FIELD);
        map.put("SecurityConfiguration", SECURITY_CONFIGURATION_FIELD);
        map.put("ScheduleType", SCHEDULE_TYPE_FIELD);
        map.put("SettingSource", SETTING_SOURCE_FIELD);
        map.put("LastExecutionAttempt", LAST_EXECUTION_ATTEMPT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ColumnStatisticsTaskSettings, T> g) {
        return obj -> g.apply((ColumnStatisticsTaskSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String databaseName;
        private String tableName;
        private Schedule schedule;
        private List<String> columnNameList = DefaultSdkAutoConstructList.getInstance();
        private String catalogID;
        private String role;
        private Double sampleSize;
        private String securityConfiguration;
        private String scheduleType;
        private String settingSource;
        private ExecutionAttempt lastExecutionAttempt;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnStatisticsTaskSettings model) {
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.schedule(model.schedule);
            this.columnNameList(model.columnNameList);
            this.catalogID(model.catalogID);
            this.role(model.role);
            this.sampleSize(model.sampleSize);
            this.securityConfiguration(model.securityConfiguration);
            this.scheduleType(model.scheduleType);
            this.settingSource(model.settingSource);
            this.lastExecutionAttempt(model.lastExecutionAttempt);
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final Schedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final Collection<String> getColumnNameList() {
            if (this.columnNameList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.columnNameList;
        }

        public final void setColumnNameList(Collection<String> columnNameList) {
            this.columnNameList = ColumnNameListCopier.copy(columnNameList);
        }

        @Override
        public final Builder columnNameList(Collection<String> columnNameList) {
            this.columnNameList = ColumnNameListCopier.copy(columnNameList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnNameList(String ... columnNameList) {
            this.columnNameList(Arrays.asList(columnNameList));
            return this;
        }

        public final String getCatalogID() {
            return this.catalogID;
        }

        public final void setCatalogID(String catalogID) {
            this.catalogID = catalogID;
        }

        @Override
        public final Builder catalogID(String catalogID) {
            this.catalogID = catalogID;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final Double getSampleSize() {
            return this.sampleSize;
        }

        public final void setSampleSize(Double sampleSize) {
            this.sampleSize = sampleSize;
        }

        @Override
        public final Builder sampleSize(Double sampleSize) {
            this.sampleSize = sampleSize;
            return this;
        }

        public final String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final String getScheduleType() {
            return this.scheduleType;
        }

        public final void setScheduleType(String scheduleType) {
            this.scheduleType = scheduleType;
        }

        @Override
        public final Builder scheduleType(String scheduleType) {
            this.scheduleType = scheduleType;
            return this;
        }

        @Override
        public final Builder scheduleType(ScheduleType scheduleType) {
            this.scheduleType(scheduleType == null ? null : scheduleType.toString());
            return this;
        }

        public final String getSettingSource() {
            return this.settingSource;
        }

        public final void setSettingSource(String settingSource) {
            this.settingSource = settingSource;
        }

        @Override
        @Transient
        public final Builder settingSource(String settingSource) {
            this.settingSource = settingSource;
            return this;
        }

        @Override
        @Transient
        public final Builder settingSource(SettingSource settingSource) {
            this.settingSource(settingSource == null ? null : settingSource.toString());
            return this;
        }

        public final ExecutionAttempt.Builder getLastExecutionAttempt() {
            return this.lastExecutionAttempt != null ? this.lastExecutionAttempt.toBuilder() : null;
        }

        public final void setLastExecutionAttempt(ExecutionAttempt.BuilderImpl lastExecutionAttempt) {
            this.lastExecutionAttempt = lastExecutionAttempt != null ? lastExecutionAttempt.build() : null;
        }

        @Override
        public final Builder lastExecutionAttempt(ExecutionAttempt lastExecutionAttempt) {
            this.lastExecutionAttempt = lastExecutionAttempt;
            return this;
        }

        public ColumnStatisticsTaskSettings build() {
            return new ColumnStatisticsTaskSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ColumnStatisticsTaskSettings> {
        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder schedule(Schedule var1);

        default public Builder schedule(Consumer<Schedule.Builder> schedule) {
            return this.schedule((Schedule)((Schedule.Builder)Schedule.builder().applyMutation(schedule)).build());
        }

        public Builder columnNameList(Collection<String> var1);

        public Builder columnNameList(String ... var1);

        public Builder catalogID(String var1);

        public Builder role(String var1);

        public Builder sampleSize(Double var1);

        public Builder securityConfiguration(String var1);

        public Builder scheduleType(String var1);

        public Builder scheduleType(ScheduleType var1);

        public Builder settingSource(String var1);

        public Builder settingSource(SettingSource var1);

        public Builder lastExecutionAttempt(ExecutionAttempt var1);

        default public Builder lastExecutionAttempt(Consumer<ExecutionAttempt.Builder> lastExecutionAttempt) {
            return this.lastExecutionAttempt((ExecutionAttempt)((ExecutionAttempt.Builder)ExecutionAttempt.builder().applyMutation(lastExecutionAttempt)).build());
        }
    }
}

