/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.AuthConfiguration;
import software.amazon.awssdk.services.glue.model.Capabilities;
import software.amazon.awssdk.services.glue.model.ComputeEnvironmentConfiguration;
import software.amazon.awssdk.services.glue.model.ComputeEnvironmentConfigurationMapCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.PropertiesMapCopier;
import software.amazon.awssdk.services.glue.model.Property;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConnectionTypeResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, DescribeConnectionTypeResponse> {
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionType").getter(DescribeConnectionTypeResponse.getter(DescribeConnectionTypeResponse::connectionType)).setter(DescribeConnectionTypeResponse.setter(Builder::connectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeConnectionTypeResponse.getter(DescribeConnectionTypeResponse::description)).setter(DescribeConnectionTypeResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Capabilities> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Capabilities").getter(DescribeConnectionTypeResponse.getter(DescribeConnectionTypeResponse::capabilities)).setter(DescribeConnectionTypeResponse.setter(Builder::capabilities)).constructor(Capabilities::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build()}).build();
    private static final SdkField<Map<String, Property>> CONNECTION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ConnectionProperties").getter(DescribeConnectionTypeResponse.getter(DescribeConnectionTypeResponse::connectionProperties)).setter(DescribeConnectionTypeResponse.setter(Builder::connectionProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Property::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Property>> CONNECTION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ConnectionOptions").getter(DescribeConnectionTypeResponse.getter(DescribeConnectionTypeResponse::connectionOptions)).setter(DescribeConnectionTypeResponse.setter(Builder::connectionOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Property::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AuthConfiguration> AUTHENTICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthenticationConfiguration").getter(DescribeConnectionTypeResponse.getter(DescribeConnectionTypeResponse::authenticationConfiguration)).setter(DescribeConnectionTypeResponse.setter(Builder::authenticationConfiguration)).constructor(AuthConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationConfiguration").build()}).build();
    private static final SdkField<Map<String, ComputeEnvironmentConfiguration>> COMPUTE_ENVIRONMENT_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ComputeEnvironmentConfigurations").getter(DescribeConnectionTypeResponse.getter(DescribeConnectionTypeResponse::computeEnvironmentConfigurations)).setter(DescribeConnectionTypeResponse.setter(Builder::computeEnvironmentConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeEnvironmentConfigurations").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComputeEnvironmentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Property>> PHYSICAL_CONNECTION_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("PhysicalConnectionRequirements").getter(DescribeConnectionTypeResponse.getter(DescribeConnectionTypeResponse::physicalConnectionRequirements)).setter(DescribeConnectionTypeResponse.setter(Builder::physicalConnectionRequirements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalConnectionRequirements").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Property::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Property>> ATHENA_CONNECTION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AthenaConnectionProperties").getter(DescribeConnectionTypeResponse.getter(DescribeConnectionTypeResponse::athenaConnectionProperties)).setter(DescribeConnectionTypeResponse.setter(Builder::athenaConnectionProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AthenaConnectionProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Property::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Property>> PYTHON_CONNECTION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("PythonConnectionProperties").getter(DescribeConnectionTypeResponse.getter(DescribeConnectionTypeResponse::pythonConnectionProperties)).setter(DescribeConnectionTypeResponse.setter(Builder::pythonConnectionProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PythonConnectionProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Property::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Property>> SPARK_CONNECTION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("SparkConnectionProperties").getter(DescribeConnectionTypeResponse.getter(DescribeConnectionTypeResponse::sparkConnectionProperties)).setter(DescribeConnectionTypeResponse.setter(Builder::sparkConnectionProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SparkConnectionProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Property::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_TYPE_FIELD, DESCRIPTION_FIELD, CAPABILITIES_FIELD, CONNECTION_PROPERTIES_FIELD, CONNECTION_OPTIONS_FIELD, AUTHENTICATION_CONFIGURATION_FIELD, COMPUTE_ENVIRONMENT_CONFIGURATIONS_FIELD, PHYSICAL_CONNECTION_REQUIREMENTS_FIELD, ATHENA_CONNECTION_PROPERTIES_FIELD, PYTHON_CONNECTION_PROPERTIES_FIELD, SPARK_CONNECTION_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeConnectionTypeResponse.memberNameToFieldInitializer();
    private final String connectionType;
    private final String description;
    private final Capabilities capabilities;
    private final Map<String, Property> connectionProperties;
    private final Map<String, Property> connectionOptions;
    private final AuthConfiguration authenticationConfiguration;
    private final Map<String, ComputeEnvironmentConfiguration> computeEnvironmentConfigurations;
    private final Map<String, Property> physicalConnectionRequirements;
    private final Map<String, Property> athenaConnectionProperties;
    private final Map<String, Property> pythonConnectionProperties;
    private final Map<String, Property> sparkConnectionProperties;

    private DescribeConnectionTypeResponse(BuilderImpl builder) {
        super(builder);
        this.connectionType = builder.connectionType;
        this.description = builder.description;
        this.capabilities = builder.capabilities;
        this.connectionProperties = builder.connectionProperties;
        this.connectionOptions = builder.connectionOptions;
        this.authenticationConfiguration = builder.authenticationConfiguration;
        this.computeEnvironmentConfigurations = builder.computeEnvironmentConfigurations;
        this.physicalConnectionRequirements = builder.physicalConnectionRequirements;
        this.athenaConnectionProperties = builder.athenaConnectionProperties;
        this.pythonConnectionProperties = builder.pythonConnectionProperties;
        this.sparkConnectionProperties = builder.sparkConnectionProperties;
    }

    public final String connectionType() {
        return this.connectionType;
    }

    public final String description() {
        return this.description;
    }

    public final Capabilities capabilities() {
        return this.capabilities;
    }

    public final boolean hasConnectionProperties() {
        return this.connectionProperties != null && !(this.connectionProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, Property> connectionProperties() {
        return this.connectionProperties;
    }

    public final boolean hasConnectionOptions() {
        return this.connectionOptions != null && !(this.connectionOptions instanceof SdkAutoConstructMap);
    }

    public final Map<String, Property> connectionOptions() {
        return this.connectionOptions;
    }

    public final AuthConfiguration authenticationConfiguration() {
        return this.authenticationConfiguration;
    }

    public final boolean hasComputeEnvironmentConfigurations() {
        return this.computeEnvironmentConfigurations != null && !(this.computeEnvironmentConfigurations instanceof SdkAutoConstructMap);
    }

    public final Map<String, ComputeEnvironmentConfiguration> computeEnvironmentConfigurations() {
        return this.computeEnvironmentConfigurations;
    }

    public final boolean hasPhysicalConnectionRequirements() {
        return this.physicalConnectionRequirements != null && !(this.physicalConnectionRequirements instanceof SdkAutoConstructMap);
    }

    public final Map<String, Property> physicalConnectionRequirements() {
        return this.physicalConnectionRequirements;
    }

    public final boolean hasAthenaConnectionProperties() {
        return this.athenaConnectionProperties != null && !(this.athenaConnectionProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, Property> athenaConnectionProperties() {
        return this.athenaConnectionProperties;
    }

    public final boolean hasPythonConnectionProperties() {
        return this.pythonConnectionProperties != null && !(this.pythonConnectionProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, Property> pythonConnectionProperties() {
        return this.pythonConnectionProperties;
    }

    public final boolean hasSparkConnectionProperties() {
        return this.sparkConnectionProperties != null && !(this.sparkConnectionProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, Property> sparkConnectionProperties() {
        return this.sparkConnectionProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionType());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilities());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionProperties() ? this.connectionProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionOptions() ? this.connectionOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComputeEnvironmentConfigurations() ? this.computeEnvironmentConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhysicalConnectionRequirements() ? this.physicalConnectionRequirements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAthenaConnectionProperties() ? this.athenaConnectionProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPythonConnectionProperties() ? this.pythonConnectionProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSparkConnectionProperties() ? this.sparkConnectionProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectionTypeResponse)) {
            return false;
        }
        DescribeConnectionTypeResponse other = (DescribeConnectionTypeResponse)((Object)obj);
        return Objects.equals(this.connectionType(), other.connectionType()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.capabilities(), other.capabilities()) && this.hasConnectionProperties() == other.hasConnectionProperties() && Objects.equals(this.connectionProperties(), other.connectionProperties()) && this.hasConnectionOptions() == other.hasConnectionOptions() && Objects.equals(this.connectionOptions(), other.connectionOptions()) && Objects.equals(this.authenticationConfiguration(), other.authenticationConfiguration()) && this.hasComputeEnvironmentConfigurations() == other.hasComputeEnvironmentConfigurations() && Objects.equals(this.computeEnvironmentConfigurations(), other.computeEnvironmentConfigurations()) && this.hasPhysicalConnectionRequirements() == other.hasPhysicalConnectionRequirements() && Objects.equals(this.physicalConnectionRequirements(), other.physicalConnectionRequirements()) && this.hasAthenaConnectionProperties() == other.hasAthenaConnectionProperties() && Objects.equals(this.athenaConnectionProperties(), other.athenaConnectionProperties()) && this.hasPythonConnectionProperties() == other.hasPythonConnectionProperties() && Objects.equals(this.pythonConnectionProperties(), other.pythonConnectionProperties()) && this.hasSparkConnectionProperties() == other.hasSparkConnectionProperties() && Objects.equals(this.sparkConnectionProperties(), other.sparkConnectionProperties());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConnectionTypeResponse").add("ConnectionType", (Object)this.connectionType()).add("Description", (Object)this.description()).add("Capabilities", (Object)this.capabilities()).add("ConnectionProperties", this.hasConnectionProperties() ? this.connectionProperties() : null).add("ConnectionOptions", this.hasConnectionOptions() ? this.connectionOptions() : null).add("AuthenticationConfiguration", (Object)this.authenticationConfiguration()).add("ComputeEnvironmentConfigurations", this.hasComputeEnvironmentConfigurations() ? this.computeEnvironmentConfigurations() : null).add("PhysicalConnectionRequirements", this.hasPhysicalConnectionRequirements() ? this.physicalConnectionRequirements() : null).add("AthenaConnectionProperties", this.hasAthenaConnectionProperties() ? this.athenaConnectionProperties() : null).add("PythonConnectionProperties", this.hasPythonConnectionProperties() ? this.pythonConnectionProperties() : null).add("SparkConnectionProperties", this.hasSparkConnectionProperties() ? this.sparkConnectionProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionType()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilities()));
            }
            case "ConnectionProperties": {
                return Optional.ofNullable(clazz.cast(this.connectionProperties()));
            }
            case "ConnectionOptions": {
                return Optional.ofNullable(clazz.cast(this.connectionOptions()));
            }
            case "AuthenticationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.authenticationConfiguration()));
            }
            case "ComputeEnvironmentConfigurations": {
                return Optional.ofNullable(clazz.cast(this.computeEnvironmentConfigurations()));
            }
            case "PhysicalConnectionRequirements": {
                return Optional.ofNullable(clazz.cast(this.physicalConnectionRequirements()));
            }
            case "AthenaConnectionProperties": {
                return Optional.ofNullable(clazz.cast(this.athenaConnectionProperties()));
            }
            case "PythonConnectionProperties": {
                return Optional.ofNullable(clazz.cast(this.pythonConnectionProperties()));
            }
            case "SparkConnectionProperties": {
                return Optional.ofNullable(clazz.cast(this.sparkConnectionProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConnectionType", CONNECTION_TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Capabilities", CAPABILITIES_FIELD);
        map.put("ConnectionProperties", CONNECTION_PROPERTIES_FIELD);
        map.put("ConnectionOptions", CONNECTION_OPTIONS_FIELD);
        map.put("AuthenticationConfiguration", AUTHENTICATION_CONFIGURATION_FIELD);
        map.put("ComputeEnvironmentConfigurations", COMPUTE_ENVIRONMENT_CONFIGURATIONS_FIELD);
        map.put("PhysicalConnectionRequirements", PHYSICAL_CONNECTION_REQUIREMENTS_FIELD);
        map.put("AthenaConnectionProperties", ATHENA_CONNECTION_PROPERTIES_FIELD);
        map.put("PythonConnectionProperties", PYTHON_CONNECTION_PROPERTIES_FIELD);
        map.put("SparkConnectionProperties", SPARK_CONNECTION_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectionTypeResponse, T> g) {
        return obj -> g.apply((DescribeConnectionTypeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private String connectionType;
        private String description;
        private Capabilities capabilities;
        private Map<String, Property> connectionProperties = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, Property> connectionOptions = DefaultSdkAutoConstructMap.getInstance();
        private AuthConfiguration authenticationConfiguration;
        private Map<String, ComputeEnvironmentConfiguration> computeEnvironmentConfigurations = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, Property> physicalConnectionRequirements = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, Property> athenaConnectionProperties = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, Property> pythonConnectionProperties = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, Property> sparkConnectionProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectionTypeResponse model) {
            super(model);
            this.connectionType(model.connectionType);
            this.description(model.description);
            this.capabilities(model.capabilities);
            this.connectionProperties(model.connectionProperties);
            this.connectionOptions(model.connectionOptions);
            this.authenticationConfiguration(model.authenticationConfiguration);
            this.computeEnvironmentConfigurations(model.computeEnvironmentConfigurations);
            this.physicalConnectionRequirements(model.physicalConnectionRequirements);
            this.athenaConnectionProperties(model.athenaConnectionProperties);
            this.pythonConnectionProperties(model.pythonConnectionProperties);
            this.sparkConnectionProperties(model.sparkConnectionProperties);
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Capabilities.Builder getCapabilities() {
            return this.capabilities != null ? this.capabilities.toBuilder() : null;
        }

        public final void setCapabilities(Capabilities.BuilderImpl capabilities) {
            this.capabilities = capabilities != null ? capabilities.build() : null;
        }

        @Override
        public final Builder capabilities(Capabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public final Map<String, Property.Builder> getConnectionProperties() {
            Map<String, Property.Builder> result = PropertiesMapCopier.copyToBuilder(this.connectionProperties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setConnectionProperties(Map<String, Property.BuilderImpl> connectionProperties) {
            this.connectionProperties = PropertiesMapCopier.copyFromBuilder(connectionProperties);
        }

        @Override
        public final Builder connectionProperties(Map<String, Property> connectionProperties) {
            this.connectionProperties = PropertiesMapCopier.copy(connectionProperties);
            return this;
        }

        public final Map<String, Property.Builder> getConnectionOptions() {
            Map<String, Property.Builder> result = PropertiesMapCopier.copyToBuilder(this.connectionOptions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setConnectionOptions(Map<String, Property.BuilderImpl> connectionOptions) {
            this.connectionOptions = PropertiesMapCopier.copyFromBuilder(connectionOptions);
        }

        @Override
        public final Builder connectionOptions(Map<String, Property> connectionOptions) {
            this.connectionOptions = PropertiesMapCopier.copy(connectionOptions);
            return this;
        }

        public final AuthConfiguration.Builder getAuthenticationConfiguration() {
            return this.authenticationConfiguration != null ? this.authenticationConfiguration.toBuilder() : null;
        }

        public final void setAuthenticationConfiguration(AuthConfiguration.BuilderImpl authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration != null ? authenticationConfiguration.build() : null;
        }

        @Override
        public final Builder authenticationConfiguration(AuthConfiguration authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public final Map<String, ComputeEnvironmentConfiguration.Builder> getComputeEnvironmentConfigurations() {
            Map<String, ComputeEnvironmentConfiguration.Builder> result = ComputeEnvironmentConfigurationMapCopier.copyToBuilder(this.computeEnvironmentConfigurations);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setComputeEnvironmentConfigurations(Map<String, ComputeEnvironmentConfiguration.BuilderImpl> computeEnvironmentConfigurations) {
            this.computeEnvironmentConfigurations = ComputeEnvironmentConfigurationMapCopier.copyFromBuilder(computeEnvironmentConfigurations);
        }

        @Override
        public final Builder computeEnvironmentConfigurations(Map<String, ComputeEnvironmentConfiguration> computeEnvironmentConfigurations) {
            this.computeEnvironmentConfigurations = ComputeEnvironmentConfigurationMapCopier.copy(computeEnvironmentConfigurations);
            return this;
        }

        public final Map<String, Property.Builder> getPhysicalConnectionRequirements() {
            Map<String, Property.Builder> result = PropertiesMapCopier.copyToBuilder(this.physicalConnectionRequirements);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPhysicalConnectionRequirements(Map<String, Property.BuilderImpl> physicalConnectionRequirements) {
            this.physicalConnectionRequirements = PropertiesMapCopier.copyFromBuilder(physicalConnectionRequirements);
        }

        @Override
        public final Builder physicalConnectionRequirements(Map<String, Property> physicalConnectionRequirements) {
            this.physicalConnectionRequirements = PropertiesMapCopier.copy(physicalConnectionRequirements);
            return this;
        }

        public final Map<String, Property.Builder> getAthenaConnectionProperties() {
            Map<String, Property.Builder> result = PropertiesMapCopier.copyToBuilder(this.athenaConnectionProperties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAthenaConnectionProperties(Map<String, Property.BuilderImpl> athenaConnectionProperties) {
            this.athenaConnectionProperties = PropertiesMapCopier.copyFromBuilder(athenaConnectionProperties);
        }

        @Override
        public final Builder athenaConnectionProperties(Map<String, Property> athenaConnectionProperties) {
            this.athenaConnectionProperties = PropertiesMapCopier.copy(athenaConnectionProperties);
            return this;
        }

        public final Map<String, Property.Builder> getPythonConnectionProperties() {
            Map<String, Property.Builder> result = PropertiesMapCopier.copyToBuilder(this.pythonConnectionProperties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPythonConnectionProperties(Map<String, Property.BuilderImpl> pythonConnectionProperties) {
            this.pythonConnectionProperties = PropertiesMapCopier.copyFromBuilder(pythonConnectionProperties);
        }

        @Override
        public final Builder pythonConnectionProperties(Map<String, Property> pythonConnectionProperties) {
            this.pythonConnectionProperties = PropertiesMapCopier.copy(pythonConnectionProperties);
            return this;
        }

        public final Map<String, Property.Builder> getSparkConnectionProperties() {
            Map<String, Property.Builder> result = PropertiesMapCopier.copyToBuilder(this.sparkConnectionProperties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSparkConnectionProperties(Map<String, Property.BuilderImpl> sparkConnectionProperties) {
            this.sparkConnectionProperties = PropertiesMapCopier.copyFromBuilder(sparkConnectionProperties);
        }

        @Override
        public final Builder sparkConnectionProperties(Map<String, Property> sparkConnectionProperties) {
            this.sparkConnectionProperties = PropertiesMapCopier.copy(sparkConnectionProperties);
            return this;
        }

        @Override
        public DescribeConnectionTypeResponse build() {
            return new DescribeConnectionTypeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConnectionTypeResponse> {
        public Builder connectionType(String var1);

        public Builder description(String var1);

        public Builder capabilities(Capabilities var1);

        default public Builder capabilities(Consumer<Capabilities.Builder> capabilities) {
            return this.capabilities((Capabilities)((Capabilities.Builder)Capabilities.builder().applyMutation(capabilities)).build());
        }

        public Builder connectionProperties(Map<String, Property> var1);

        public Builder connectionOptions(Map<String, Property> var1);

        public Builder authenticationConfiguration(AuthConfiguration var1);

        default public Builder authenticationConfiguration(Consumer<AuthConfiguration.Builder> authenticationConfiguration) {
            return this.authenticationConfiguration((AuthConfiguration)((AuthConfiguration.Builder)AuthConfiguration.builder().applyMutation(authenticationConfiguration)).build());
        }

        public Builder computeEnvironmentConfigurations(Map<String, ComputeEnvironmentConfiguration> var1);

        public Builder physicalConnectionRequirements(Map<String, Property> var1);

        public Builder athenaConnectionProperties(Map<String, Property> var1);

        public Builder pythonConnectionProperties(Map<String, Property> var1);

        public Builder sparkConnectionProperties(Map<String, Property> var1);
    }
}

