/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSchemaResponse extends GlueResponse implements
        ToCopyableBuilder<UpdateSchemaResponse.Builder, UpdateSchemaResponse> {
    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaArn").getter(getter(UpdateSchemaResponse::schemaArn)).setter(setter(Builder::schemaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaArn").build()).build();

    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaName").getter(getter(UpdateSchemaResponse::schemaName)).setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaName").build()).build();

    private static final SdkField<String> REGISTRY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistryName").getter(getter(UpdateSchemaResponse::registryName)).setter(setter(Builder::registryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ARN_FIELD,
            SCHEMA_NAME_FIELD, REGISTRY_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String schemaArn;

    private final String schemaName;

    private final String registryName;

    private UpdateSchemaResponse(BuilderImpl builder) {
        super(builder);
        this.schemaArn = builder.schemaArn;
        this.schemaName = builder.schemaName;
        this.registryName = builder.registryName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the schema.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the schema.
     */
    public final String schemaArn() {
        return schemaArn;
    }

    /**
     * <p>
     * The name of the schema.
     * </p>
     * 
     * @return The name of the schema.
     */
    public final String schemaName() {
        return schemaName;
    }

    /**
     * <p>
     * The name of the registry that contains the schema.
     * </p>
     * 
     * @return The name of the registry that contains the schema.
     */
    public final String registryName() {
        return registryName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(registryName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSchemaResponse)) {
            return false;
        }
        UpdateSchemaResponse other = (UpdateSchemaResponse) obj;
        return Objects.equals(schemaArn(), other.schemaArn()) && Objects.equals(schemaName(), other.schemaName())
                && Objects.equals(registryName(), other.registryName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSchemaResponse").add("SchemaArn", schemaArn()).add("SchemaName", schemaName())
                .add("RegistryName", registryName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaArn":
            return Optional.ofNullable(clazz.cast(schemaArn()));
        case "SchemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        case "RegistryName":
            return Optional.ofNullable(clazz.cast(registryName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SchemaArn", SCHEMA_ARN_FIELD);
        map.put("SchemaName", SCHEMA_NAME_FIELD);
        map.put("RegistryName", REGISTRY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSchemaResponse, T> g) {
        return obj -> g.apply((UpdateSchemaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSchemaResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the schema.
         * </p>
         * 
         * @param schemaArn
         *        The Amazon Resource Name (ARN) of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaArn(String schemaArn);

        /**
         * <p>
         * The name of the schema.
         * </p>
         * 
         * @param schemaName
         *        The name of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);

        /**
         * <p>
         * The name of the registry that contains the schema.
         * </p>
         * 
         * @param registryName
         *        The name of the registry that contains the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryName(String registryName);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private String schemaArn;

        private String schemaName;

        private String registryName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSchemaResponse model) {
            super(model);
            schemaArn(model.schemaArn);
            schemaName(model.schemaName);
            registryName(model.registryName);
        }

        public final String getSchemaArn() {
            return schemaArn;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final String getSchemaName() {
            return schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final String getRegistryName() {
            return registryName;
        }

        public final void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        @Override
        public final Builder registryName(String registryName) {
            this.registryName = registryName;
            return this;
        }

        @Override
        public UpdateSchemaResponse build() {
            return new UpdateSchemaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
