/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a statistic.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatisticSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<StatisticSummary.Builder, StatisticSummary> {
    private static final SdkField<String> STATISTIC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatisticId").getter(getter(StatisticSummary::statisticId)).setter(setter(Builder::statisticId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatisticId").build()).build();

    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileId").getter(getter(StatisticSummary::profileId)).setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()).build();

    private static final SdkField<RunIdentifier> RUN_IDENTIFIER_FIELD = SdkField
            .<RunIdentifier> builder(MarshallingType.SDK_POJO).memberName("RunIdentifier")
            .getter(getter(StatisticSummary::runIdentifier)).setter(setter(Builder::runIdentifier))
            .constructor(RunIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunIdentifier").build()).build();

    private static final SdkField<String> STATISTIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatisticName").getter(getter(StatisticSummary::statisticName)).setter(setter(Builder::statisticName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatisticName").build()).build();

    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("DoubleValue").getter(getter(StatisticSummary::doubleValue)).setter(setter(Builder::doubleValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DoubleValue").build()).build();

    private static final SdkField<String> EVALUATION_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationLevel").getter(getter(StatisticSummary::evaluationLevelAsString))
            .setter(setter(Builder::evaluationLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationLevel").build()).build();

    private static final SdkField<List<String>> COLUMNS_REFERENCED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ColumnsReferenced")
            .getter(getter(StatisticSummary::columnsReferenced))
            .setter(setter(Builder::columnsReferenced))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnsReferenced").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REFERENCED_DATASETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReferencedDatasets")
            .getter(getter(StatisticSummary::referencedDatasets))
            .setter(setter(Builder::referencedDatasets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferencedDatasets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> STATISTIC_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("StatisticProperties")
            .getter(getter(StatisticSummary::statisticProperties))
            .setter(setter(Builder::statisticProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatisticProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> RECORDED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RecordedOn").getter(getter(StatisticSummary::recordedOn)).setter(setter(Builder::recordedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordedOn").build()).build();

    private static final SdkField<TimestampedInclusionAnnotation> INCLUSION_ANNOTATION_FIELD = SdkField
            .<TimestampedInclusionAnnotation> builder(MarshallingType.SDK_POJO).memberName("InclusionAnnotation")
            .getter(getter(StatisticSummary::inclusionAnnotation)).setter(setter(Builder::inclusionAnnotation))
            .constructor(TimestampedInclusionAnnotation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionAnnotation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATISTIC_ID_FIELD,
            PROFILE_ID_FIELD, RUN_IDENTIFIER_FIELD, STATISTIC_NAME_FIELD, DOUBLE_VALUE_FIELD, EVALUATION_LEVEL_FIELD,
            COLUMNS_REFERENCED_FIELD, REFERENCED_DATASETS_FIELD, STATISTIC_PROPERTIES_FIELD, RECORDED_ON_FIELD,
            INCLUSION_ANNOTATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String statisticId;

    private final String profileId;

    private final RunIdentifier runIdentifier;

    private final String statisticName;

    private final Double doubleValue;

    private final String evaluationLevel;

    private final List<String> columnsReferenced;

    private final List<String> referencedDatasets;

    private final Map<String, String> statisticProperties;

    private final Instant recordedOn;

    private final TimestampedInclusionAnnotation inclusionAnnotation;

    private StatisticSummary(BuilderImpl builder) {
        this.statisticId = builder.statisticId;
        this.profileId = builder.profileId;
        this.runIdentifier = builder.runIdentifier;
        this.statisticName = builder.statisticName;
        this.doubleValue = builder.doubleValue;
        this.evaluationLevel = builder.evaluationLevel;
        this.columnsReferenced = builder.columnsReferenced;
        this.referencedDatasets = builder.referencedDatasets;
        this.statisticProperties = builder.statisticProperties;
        this.recordedOn = builder.recordedOn;
        this.inclusionAnnotation = builder.inclusionAnnotation;
    }

    /**
     * <p>
     * The Statistic ID.
     * </p>
     * 
     * @return The Statistic ID.
     */
    public final String statisticId() {
        return statisticId;
    }

    /**
     * <p>
     * The Profile ID.
     * </p>
     * 
     * @return The Profile ID.
     */
    public final String profileId() {
        return profileId;
    }

    /**
     * <p>
     * The Run Identifier
     * </p>
     * 
     * @return The Run Identifier
     */
    public final RunIdentifier runIdentifier() {
        return runIdentifier;
    }

    /**
     * <p>
     * The name of the statistic.
     * </p>
     * 
     * @return The name of the statistic.
     */
    public final String statisticName() {
        return statisticName;
    }

    /**
     * <p>
     * The value of the statistic.
     * </p>
     * 
     * @return The value of the statistic.
     */
    public final Double doubleValue() {
        return doubleValue;
    }

    /**
     * <p>
     * The evaluation level of the statistic. Possible values: <code>Dataset</code>, <code>Column</code>,
     * <code>Multicolumn</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationLevel}
     * will return {@link StatisticEvaluationLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #evaluationLevelAsString}.
     * </p>
     * 
     * @return The evaluation level of the statistic. Possible values: <code>Dataset</code>, <code>Column</code>,
     *         <code>Multicolumn</code>.
     * @see StatisticEvaluationLevel
     */
    public final StatisticEvaluationLevel evaluationLevel() {
        return StatisticEvaluationLevel.fromValue(evaluationLevel);
    }

    /**
     * <p>
     * The evaluation level of the statistic. Possible values: <code>Dataset</code>, <code>Column</code>,
     * <code>Multicolumn</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationLevel}
     * will return {@link StatisticEvaluationLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #evaluationLevelAsString}.
     * </p>
     * 
     * @return The evaluation level of the statistic. Possible values: <code>Dataset</code>, <code>Column</code>,
     *         <code>Multicolumn</code>.
     * @see StatisticEvaluationLevel
     */
    public final String evaluationLevelAsString() {
        return evaluationLevel;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnsReferenced property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasColumnsReferenced() {
        return columnsReferenced != null && !(columnsReferenced instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of columns referenced by the statistic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnsReferenced} method.
     * </p>
     * 
     * @return The list of columns referenced by the statistic.
     */
    public final List<String> columnsReferenced() {
        return columnsReferenced;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReferencedDatasets property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReferencedDatasets() {
        return referencedDatasets != null && !(referencedDatasets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of datasets referenced by the statistic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferencedDatasets} method.
     * </p>
     * 
     * @return The list of datasets referenced by the statistic.
     */
    public final List<String> referencedDatasets() {
        return referencedDatasets;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatisticProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatisticProperties() {
        return statisticProperties != null && !(statisticProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A <code>StatisticPropertiesMap</code>, which contains a <code>NameString</code> and
     * <code>DescriptionString</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatisticProperties} method.
     * </p>
     * 
     * @return A <code>StatisticPropertiesMap</code>, which contains a <code>NameString</code> and
     *         <code>DescriptionString</code>
     */
    public final Map<String, String> statisticProperties() {
        return statisticProperties;
    }

    /**
     * <p>
     * The timestamp when the statistic was recorded.
     * </p>
     * 
     * @return The timestamp when the statistic was recorded.
     */
    public final Instant recordedOn() {
        return recordedOn;
    }

    /**
     * <p>
     * The inclusion annotation for the statistic.
     * </p>
     * 
     * @return The inclusion annotation for the statistic.
     */
    public final TimestampedInclusionAnnotation inclusionAnnotation() {
        return inclusionAnnotation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statisticId());
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        hashCode = 31 * hashCode + Objects.hashCode(runIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(statisticName());
        hashCode = 31 * hashCode + Objects.hashCode(doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnsReferenced() ? columnsReferenced() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReferencedDatasets() ? referencedDatasets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatisticProperties() ? statisticProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(recordedOn());
        hashCode = 31 * hashCode + Objects.hashCode(inclusionAnnotation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatisticSummary)) {
            return false;
        }
        StatisticSummary other = (StatisticSummary) obj;
        return Objects.equals(statisticId(), other.statisticId()) && Objects.equals(profileId(), other.profileId())
                && Objects.equals(runIdentifier(), other.runIdentifier())
                && Objects.equals(statisticName(), other.statisticName()) && Objects.equals(doubleValue(), other.doubleValue())
                && Objects.equals(evaluationLevelAsString(), other.evaluationLevelAsString())
                && hasColumnsReferenced() == other.hasColumnsReferenced()
                && Objects.equals(columnsReferenced(), other.columnsReferenced())
                && hasReferencedDatasets() == other.hasReferencedDatasets()
                && Objects.equals(referencedDatasets(), other.referencedDatasets())
                && hasStatisticProperties() == other.hasStatisticProperties()
                && Objects.equals(statisticProperties(), other.statisticProperties())
                && Objects.equals(recordedOn(), other.recordedOn())
                && Objects.equals(inclusionAnnotation(), other.inclusionAnnotation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatisticSummary").add("StatisticId", statisticId()).add("ProfileId", profileId())
                .add("RunIdentifier", runIdentifier()).add("StatisticName", statisticName()).add("DoubleValue", doubleValue())
                .add("EvaluationLevel", evaluationLevelAsString())
                .add("ColumnsReferenced", hasColumnsReferenced() ? columnsReferenced() : null)
                .add("ReferencedDatasets", hasReferencedDatasets() ? referencedDatasets() : null)
                .add("StatisticProperties", statisticProperties() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RecordedOn", recordedOn()).add("InclusionAnnotation", inclusionAnnotation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatisticId":
            return Optional.ofNullable(clazz.cast(statisticId()));
        case "ProfileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        case "RunIdentifier":
            return Optional.ofNullable(clazz.cast(runIdentifier()));
        case "StatisticName":
            return Optional.ofNullable(clazz.cast(statisticName()));
        case "DoubleValue":
            return Optional.ofNullable(clazz.cast(doubleValue()));
        case "EvaluationLevel":
            return Optional.ofNullable(clazz.cast(evaluationLevelAsString()));
        case "ColumnsReferenced":
            return Optional.ofNullable(clazz.cast(columnsReferenced()));
        case "ReferencedDatasets":
            return Optional.ofNullable(clazz.cast(referencedDatasets()));
        case "StatisticProperties":
            return Optional.ofNullable(clazz.cast(statisticProperties()));
        case "RecordedOn":
            return Optional.ofNullable(clazz.cast(recordedOn()));
        case "InclusionAnnotation":
            return Optional.ofNullable(clazz.cast(inclusionAnnotation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StatisticId", STATISTIC_ID_FIELD);
        map.put("ProfileId", PROFILE_ID_FIELD);
        map.put("RunIdentifier", RUN_IDENTIFIER_FIELD);
        map.put("StatisticName", STATISTIC_NAME_FIELD);
        map.put("DoubleValue", DOUBLE_VALUE_FIELD);
        map.put("EvaluationLevel", EVALUATION_LEVEL_FIELD);
        map.put("ColumnsReferenced", COLUMNS_REFERENCED_FIELD);
        map.put("ReferencedDatasets", REFERENCED_DATASETS_FIELD);
        map.put("StatisticProperties", STATISTIC_PROPERTIES_FIELD);
        map.put("RecordedOn", RECORDED_ON_FIELD);
        map.put("InclusionAnnotation", INCLUSION_ANNOTATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StatisticSummary, T> g) {
        return obj -> g.apply((StatisticSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatisticSummary> {
        /**
         * <p>
         * The Statistic ID.
         * </p>
         * 
         * @param statisticId
         *        The Statistic ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticId(String statisticId);

        /**
         * <p>
         * The Profile ID.
         * </p>
         * 
         * @param profileId
         *        The Profile ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        /**
         * <p>
         * The Run Identifier
         * </p>
         * 
         * @param runIdentifier
         *        The Run Identifier
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runIdentifier(RunIdentifier runIdentifier);

        /**
         * <p>
         * The Run Identifier
         * </p>
         * This is a convenience method that creates an instance of the {@link RunIdentifier.Builder} avoiding the need
         * to create one manually via {@link RunIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RunIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #runIdentifier(RunIdentifier)}.
         * 
         * @param runIdentifier
         *        a consumer that will call methods on {@link RunIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runIdentifier(RunIdentifier)
         */
        default Builder runIdentifier(Consumer<RunIdentifier.Builder> runIdentifier) {
            return runIdentifier(RunIdentifier.builder().applyMutation(runIdentifier).build());
        }

        /**
         * <p>
         * The name of the statistic.
         * </p>
         * 
         * @param statisticName
         *        The name of the statistic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticName(String statisticName);

        /**
         * <p>
         * The value of the statistic.
         * </p>
         * 
         * @param doubleValue
         *        The value of the statistic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleValue(Double doubleValue);

        /**
         * <p>
         * The evaluation level of the statistic. Possible values: <code>Dataset</code>, <code>Column</code>,
         * <code>Multicolumn</code>.
         * </p>
         * 
         * @param evaluationLevel
         *        The evaluation level of the statistic. Possible values: <code>Dataset</code>, <code>Column</code>,
         *        <code>Multicolumn</code>.
         * @see StatisticEvaluationLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatisticEvaluationLevel
         */
        Builder evaluationLevel(String evaluationLevel);

        /**
         * <p>
         * The evaluation level of the statistic. Possible values: <code>Dataset</code>, <code>Column</code>,
         * <code>Multicolumn</code>.
         * </p>
         * 
         * @param evaluationLevel
         *        The evaluation level of the statistic. Possible values: <code>Dataset</code>, <code>Column</code>,
         *        <code>Multicolumn</code>.
         * @see StatisticEvaluationLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatisticEvaluationLevel
         */
        Builder evaluationLevel(StatisticEvaluationLevel evaluationLevel);

        /**
         * <p>
         * The list of columns referenced by the statistic.
         * </p>
         * 
         * @param columnsReferenced
         *        The list of columns referenced by the statistic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnsReferenced(Collection<String> columnsReferenced);

        /**
         * <p>
         * The list of columns referenced by the statistic.
         * </p>
         * 
         * @param columnsReferenced
         *        The list of columns referenced by the statistic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnsReferenced(String... columnsReferenced);

        /**
         * <p>
         * The list of datasets referenced by the statistic.
         * </p>
         * 
         * @param referencedDatasets
         *        The list of datasets referenced by the statistic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referencedDatasets(Collection<String> referencedDatasets);

        /**
         * <p>
         * The list of datasets referenced by the statistic.
         * </p>
         * 
         * @param referencedDatasets
         *        The list of datasets referenced by the statistic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referencedDatasets(String... referencedDatasets);

        /**
         * <p>
         * A <code>StatisticPropertiesMap</code>, which contains a <code>NameString</code> and
         * <code>DescriptionString</code>
         * </p>
         * 
         * @param statisticProperties
         *        A <code>StatisticPropertiesMap</code>, which contains a <code>NameString</code> and
         *        <code>DescriptionString</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticProperties(Map<String, String> statisticProperties);

        /**
         * <p>
         * The timestamp when the statistic was recorded.
         * </p>
         * 
         * @param recordedOn
         *        The timestamp when the statistic was recorded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordedOn(Instant recordedOn);

        /**
         * <p>
         * The inclusion annotation for the statistic.
         * </p>
         * 
         * @param inclusionAnnotation
         *        The inclusion annotation for the statistic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionAnnotation(TimestampedInclusionAnnotation inclusionAnnotation);

        /**
         * <p>
         * The inclusion annotation for the statistic.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimestampedInclusionAnnotation.Builder}
         * avoiding the need to create one manually via {@link TimestampedInclusionAnnotation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimestampedInclusionAnnotation.Builder#build()} is called
         * immediately and its result is passed to {@link #inclusionAnnotation(TimestampedInclusionAnnotation)}.
         * 
         * @param inclusionAnnotation
         *        a consumer that will call methods on {@link TimestampedInclusionAnnotation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inclusionAnnotation(TimestampedInclusionAnnotation)
         */
        default Builder inclusionAnnotation(Consumer<TimestampedInclusionAnnotation.Builder> inclusionAnnotation) {
            return inclusionAnnotation(TimestampedInclusionAnnotation.builder().applyMutation(inclusionAnnotation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String statisticId;

        private String profileId;

        private RunIdentifier runIdentifier;

        private String statisticName;

        private Double doubleValue;

        private String evaluationLevel;

        private List<String> columnsReferenced = DefaultSdkAutoConstructList.getInstance();

        private List<String> referencedDatasets = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> statisticProperties = DefaultSdkAutoConstructMap.getInstance();

        private Instant recordedOn;

        private TimestampedInclusionAnnotation inclusionAnnotation;

        private BuilderImpl() {
        }

        private BuilderImpl(StatisticSummary model) {
            statisticId(model.statisticId);
            profileId(model.profileId);
            runIdentifier(model.runIdentifier);
            statisticName(model.statisticName);
            doubleValue(model.doubleValue);
            evaluationLevel(model.evaluationLevel);
            columnsReferenced(model.columnsReferenced);
            referencedDatasets(model.referencedDatasets);
            statisticProperties(model.statisticProperties);
            recordedOn(model.recordedOn);
            inclusionAnnotation(model.inclusionAnnotation);
        }

        public final String getStatisticId() {
            return statisticId;
        }

        public final void setStatisticId(String statisticId) {
            this.statisticId = statisticId;
        }

        @Override
        public final Builder statisticId(String statisticId) {
            this.statisticId = statisticId;
            return this;
        }

        public final String getProfileId() {
            return profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final RunIdentifier.Builder getRunIdentifier() {
            return runIdentifier != null ? runIdentifier.toBuilder() : null;
        }

        public final void setRunIdentifier(RunIdentifier.BuilderImpl runIdentifier) {
            this.runIdentifier = runIdentifier != null ? runIdentifier.build() : null;
        }

        @Override
        public final Builder runIdentifier(RunIdentifier runIdentifier) {
            this.runIdentifier = runIdentifier;
            return this;
        }

        public final String getStatisticName() {
            return statisticName;
        }

        public final void setStatisticName(String statisticName) {
            this.statisticName = statisticName;
        }

        @Override
        public final Builder statisticName(String statisticName) {
            this.statisticName = statisticName;
            return this;
        }

        public final Double getDoubleValue() {
            return doubleValue;
        }

        public final void setDoubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
        }

        @Override
        public final Builder doubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
            return this;
        }

        public final String getEvaluationLevel() {
            return evaluationLevel;
        }

        public final void setEvaluationLevel(String evaluationLevel) {
            this.evaluationLevel = evaluationLevel;
        }

        @Override
        public final Builder evaluationLevel(String evaluationLevel) {
            this.evaluationLevel = evaluationLevel;
            return this;
        }

        @Override
        public final Builder evaluationLevel(StatisticEvaluationLevel evaluationLevel) {
            this.evaluationLevel(evaluationLevel == null ? null : evaluationLevel.toString());
            return this;
        }

        public final Collection<String> getColumnsReferenced() {
            if (columnsReferenced instanceof SdkAutoConstructList) {
                return null;
            }
            return columnsReferenced;
        }

        public final void setColumnsReferenced(Collection<String> columnsReferenced) {
            this.columnsReferenced = ColumnNameListCopier.copy(columnsReferenced);
        }

        @Override
        public final Builder columnsReferenced(Collection<String> columnsReferenced) {
            this.columnsReferenced = ColumnNameListCopier.copy(columnsReferenced);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnsReferenced(String... columnsReferenced) {
            columnsReferenced(Arrays.asList(columnsReferenced));
            return this;
        }

        public final Collection<String> getReferencedDatasets() {
            if (referencedDatasets instanceof SdkAutoConstructList) {
                return null;
            }
            return referencedDatasets;
        }

        public final void setReferencedDatasets(Collection<String> referencedDatasets) {
            this.referencedDatasets = ReferenceDatasetsListCopier.copy(referencedDatasets);
        }

        @Override
        public final Builder referencedDatasets(Collection<String> referencedDatasets) {
            this.referencedDatasets = ReferenceDatasetsListCopier.copy(referencedDatasets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referencedDatasets(String... referencedDatasets) {
            referencedDatasets(Arrays.asList(referencedDatasets));
            return this;
        }

        public final Map<String, String> getStatisticProperties() {
            if (statisticProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return statisticProperties;
        }

        public final void setStatisticProperties(Map<String, String> statisticProperties) {
            this.statisticProperties = StatisticPropertiesMapCopier.copy(statisticProperties);
        }

        @Override
        public final Builder statisticProperties(Map<String, String> statisticProperties) {
            this.statisticProperties = StatisticPropertiesMapCopier.copy(statisticProperties);
            return this;
        }

        public final Instant getRecordedOn() {
            return recordedOn;
        }

        public final void setRecordedOn(Instant recordedOn) {
            this.recordedOn = recordedOn;
        }

        @Override
        public final Builder recordedOn(Instant recordedOn) {
            this.recordedOn = recordedOn;
            return this;
        }

        public final TimestampedInclusionAnnotation.Builder getInclusionAnnotation() {
            return inclusionAnnotation != null ? inclusionAnnotation.toBuilder() : null;
        }

        public final void setInclusionAnnotation(TimestampedInclusionAnnotation.BuilderImpl inclusionAnnotation) {
            this.inclusionAnnotation = inclusionAnnotation != null ? inclusionAnnotation.build() : null;
        }

        @Override
        public final Builder inclusionAnnotation(TimestampedInclusionAnnotation inclusionAnnotation) {
            this.inclusionAnnotation = inclusionAnnotation;
            return this;
        }

        @Override
        public StatisticSummary build() {
            return new StatisticSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
