/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetColumnStatisticsTaskSettingsResponse extends GlueResponse implements
        ToCopyableBuilder<GetColumnStatisticsTaskSettingsResponse.Builder, GetColumnStatisticsTaskSettingsResponse> {
    private static final SdkField<ColumnStatisticsTaskSettings> COLUMN_STATISTICS_TASK_SETTINGS_FIELD = SdkField
            .<ColumnStatisticsTaskSettings> builder(MarshallingType.SDK_POJO)
            .memberName("ColumnStatisticsTaskSettings")
            .getter(getter(GetColumnStatisticsTaskSettingsResponse::columnStatisticsTaskSettings))
            .setter(setter(Builder::columnStatisticsTaskSettings))
            .constructor(ColumnStatisticsTaskSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnStatisticsTaskSettings")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(COLUMN_STATISTICS_TASK_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ColumnStatisticsTaskSettings columnStatisticsTaskSettings;

    private GetColumnStatisticsTaskSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.columnStatisticsTaskSettings = builder.columnStatisticsTaskSettings;
    }

    /**
     * <p>
     * A <code>ColumnStatisticsTaskSettings</code> object representing the settings for the column statistics task.
     * </p>
     * 
     * @return A <code>ColumnStatisticsTaskSettings</code> object representing the settings for the column statistics
     *         task.
     */
    public final ColumnStatisticsTaskSettings columnStatisticsTaskSettings() {
        return columnStatisticsTaskSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(columnStatisticsTaskSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetColumnStatisticsTaskSettingsResponse)) {
            return false;
        }
        GetColumnStatisticsTaskSettingsResponse other = (GetColumnStatisticsTaskSettingsResponse) obj;
        return Objects.equals(columnStatisticsTaskSettings(), other.columnStatisticsTaskSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetColumnStatisticsTaskSettingsResponse")
                .add("ColumnStatisticsTaskSettings", columnStatisticsTaskSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnStatisticsTaskSettings":
            return Optional.ofNullable(clazz.cast(columnStatisticsTaskSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ColumnStatisticsTaskSettings", COLUMN_STATISTICS_TASK_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetColumnStatisticsTaskSettingsResponse, T> g) {
        return obj -> g.apply((GetColumnStatisticsTaskSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetColumnStatisticsTaskSettingsResponse> {
        /**
         * <p>
         * A <code>ColumnStatisticsTaskSettings</code> object representing the settings for the column statistics task.
         * </p>
         * 
         * @param columnStatisticsTaskSettings
         *        A <code>ColumnStatisticsTaskSettings</code> object representing the settings for the column statistics
         *        task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnStatisticsTaskSettings(ColumnStatisticsTaskSettings columnStatisticsTaskSettings);

        /**
         * <p>
         * A <code>ColumnStatisticsTaskSettings</code> object representing the settings for the column statistics task.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnStatisticsTaskSettings.Builder}
         * avoiding the need to create one manually via {@link ColumnStatisticsTaskSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnStatisticsTaskSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #columnStatisticsTaskSettings(ColumnStatisticsTaskSettings)}.
         * 
         * @param columnStatisticsTaskSettings
         *        a consumer that will call methods on {@link ColumnStatisticsTaskSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnStatisticsTaskSettings(ColumnStatisticsTaskSettings)
         */
        default Builder columnStatisticsTaskSettings(Consumer<ColumnStatisticsTaskSettings.Builder> columnStatisticsTaskSettings) {
            return columnStatisticsTaskSettings(ColumnStatisticsTaskSettings.builder()
                    .applyMutation(columnStatisticsTaskSettings).build());
        }
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private ColumnStatisticsTaskSettings columnStatisticsTaskSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(GetColumnStatisticsTaskSettingsResponse model) {
            super(model);
            columnStatisticsTaskSettings(model.columnStatisticsTaskSettings);
        }

        public final ColumnStatisticsTaskSettings.Builder getColumnStatisticsTaskSettings() {
            return columnStatisticsTaskSettings != null ? columnStatisticsTaskSettings.toBuilder() : null;
        }

        public final void setColumnStatisticsTaskSettings(ColumnStatisticsTaskSettings.BuilderImpl columnStatisticsTaskSettings) {
            this.columnStatisticsTaskSettings = columnStatisticsTaskSettings != null ? columnStatisticsTaskSettings.build()
                    : null;
        }

        @Override
        public final Builder columnStatisticsTaskSettings(ColumnStatisticsTaskSettings columnStatisticsTaskSettings) {
            this.columnStatisticsTaskSettings = columnStatisticsTaskSettings;
            return this;
        }

        @Override
        public GetColumnStatisticsTaskSettingsResponse build() {
            return new GetColumnStatisticsTaskSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
