/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBlueprintResponse extends GlueResponse implements
        ToCopyableBuilder<GetBlueprintResponse.Builder, GetBlueprintResponse> {
    private static final SdkField<Blueprint> BLUEPRINT_FIELD = SdkField.<Blueprint> builder(MarshallingType.SDK_POJO)
            .memberName("Blueprint").getter(getter(GetBlueprintResponse::blueprint)).setter(setter(Builder::blueprint))
            .constructor(Blueprint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blueprint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Blueprint blueprint;

    private GetBlueprintResponse(BuilderImpl builder) {
        super(builder);
        this.blueprint = builder.blueprint;
    }

    /**
     * <p>
     * Returns a <code>Blueprint</code> object.
     * </p>
     * 
     * @return Returns a <code>Blueprint</code> object.
     */
    public final Blueprint blueprint() {
        return blueprint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(blueprint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBlueprintResponse)) {
            return false;
        }
        GetBlueprintResponse other = (GetBlueprintResponse) obj;
        return Objects.equals(blueprint(), other.blueprint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBlueprintResponse").add("Blueprint", blueprint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Blueprint":
            return Optional.ofNullable(clazz.cast(blueprint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Blueprint", BLUEPRINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBlueprintResponse, T> g) {
        return obj -> g.apply((GetBlueprintResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBlueprintResponse> {
        /**
         * <p>
         * Returns a <code>Blueprint</code> object.
         * </p>
         * 
         * @param blueprint
         *        Returns a <code>Blueprint</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprint(Blueprint blueprint);

        /**
         * <p>
         * Returns a <code>Blueprint</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link Blueprint.Builder} avoiding the need to
         * create one manually via {@link Blueprint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Blueprint.Builder#build()} is called immediately and its result
         * is passed to {@link #blueprint(Blueprint)}.
         * 
         * @param blueprint
         *        a consumer that will call methods on {@link Blueprint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blueprint(Blueprint)
         */
        default Builder blueprint(Consumer<Blueprint.Builder> blueprint) {
            return blueprint(Blueprint.builder().applyMutation(blueprint).build());
        }
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private Blueprint blueprint;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBlueprintResponse model) {
            super(model);
            blueprint(model.blueprint);
        }

        public final Blueprint.Builder getBlueprint() {
            return blueprint != null ? blueprint.toBuilder() : null;
        }

        public final void setBlueprint(Blueprint.BuilderImpl blueprint) {
            this.blueprint = blueprint != null ? blueprint.build() : null;
        }

        @Override
        public final Builder blueprint(Blueprint blueprint) {
            this.blueprint = blueprint;
            return this;
        }

        @Override
        public GetBlueprintResponse build() {
            return new GetBlueprintResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
