/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Brief information about a supported connection type returned by the <code>ListConnectionTypes</code> API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionTypeBrief implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionTypeBrief.Builder, ConnectionTypeBrief> {
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionType").getter(getter(ConnectionTypeBrief::connectionTypeAsString))
            .setter(setter(Builder::connectionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ConnectionTypeBrief::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Capabilities> CAPABILITIES_FIELD = SdkField.<Capabilities> builder(MarshallingType.SDK_POJO)
            .memberName("Capabilities").getter(getter(ConnectionTypeBrief::capabilities)).setter(setter(Builder::capabilities))
            .constructor(Capabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_TYPE_FIELD,
            DESCRIPTION_FIELD, CAPABILITIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connectionType;

    private final String description;

    private final Capabilities capabilities;

    private ConnectionTypeBrief(BuilderImpl builder) {
        this.connectionType = builder.connectionType;
        this.description = builder.description;
        this.capabilities = builder.capabilities;
    }

    /**
     * <p>
     * The name of the connection type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The name of the connection type.
     * @see ConnectionType
     */
    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(connectionType);
    }

    /**
     * <p>
     * The name of the connection type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The name of the connection type.
     * @see ConnectionType
     */
    public final String connectionTypeAsString() {
        return connectionType;
    }

    /**
     * <p>
     * A description of the connection type.
     * </p>
     * 
     * @return A description of the connection type.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The supported authentication types, data interface types (compute environments), and data operations of the
     * connector.
     * </p>
     * 
     * @return The supported authentication types, data interface types (compute environments), and data operations of
     *         the connector.
     */
    public final Capabilities capabilities() {
        return capabilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(capabilities());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionTypeBrief)) {
            return false;
        }
        ConnectionTypeBrief other = (ConnectionTypeBrief) obj;
        return Objects.equals(connectionTypeAsString(), other.connectionTypeAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(capabilities(), other.capabilities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionTypeBrief").add("ConnectionType", connectionTypeAsString())
                .add("Description", description()).add("Capabilities", capabilities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionType":
            return Optional.ofNullable(clazz.cast(connectionTypeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectionType", CONNECTION_TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Capabilities", CAPABILITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionTypeBrief, T> g) {
        return obj -> g.apply((ConnectionTypeBrief) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionTypeBrief> {
        /**
         * <p>
         * The name of the connection type.
         * </p>
         * 
         * @param connectionType
         *        The name of the connection type.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(String connectionType);

        /**
         * <p>
         * The name of the connection type.
         * </p>
         * 
         * @param connectionType
         *        The name of the connection type.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(ConnectionType connectionType);

        /**
         * <p>
         * A description of the connection type.
         * </p>
         * 
         * @param description
         *        A description of the connection type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The supported authentication types, data interface types (compute environments), and data operations of the
         * connector.
         * </p>
         * 
         * @param capabilities
         *        The supported authentication types, data interface types (compute environments), and data operations
         *        of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Capabilities capabilities);

        /**
         * <p>
         * The supported authentication types, data interface types (compute environments), and data operations of the
         * connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link Capabilities.Builder} avoiding the need
         * to create one manually via {@link Capabilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Capabilities.Builder#build()} is called immediately and its
         * result is passed to {@link #capabilities(Capabilities)}.
         * 
         * @param capabilities
         *        a consumer that will call methods on {@link Capabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilities(Capabilities)
         */
        default Builder capabilities(Consumer<Capabilities.Builder> capabilities) {
            return capabilities(Capabilities.builder().applyMutation(capabilities).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String connectionType;

        private String description;

        private Capabilities capabilities;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionTypeBrief model) {
            connectionType(model.connectionType);
            description(model.description);
            capabilities(model.capabilities);
        }

        public final String getConnectionType() {
            return connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Capabilities.Builder getCapabilities() {
            return capabilities != null ? capabilities.toBuilder() : null;
        }

        public final void setCapabilities(Capabilities.BuilderImpl capabilities) {
            this.capabilities = capabilities != null ? capabilities.build() : null;
        }

        @Override
        public final Builder capabilities(Capabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        @Override
        public ConnectionTypeBrief build() {
            return new ConnectionTypeBrief(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
