/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.DataQualityEvaluationRunAdditionalRunOptions;
import software.amazon.awssdk.services.glue.model.DataQualityResultIdListCopier;
import software.amazon.awssdk.services.glue.model.DataSource;
import software.amazon.awssdk.services.glue.model.DataSourceMapCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.RulesetNamesCopier;
import software.amazon.awssdk.services.glue.model.TaskStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDataQualityRulesetEvaluationRunResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetDataQualityRulesetEvaluationRunResponse> {
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RunId").getter(GetDataQualityRulesetEvaluationRunResponse.getter(GetDataQualityRulesetEvaluationRunResponse::runId)).setter(GetDataQualityRulesetEvaluationRunResponse.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()}).build();
    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSource").getter(GetDataQualityRulesetEvaluationRunResponse.getter(GetDataQualityRulesetEvaluationRunResponse::dataSource)).setter(GetDataQualityRulesetEvaluationRunResponse.setter(Builder::dataSource)).constructor(DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(GetDataQualityRulesetEvaluationRunResponse.getter(GetDataQualityRulesetEvaluationRunResponse::role)).setter(GetDataQualityRulesetEvaluationRunResponse.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfWorkers").getter(GetDataQualityRulesetEvaluationRunResponse.getter(GetDataQualityRulesetEvaluationRunResponse::numberOfWorkers)).setter(GetDataQualityRulesetEvaluationRunResponse.setter(Builder::numberOfWorkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Timeout").getter(GetDataQualityRulesetEvaluationRunResponse.getter(GetDataQualityRulesetEvaluationRunResponse::timeout)).setter(GetDataQualityRulesetEvaluationRunResponse.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final SdkField<DataQualityEvaluationRunAdditionalRunOptions> ADDITIONAL_RUN_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdditionalRunOptions").getter(GetDataQualityRulesetEvaluationRunResponse.getter(GetDataQualityRulesetEvaluationRunResponse::additionalRunOptions)).setter(GetDataQualityRulesetEvaluationRunResponse.setter(Builder::additionalRunOptions)).constructor(DataQualityEvaluationRunAdditionalRunOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalRunOptions").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetDataQualityRulesetEvaluationRunResponse.getter(GetDataQualityRulesetEvaluationRunResponse::statusAsString)).setter(GetDataQualityRulesetEvaluationRunResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ERROR_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorString").getter(GetDataQualityRulesetEvaluationRunResponse.getter(GetDataQualityRulesetEvaluationRunResponse::errorString)).setter(GetDataQualityRulesetEvaluationRunResponse.setter(Builder::errorString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorString").build()}).build();
    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedOn").getter(GetDataQualityRulesetEvaluationRunResponse.getter(GetDataQualityRulesetEvaluationRunResponse::startedOn)).setter(GetDataQualityRulesetEvaluationRunResponse.setter(Builder::startedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedOn").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedOn").getter(GetDataQualityRulesetEvaluationRunResponse.getter(GetDataQualityRulesetEvaluationRunResponse::lastModifiedOn)).setter(GetDataQualityRulesetEvaluationRunResponse.setter(Builder::lastModifiedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedOn").build()}).build();
    private static final SdkField<Instant> COMPLETED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletedOn").getter(GetDataQualityRulesetEvaluationRunResponse.getter(GetDataQualityRulesetEvaluationRunResponse::completedOn)).setter(GetDataQualityRulesetEvaluationRunResponse.setter(Builder::completedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedOn").build()}).build();
    private static final SdkField<Integer> EXECUTION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExecutionTime").getter(GetDataQualityRulesetEvaluationRunResponse.getter(GetDataQualityRulesetEvaluationRunResponse::executionTime)).setter(GetDataQualityRulesetEvaluationRunResponse.setter(Builder::executionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTime").build()}).build();
    private static final SdkField<List<String>> RULESET_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RulesetNames").getter(GetDataQualityRulesetEvaluationRunResponse.getter(GetDataQualityRulesetEvaluationRunResponse::rulesetNames)).setter(GetDataQualityRulesetEvaluationRunResponse.setter(Builder::rulesetNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RulesetNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESULT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResultIds").getter(GetDataQualityRulesetEvaluationRunResponse.getter(GetDataQualityRulesetEvaluationRunResponse::resultIds)).setter(GetDataQualityRulesetEvaluationRunResponse.setter(Builder::resultIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, DataSource>> ADDITIONAL_DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AdditionalDataSources").getter(GetDataQualityRulesetEvaluationRunResponse.getter(GetDataQualityRulesetEvaluationRunResponse::additionalDataSources)).setter(GetDataQualityRulesetEvaluationRunResponse.setter(Builder::additionalDataSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalDataSources").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUN_ID_FIELD, DATA_SOURCE_FIELD, ROLE_FIELD, NUMBER_OF_WORKERS_FIELD, TIMEOUT_FIELD, ADDITIONAL_RUN_OPTIONS_FIELD, STATUS_FIELD, ERROR_STRING_FIELD, STARTED_ON_FIELD, LAST_MODIFIED_ON_FIELD, COMPLETED_ON_FIELD, EXECUTION_TIME_FIELD, RULESET_NAMES_FIELD, RESULT_IDS_FIELD, ADDITIONAL_DATA_SOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RunId", RUN_ID_FIELD);
            this.put("DataSource", DATA_SOURCE_FIELD);
            this.put("Role", ROLE_FIELD);
            this.put("NumberOfWorkers", NUMBER_OF_WORKERS_FIELD);
            this.put("Timeout", TIMEOUT_FIELD);
            this.put("AdditionalRunOptions", ADDITIONAL_RUN_OPTIONS_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("ErrorString", ERROR_STRING_FIELD);
            this.put("StartedOn", STARTED_ON_FIELD);
            this.put("LastModifiedOn", LAST_MODIFIED_ON_FIELD);
            this.put("CompletedOn", COMPLETED_ON_FIELD);
            this.put("ExecutionTime", EXECUTION_TIME_FIELD);
            this.put("RulesetNames", RULESET_NAMES_FIELD);
            this.put("ResultIds", RESULT_IDS_FIELD);
            this.put("AdditionalDataSources", ADDITIONAL_DATA_SOURCES_FIELD);
        }
    });
    private final String runId;
    private final DataSource dataSource;
    private final String role;
    private final Integer numberOfWorkers;
    private final Integer timeout;
    private final DataQualityEvaluationRunAdditionalRunOptions additionalRunOptions;
    private final String status;
    private final String errorString;
    private final Instant startedOn;
    private final Instant lastModifiedOn;
    private final Instant completedOn;
    private final Integer executionTime;
    private final List<String> rulesetNames;
    private final List<String> resultIds;
    private final Map<String, DataSource> additionalDataSources;

    private GetDataQualityRulesetEvaluationRunResponse(BuilderImpl builder) {
        super(builder);
        this.runId = builder.runId;
        this.dataSource = builder.dataSource;
        this.role = builder.role;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.timeout = builder.timeout;
        this.additionalRunOptions = builder.additionalRunOptions;
        this.status = builder.status;
        this.errorString = builder.errorString;
        this.startedOn = builder.startedOn;
        this.lastModifiedOn = builder.lastModifiedOn;
        this.completedOn = builder.completedOn;
        this.executionTime = builder.executionTime;
        this.rulesetNames = builder.rulesetNames;
        this.resultIds = builder.resultIds;
        this.additionalDataSources = builder.additionalDataSources;
    }

    public final String runId() {
        return this.runId;
    }

    public final DataSource dataSource() {
        return this.dataSource;
    }

    public final String role() {
        return this.role;
    }

    public final Integer numberOfWorkers() {
        return this.numberOfWorkers;
    }

    public final Integer timeout() {
        return this.timeout;
    }

    public final DataQualityEvaluationRunAdditionalRunOptions additionalRunOptions() {
        return this.additionalRunOptions;
    }

    public final TaskStatusType status() {
        return TaskStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String errorString() {
        return this.errorString;
    }

    public final Instant startedOn() {
        return this.startedOn;
    }

    public final Instant lastModifiedOn() {
        return this.lastModifiedOn;
    }

    public final Instant completedOn() {
        return this.completedOn;
    }

    public final Integer executionTime() {
        return this.executionTime;
    }

    public final boolean hasRulesetNames() {
        return this.rulesetNames != null && !(this.rulesetNames instanceof SdkAutoConstructList);
    }

    public final List<String> rulesetNames() {
        return this.rulesetNames;
    }

    public final boolean hasResultIds() {
        return this.resultIds != null && !(this.resultIds instanceof SdkAutoConstructList);
    }

    public final List<String> resultIds() {
        return this.resultIds;
    }

    public final boolean hasAdditionalDataSources() {
        return this.additionalDataSources != null && !(this.additionalDataSources instanceof SdkAutoConstructMap);
    }

    public final Map<String, DataSource> additionalDataSources() {
        return this.additionalDataSources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalRunOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRulesetNames() ? this.rulesetNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResultIds() ? this.resultIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalDataSources() ? this.additionalDataSources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataQualityRulesetEvaluationRunResponse)) {
            return false;
        }
        GetDataQualityRulesetEvaluationRunResponse other = (GetDataQualityRulesetEvaluationRunResponse)((Object)obj);
        return Objects.equals(this.runId(), other.runId()) && Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.numberOfWorkers(), other.numberOfWorkers()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.additionalRunOptions(), other.additionalRunOptions()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errorString(), other.errorString()) && Objects.equals(this.startedOn(), other.startedOn()) && Objects.equals(this.lastModifiedOn(), other.lastModifiedOn()) && Objects.equals(this.completedOn(), other.completedOn()) && Objects.equals(this.executionTime(), other.executionTime()) && this.hasRulesetNames() == other.hasRulesetNames() && Objects.equals(this.rulesetNames(), other.rulesetNames()) && this.hasResultIds() == other.hasResultIds() && Objects.equals(this.resultIds(), other.resultIds()) && this.hasAdditionalDataSources() == other.hasAdditionalDataSources() && Objects.equals(this.additionalDataSources(), other.additionalDataSources());
    }

    public final String toString() {
        return ToString.builder((String)"GetDataQualityRulesetEvaluationRunResponse").add("RunId", (Object)this.runId()).add("DataSource", (Object)this.dataSource()).add("Role", (Object)this.role()).add("NumberOfWorkers", (Object)this.numberOfWorkers()).add("Timeout", (Object)this.timeout()).add("AdditionalRunOptions", (Object)this.additionalRunOptions()).add("Status", (Object)this.statusAsString()).add("ErrorString", (Object)this.errorString()).add("StartedOn", (Object)this.startedOn()).add("LastModifiedOn", (Object)this.lastModifiedOn()).add("CompletedOn", (Object)this.completedOn()).add("ExecutionTime", (Object)this.executionTime()).add("RulesetNames", this.hasRulesetNames() ? this.rulesetNames() : null).add("ResultIds", this.hasResultIds() ? this.resultIds() : null).add("AdditionalDataSources", this.hasAdditionalDataSources() ? this.additionalDataSources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RunId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "NumberOfWorkers": {
                return Optional.ofNullable(clazz.cast(this.numberOfWorkers()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "AdditionalRunOptions": {
                return Optional.ofNullable(clazz.cast(this.additionalRunOptions()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ErrorString": {
                return Optional.ofNullable(clazz.cast(this.errorString()));
            }
            case "StartedOn": {
                return Optional.ofNullable(clazz.cast(this.startedOn()));
            }
            case "LastModifiedOn": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedOn()));
            }
            case "CompletedOn": {
                return Optional.ofNullable(clazz.cast(this.completedOn()));
            }
            case "ExecutionTime": {
                return Optional.ofNullable(clazz.cast(this.executionTime()));
            }
            case "RulesetNames": {
                return Optional.ofNullable(clazz.cast(this.rulesetNames()));
            }
            case "ResultIds": {
                return Optional.ofNullable(clazz.cast(this.resultIds()));
            }
            case "AdditionalDataSources": {
                return Optional.ofNullable(clazz.cast(this.additionalDataSources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetDataQualityRulesetEvaluationRunResponse, T> g) {
        return obj -> g.apply((GetDataQualityRulesetEvaluationRunResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private String runId;
        private DataSource dataSource;
        private String role;
        private Integer numberOfWorkers;
        private Integer timeout;
        private DataQualityEvaluationRunAdditionalRunOptions additionalRunOptions;
        private String status;
        private String errorString;
        private Instant startedOn;
        private Instant lastModifiedOn;
        private Instant completedOn;
        private Integer executionTime;
        private List<String> rulesetNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> resultIds = DefaultSdkAutoConstructList.getInstance();
        private Map<String, DataSource> additionalDataSources = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataQualityRulesetEvaluationRunResponse model) {
            super(model);
            this.runId(model.runId);
            this.dataSource(model.dataSource);
            this.role(model.role);
            this.numberOfWorkers(model.numberOfWorkers);
            this.timeout(model.timeout);
            this.additionalRunOptions(model.additionalRunOptions);
            this.status(model.status);
            this.errorString(model.errorString);
            this.startedOn(model.startedOn);
            this.lastModifiedOn(model.lastModifiedOn);
            this.completedOn(model.completedOn);
            this.executionTime(model.executionTime);
            this.rulesetNames(model.rulesetNames);
            this.resultIds(model.resultIds);
            this.additionalDataSources(model.additionalDataSources);
        }

        public final String getRunId() {
            return this.runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final DataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final Integer getNumberOfWorkers() {
            return this.numberOfWorkers;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final DataQualityEvaluationRunAdditionalRunOptions.Builder getAdditionalRunOptions() {
            return this.additionalRunOptions != null ? this.additionalRunOptions.toBuilder() : null;
        }

        public final void setAdditionalRunOptions(DataQualityEvaluationRunAdditionalRunOptions.BuilderImpl additionalRunOptions) {
            this.additionalRunOptions = additionalRunOptions != null ? additionalRunOptions.build() : null;
        }

        @Override
        public final Builder additionalRunOptions(DataQualityEvaluationRunAdditionalRunOptions additionalRunOptions) {
            this.additionalRunOptions = additionalRunOptions;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorString() {
            return this.errorString;
        }

        public final void setErrorString(String errorString) {
            this.errorString = errorString;
        }

        @Override
        public final Builder errorString(String errorString) {
            this.errorString = errorString;
            return this;
        }

        public final Instant getStartedOn() {
            return this.startedOn;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        @Override
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final Instant getLastModifiedOn() {
            return this.lastModifiedOn;
        }

        public final void setLastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
        }

        @Override
        public final Builder lastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        public final Instant getCompletedOn() {
            return this.completedOn;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        @Override
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public final Integer getExecutionTime() {
            return this.executionTime;
        }

        public final void setExecutionTime(Integer executionTime) {
            this.executionTime = executionTime;
        }

        @Override
        public final Builder executionTime(Integer executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public final Collection<String> getRulesetNames() {
            if (this.rulesetNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rulesetNames;
        }

        public final void setRulesetNames(Collection<String> rulesetNames) {
            this.rulesetNames = RulesetNamesCopier.copy(rulesetNames);
        }

        @Override
        public final Builder rulesetNames(Collection<String> rulesetNames) {
            this.rulesetNames = RulesetNamesCopier.copy(rulesetNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesetNames(String ... rulesetNames) {
            this.rulesetNames(Arrays.asList(rulesetNames));
            return this;
        }

        public final Collection<String> getResultIds() {
            if (this.resultIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resultIds;
        }

        public final void setResultIds(Collection<String> resultIds) {
            this.resultIds = DataQualityResultIdListCopier.copy(resultIds);
        }

        @Override
        public final Builder resultIds(Collection<String> resultIds) {
            this.resultIds = DataQualityResultIdListCopier.copy(resultIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultIds(String ... resultIds) {
            this.resultIds(Arrays.asList(resultIds));
            return this;
        }

        public final Map<String, DataSource.Builder> getAdditionalDataSources() {
            Map<String, DataSource.Builder> result = DataSourceMapCopier.copyToBuilder(this.additionalDataSources);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAdditionalDataSources(Map<String, DataSource.BuilderImpl> additionalDataSources) {
            this.additionalDataSources = DataSourceMapCopier.copyFromBuilder(additionalDataSources);
        }

        @Override
        public final Builder additionalDataSources(Map<String, DataSource> additionalDataSources) {
            this.additionalDataSources = DataSourceMapCopier.copy(additionalDataSources);
            return this;
        }

        @Override
        public GetDataQualityRulesetEvaluationRunResponse build() {
            return new GetDataQualityRulesetEvaluationRunResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDataQualityRulesetEvaluationRunResponse> {
        public Builder runId(String var1);

        public Builder dataSource(DataSource var1);

        default public Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return this.dataSource((DataSource)((DataSource.Builder)DataSource.builder().applyMutation(dataSource)).build());
        }

        public Builder role(String var1);

        public Builder numberOfWorkers(Integer var1);

        public Builder timeout(Integer var1);

        public Builder additionalRunOptions(DataQualityEvaluationRunAdditionalRunOptions var1);

        default public Builder additionalRunOptions(Consumer<DataQualityEvaluationRunAdditionalRunOptions.Builder> additionalRunOptions) {
            return this.additionalRunOptions((DataQualityEvaluationRunAdditionalRunOptions)((DataQualityEvaluationRunAdditionalRunOptions.Builder)DataQualityEvaluationRunAdditionalRunOptions.builder().applyMutation(additionalRunOptions)).build());
        }

        public Builder status(String var1);

        public Builder status(TaskStatusType var1);

        public Builder errorString(String var1);

        public Builder startedOn(Instant var1);

        public Builder lastModifiedOn(Instant var1);

        public Builder completedOn(Instant var1);

        public Builder executionTime(Integer var1);

        public Builder rulesetNames(Collection<String> var1);

        public Builder rulesetNames(String ... var1);

        public Builder resultIds(Collection<String> var1);

        public Builder resultIds(String ... var1);

        public Builder additionalDataSources(Map<String, DataSource> var1);
    }
}

