/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.ColumnStatisticsData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ColumnStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ColumnStatistics> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColumnName").getter(ColumnStatistics.getter(ColumnStatistics::columnName)).setter(ColumnStatistics.setter(Builder::columnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()}).build();
    private static final SdkField<String> COLUMN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColumnType").getter(ColumnStatistics.getter(ColumnStatistics::columnType)).setter(ColumnStatistics.setter(Builder::columnType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnType").build()}).build();
    private static final SdkField<Instant> ANALYZED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AnalyzedTime").getter(ColumnStatistics.getter(ColumnStatistics::analyzedTime)).setter(ColumnStatistics.setter(Builder::analyzedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyzedTime").build()}).build();
    private static final SdkField<ColumnStatisticsData> STATISTICS_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StatisticsData").getter(ColumnStatistics.getter(ColumnStatistics::statisticsData)).setter(ColumnStatistics.setter(Builder::statisticsData)).constructor(ColumnStatisticsData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatisticsData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD, COLUMN_TYPE_FIELD, ANALYZED_TIME_FIELD, STATISTICS_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ColumnStatistics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String columnName;
    private final String columnType;
    private final Instant analyzedTime;
    private final ColumnStatisticsData statisticsData;

    private ColumnStatistics(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.columnType = builder.columnType;
        this.analyzedTime = builder.analyzedTime;
        this.statisticsData = builder.statisticsData;
    }

    public final String columnName() {
        return this.columnName;
    }

    public final String columnType() {
        return this.columnType;
    }

    public final Instant analyzedTime() {
        return this.analyzedTime;
    }

    public final ColumnStatisticsData statisticsData() {
        return this.statisticsData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.columnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnType());
        hashCode = 31 * hashCode + Objects.hashCode(this.analyzedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticsData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnStatistics)) {
            return false;
        }
        ColumnStatistics other = (ColumnStatistics)obj;
        return Objects.equals(this.columnName(), other.columnName()) && Objects.equals(this.columnType(), other.columnType()) && Objects.equals(this.analyzedTime(), other.analyzedTime()) && Objects.equals(this.statisticsData(), other.statisticsData());
    }

    public final String toString() {
        return ToString.builder((String)"ColumnStatistics").add("ColumnName", (Object)this.columnName()).add("ColumnType", (Object)this.columnType()).add("AnalyzedTime", (Object)this.analyzedTime()).add("StatisticsData", (Object)this.statisticsData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColumnName": {
                return Optional.ofNullable(clazz.cast(this.columnName()));
            }
            case "ColumnType": {
                return Optional.ofNullable(clazz.cast(this.columnType()));
            }
            case "AnalyzedTime": {
                return Optional.ofNullable(clazz.cast(this.analyzedTime()));
            }
            case "StatisticsData": {
                return Optional.ofNullable(clazz.cast(this.statisticsData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ColumnName", COLUMN_NAME_FIELD);
        map.put("ColumnType", COLUMN_TYPE_FIELD);
        map.put("AnalyzedTime", ANALYZED_TIME_FIELD);
        map.put("StatisticsData", STATISTICS_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ColumnStatistics, T> g) {
        return obj -> g.apply((ColumnStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String columnName;
        private String columnType;
        private Instant analyzedTime;
        private ColumnStatisticsData statisticsData;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnStatistics model) {
            this.columnName(model.columnName);
            this.columnType(model.columnType);
            this.analyzedTime(model.analyzedTime);
            this.statisticsData(model.statisticsData);
        }

        public final String getColumnName() {
            return this.columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final String getColumnType() {
            return this.columnType;
        }

        public final void setColumnType(String columnType) {
            this.columnType = columnType;
        }

        @Override
        public final Builder columnType(String columnType) {
            this.columnType = columnType;
            return this;
        }

        public final Instant getAnalyzedTime() {
            return this.analyzedTime;
        }

        public final void setAnalyzedTime(Instant analyzedTime) {
            this.analyzedTime = analyzedTime;
        }

        @Override
        public final Builder analyzedTime(Instant analyzedTime) {
            this.analyzedTime = analyzedTime;
            return this;
        }

        public final ColumnStatisticsData.Builder getStatisticsData() {
            return this.statisticsData != null ? this.statisticsData.toBuilder() : null;
        }

        public final void setStatisticsData(ColumnStatisticsData.BuilderImpl statisticsData) {
            this.statisticsData = statisticsData != null ? statisticsData.build() : null;
        }

        @Override
        public final Builder statisticsData(ColumnStatisticsData statisticsData) {
            this.statisticsData = statisticsData;
            return this;
        }

        public ColumnStatistics build() {
            return new ColumnStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ColumnStatistics> {
        public Builder columnName(String var1);

        public Builder columnType(String var1);

        public Builder analyzedTime(Instant var1);

        public Builder statisticsData(ColumnStatisticsData var1);

        default public Builder statisticsData(Consumer<ColumnStatisticsData.Builder> statisticsData) {
            return this.statisticsData((ColumnStatisticsData)((ColumnStatisticsData.Builder)ColumnStatisticsData.builder().applyMutation(statisticsData)).build());
        }
    }
}

