/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.CrawlerMetrics;
import software.amazon.awssdk.services.glue.model.CrawlerMetricsListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCrawlerMetricsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetCrawlerMetricsResponse> {
    private static final SdkField<List<CrawlerMetrics>> CRAWLER_METRICS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CrawlerMetricsList").getter(GetCrawlerMetricsResponse.getter(GetCrawlerMetricsResponse::crawlerMetricsList)).setter(GetCrawlerMetricsResponse.setter(Builder::crawlerMetricsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlerMetricsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CrawlerMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetCrawlerMetricsResponse.getter(GetCrawlerMetricsResponse::nextToken)).setter(GetCrawlerMetricsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWLER_METRICS_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCrawlerMetricsResponse.memberNameToFieldInitializer();
    private final List<CrawlerMetrics> crawlerMetricsList;
    private final String nextToken;

    private GetCrawlerMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.crawlerMetricsList = builder.crawlerMetricsList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCrawlerMetricsList() {
        return this.crawlerMetricsList != null && !(this.crawlerMetricsList instanceof SdkAutoConstructList);
    }

    public final List<CrawlerMetrics> crawlerMetricsList() {
        return this.crawlerMetricsList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCrawlerMetricsList() ? this.crawlerMetricsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCrawlerMetricsResponse)) {
            return false;
        }
        GetCrawlerMetricsResponse other = (GetCrawlerMetricsResponse)((Object)obj);
        return this.hasCrawlerMetricsList() == other.hasCrawlerMetricsList() && Objects.equals(this.crawlerMetricsList(), other.crawlerMetricsList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetCrawlerMetricsResponse").add("CrawlerMetricsList", this.hasCrawlerMetricsList() ? this.crawlerMetricsList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CrawlerMetricsList": {
                return Optional.ofNullable(clazz.cast(this.crawlerMetricsList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CrawlerMetricsList", CRAWLER_METRICS_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCrawlerMetricsResponse, T> g) {
        return obj -> g.apply((GetCrawlerMetricsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<CrawlerMetrics> crawlerMetricsList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCrawlerMetricsResponse model) {
            super(model);
            this.crawlerMetricsList(model.crawlerMetricsList);
            this.nextToken(model.nextToken);
        }

        public final List<CrawlerMetrics.Builder> getCrawlerMetricsList() {
            List<CrawlerMetrics.Builder> result = CrawlerMetricsListCopier.copyToBuilder(this.crawlerMetricsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCrawlerMetricsList(Collection<CrawlerMetrics.BuilderImpl> crawlerMetricsList) {
            this.crawlerMetricsList = CrawlerMetricsListCopier.copyFromBuilder(crawlerMetricsList);
        }

        @Override
        public final Builder crawlerMetricsList(Collection<CrawlerMetrics> crawlerMetricsList) {
            this.crawlerMetricsList = CrawlerMetricsListCopier.copy(crawlerMetricsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crawlerMetricsList(CrawlerMetrics ... crawlerMetricsList) {
            this.crawlerMetricsList(Arrays.asList(crawlerMetricsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crawlerMetricsList(Consumer<CrawlerMetrics.Builder> ... crawlerMetricsList) {
            this.crawlerMetricsList(Stream.of(crawlerMetricsList).map(c -> (CrawlerMetrics)((CrawlerMetrics.Builder)CrawlerMetrics.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetCrawlerMetricsResponse build() {
            return new GetCrawlerMetricsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCrawlerMetricsResponse> {
        public Builder crawlerMetricsList(Collection<CrawlerMetrics> var1);

        public Builder crawlerMetricsList(CrawlerMetrics ... var1);

        public Builder crawlerMetricsList(Consumer<CrawlerMetrics.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

