/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.Catalog;

final class CatalogListCopier {
    CatalogListCopier() {
    }

    static List<Catalog> copy(Collection<? extends Catalog> catalogListParam) {
        Object list;
        if (catalogListParam == null || catalogListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(catalogListParam.size());
            catalogListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Catalog> copyFromBuilder(Collection<? extends Catalog.Builder> catalogListParam) {
        Object list;
        if (catalogListParam == null || catalogListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(catalogListParam.size());
            catalogListParam.forEach(entry -> {
                Catalog member = entry == null ? null : (Catalog)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Catalog.Builder> copyToBuilder(Collection<? extends Catalog> catalogListParam) {
        Object list;
        if (catalogListParam == null || catalogListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(catalogListParam.size());
            catalogListParam.forEach(entry -> {
                Catalog.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

