/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.ComputeEnvironment;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConnectionRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, GetConnectionRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(GetConnectionRequest.getter(GetConnectionRequest::catalogId)).setter(GetConnectionRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetConnectionRequest.getter(GetConnectionRequest::name)).setter(GetConnectionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Boolean> HIDE_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HidePassword").getter(GetConnectionRequest.getter(GetConnectionRequest::hidePassword)).setter(GetConnectionRequest.setter(Builder::hidePassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HidePassword").build()}).build();
    private static final SdkField<String> APPLY_OVERRIDE_FOR_COMPUTE_ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplyOverrideForComputeEnvironment").getter(GetConnectionRequest.getter(GetConnectionRequest::applyOverrideForComputeEnvironmentAsString)).setter(GetConnectionRequest.setter(Builder::applyOverrideForComputeEnvironment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyOverrideForComputeEnvironment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, NAME_FIELD, HIDE_PASSWORD_FIELD, APPLY_OVERRIDE_FOR_COMPUTE_ENVIRONMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CatalogId", CATALOG_ID_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("HidePassword", HIDE_PASSWORD_FIELD);
            this.put("ApplyOverrideForComputeEnvironment", APPLY_OVERRIDE_FOR_COMPUTE_ENVIRONMENT_FIELD);
        }
    });
    private final String catalogId;
    private final String name;
    private final Boolean hidePassword;
    private final String applyOverrideForComputeEnvironment;

    private GetConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.name = builder.name;
        this.hidePassword = builder.hidePassword;
        this.applyOverrideForComputeEnvironment = builder.applyOverrideForComputeEnvironment;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String name() {
        return this.name;
    }

    public final Boolean hidePassword() {
        return this.hidePassword;
    }

    public final ComputeEnvironment applyOverrideForComputeEnvironment() {
        return ComputeEnvironment.fromValue(this.applyOverrideForComputeEnvironment);
    }

    public final String applyOverrideForComputeEnvironmentAsString() {
        return this.applyOverrideForComputeEnvironment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hidePassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyOverrideForComputeEnvironmentAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectionRequest)) {
            return false;
        }
        GetConnectionRequest other = (GetConnectionRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.hidePassword(), other.hidePassword()) && Objects.equals(this.applyOverrideForComputeEnvironmentAsString(), other.applyOverrideForComputeEnvironmentAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetConnectionRequest").add("CatalogId", (Object)this.catalogId()).add("Name", (Object)this.name()).add("HidePassword", (Object)this.hidePassword()).add("ApplyOverrideForComputeEnvironment", (Object)this.applyOverrideForComputeEnvironmentAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "HidePassword": {
                return Optional.ofNullable(clazz.cast(this.hidePassword()));
            }
            case "ApplyOverrideForComputeEnvironment": {
                return Optional.ofNullable(clazz.cast(this.applyOverrideForComputeEnvironmentAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetConnectionRequest, T> g) {
        return obj -> g.apply((GetConnectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String name;
        private Boolean hidePassword;
        private String applyOverrideForComputeEnvironment;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectionRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.name(model.name);
            this.hidePassword(model.hidePassword);
            this.applyOverrideForComputeEnvironment(model.applyOverrideForComputeEnvironment);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getHidePassword() {
            return this.hidePassword;
        }

        public final void setHidePassword(Boolean hidePassword) {
            this.hidePassword = hidePassword;
        }

        @Override
        public final Builder hidePassword(Boolean hidePassword) {
            this.hidePassword = hidePassword;
            return this;
        }

        public final String getApplyOverrideForComputeEnvironment() {
            return this.applyOverrideForComputeEnvironment;
        }

        public final void setApplyOverrideForComputeEnvironment(String applyOverrideForComputeEnvironment) {
            this.applyOverrideForComputeEnvironment = applyOverrideForComputeEnvironment;
        }

        @Override
        public final Builder applyOverrideForComputeEnvironment(String applyOverrideForComputeEnvironment) {
            this.applyOverrideForComputeEnvironment = applyOverrideForComputeEnvironment;
            return this;
        }

        @Override
        public final Builder applyOverrideForComputeEnvironment(ComputeEnvironment applyOverrideForComputeEnvironment) {
            this.applyOverrideForComputeEnvironment(applyOverrideForComputeEnvironment == null ? null : applyOverrideForComputeEnvironment.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetConnectionRequest build() {
            return new GetConnectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConnectionRequest> {
        public Builder catalogId(String var1);

        public Builder name(String var1);

        public Builder hidePassword(Boolean var1);

        public Builder applyOverrideForComputeEnvironment(String var1);

        public Builder applyOverrideForComputeEnvironment(ComputeEnvironment var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

