/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.CatalogProperties;
import software.amazon.awssdk.services.glue.model.FederatedCatalog;
import software.amazon.awssdk.services.glue.model.ParametersMapCopier;
import software.amazon.awssdk.services.glue.model.PrincipalPermissions;
import software.amazon.awssdk.services.glue.model.PrincipalPermissionsListCopier;
import software.amazon.awssdk.services.glue.model.TargetRedshiftCatalog;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CatalogInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CatalogInput> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CatalogInput.getter(CatalogInput::description)).setter(CatalogInput.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<FederatedCatalog> FEDERATED_CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FederatedCatalog").getter(CatalogInput.getter(CatalogInput::federatedCatalog)).setter(CatalogInput.setter(Builder::federatedCatalog)).constructor(FederatedCatalog::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FederatedCatalog").build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(CatalogInput.getter(CatalogInput::parameters)).setter(CatalogInput.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<TargetRedshiftCatalog> TARGET_REDSHIFT_CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetRedshiftCatalog").getter(CatalogInput.getter(CatalogInput::targetRedshiftCatalog)).setter(CatalogInput.setter(Builder::targetRedshiftCatalog)).constructor(TargetRedshiftCatalog::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetRedshiftCatalog").build()}).build();
    private static final SdkField<CatalogProperties> CATALOG_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CatalogProperties").getter(CatalogInput.getter(CatalogInput::catalogProperties)).setter(CatalogInput.setter(Builder::catalogProperties)).constructor(CatalogProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogProperties").build()}).build();
    private static final SdkField<List<PrincipalPermissions>> CREATE_TABLE_DEFAULT_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CreateTableDefaultPermissions").getter(CatalogInput.getter(CatalogInput::createTableDefaultPermissions)).setter(CatalogInput.setter(Builder::createTableDefaultPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTableDefaultPermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrincipalPermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PrincipalPermissions>> CREATE_DATABASE_DEFAULT_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CreateDatabaseDefaultPermissions").getter(CatalogInput.getter(CatalogInput::createDatabaseDefaultPermissions)).setter(CatalogInput.setter(Builder::createDatabaseDefaultPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDatabaseDefaultPermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrincipalPermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, FEDERATED_CATALOG_FIELD, PARAMETERS_FIELD, TARGET_REDSHIFT_CATALOG_FIELD, CATALOG_PROPERTIES_FIELD, CREATE_TABLE_DEFAULT_PERMISSIONS_FIELD, CREATE_DATABASE_DEFAULT_PERMISSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Description", DESCRIPTION_FIELD);
            this.put("FederatedCatalog", FEDERATED_CATALOG_FIELD);
            this.put("Parameters", PARAMETERS_FIELD);
            this.put("TargetRedshiftCatalog", TARGET_REDSHIFT_CATALOG_FIELD);
            this.put("CatalogProperties", CATALOG_PROPERTIES_FIELD);
            this.put("CreateTableDefaultPermissions", CREATE_TABLE_DEFAULT_PERMISSIONS_FIELD);
            this.put("CreateDatabaseDefaultPermissions", CREATE_DATABASE_DEFAULT_PERMISSIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String description;
    private final FederatedCatalog federatedCatalog;
    private final Map<String, String> parameters;
    private final TargetRedshiftCatalog targetRedshiftCatalog;
    private final CatalogProperties catalogProperties;
    private final List<PrincipalPermissions> createTableDefaultPermissions;
    private final List<PrincipalPermissions> createDatabaseDefaultPermissions;

    private CatalogInput(BuilderImpl builder) {
        this.description = builder.description;
        this.federatedCatalog = builder.federatedCatalog;
        this.parameters = builder.parameters;
        this.targetRedshiftCatalog = builder.targetRedshiftCatalog;
        this.catalogProperties = builder.catalogProperties;
        this.createTableDefaultPermissions = builder.createTableDefaultPermissions;
        this.createDatabaseDefaultPermissions = builder.createDatabaseDefaultPermissions;
    }

    public final String description() {
        return this.description;
    }

    public final FederatedCatalog federatedCatalog() {
        return this.federatedCatalog;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> parameters() {
        return this.parameters;
    }

    public final TargetRedshiftCatalog targetRedshiftCatalog() {
        return this.targetRedshiftCatalog;
    }

    public final CatalogProperties catalogProperties() {
        return this.catalogProperties;
    }

    public final boolean hasCreateTableDefaultPermissions() {
        return this.createTableDefaultPermissions != null && !(this.createTableDefaultPermissions instanceof SdkAutoConstructList);
    }

    public final List<PrincipalPermissions> createTableDefaultPermissions() {
        return this.createTableDefaultPermissions;
    }

    public final boolean hasCreateDatabaseDefaultPermissions() {
        return this.createDatabaseDefaultPermissions != null && !(this.createDatabaseDefaultPermissions instanceof SdkAutoConstructList);
    }

    public final List<PrincipalPermissions> createDatabaseDefaultPermissions() {
        return this.createDatabaseDefaultPermissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.federatedCatalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetRedshiftCatalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCreateTableDefaultPermissions() ? this.createTableDefaultPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCreateDatabaseDefaultPermissions() ? this.createDatabaseDefaultPermissions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogInput)) {
            return false;
        }
        CatalogInput other = (CatalogInput)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.federatedCatalog(), other.federatedCatalog()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.targetRedshiftCatalog(), other.targetRedshiftCatalog()) && Objects.equals(this.catalogProperties(), other.catalogProperties()) && this.hasCreateTableDefaultPermissions() == other.hasCreateTableDefaultPermissions() && Objects.equals(this.createTableDefaultPermissions(), other.createTableDefaultPermissions()) && this.hasCreateDatabaseDefaultPermissions() == other.hasCreateDatabaseDefaultPermissions() && Objects.equals(this.createDatabaseDefaultPermissions(), other.createDatabaseDefaultPermissions());
    }

    public final String toString() {
        return ToString.builder((String)"CatalogInput").add("Description", (Object)this.description()).add("FederatedCatalog", (Object)this.federatedCatalog()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("TargetRedshiftCatalog", (Object)this.targetRedshiftCatalog()).add("CatalogProperties", (Object)this.catalogProperties()).add("CreateTableDefaultPermissions", this.hasCreateTableDefaultPermissions() ? this.createTableDefaultPermissions() : null).add("CreateDatabaseDefaultPermissions", this.hasCreateDatabaseDefaultPermissions() ? this.createDatabaseDefaultPermissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "FederatedCatalog": {
                return Optional.ofNullable(clazz.cast(this.federatedCatalog()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "TargetRedshiftCatalog": {
                return Optional.ofNullable(clazz.cast(this.targetRedshiftCatalog()));
            }
            case "CatalogProperties": {
                return Optional.ofNullable(clazz.cast(this.catalogProperties()));
            }
            case "CreateTableDefaultPermissions": {
                return Optional.ofNullable(clazz.cast(this.createTableDefaultPermissions()));
            }
            case "CreateDatabaseDefaultPermissions": {
                return Optional.ofNullable(clazz.cast(this.createDatabaseDefaultPermissions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CatalogInput, T> g) {
        return obj -> g.apply((CatalogInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private FederatedCatalog federatedCatalog;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();
        private TargetRedshiftCatalog targetRedshiftCatalog;
        private CatalogProperties catalogProperties;
        private List<PrincipalPermissions> createTableDefaultPermissions = DefaultSdkAutoConstructList.getInstance();
        private List<PrincipalPermissions> createDatabaseDefaultPermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CatalogInput model) {
            this.description(model.description);
            this.federatedCatalog(model.federatedCatalog);
            this.parameters(model.parameters);
            this.targetRedshiftCatalog(model.targetRedshiftCatalog);
            this.catalogProperties(model.catalogProperties);
            this.createTableDefaultPermissions(model.createTableDefaultPermissions);
            this.createDatabaseDefaultPermissions(model.createDatabaseDefaultPermissions);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final FederatedCatalog.Builder getFederatedCatalog() {
            return this.federatedCatalog != null ? this.federatedCatalog.toBuilder() : null;
        }

        public final void setFederatedCatalog(FederatedCatalog.BuilderImpl federatedCatalog) {
            this.federatedCatalog = federatedCatalog != null ? federatedCatalog.build() : null;
        }

        @Override
        public final Builder federatedCatalog(FederatedCatalog federatedCatalog) {
            this.federatedCatalog = federatedCatalog;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final TargetRedshiftCatalog.Builder getTargetRedshiftCatalog() {
            return this.targetRedshiftCatalog != null ? this.targetRedshiftCatalog.toBuilder() : null;
        }

        public final void setTargetRedshiftCatalog(TargetRedshiftCatalog.BuilderImpl targetRedshiftCatalog) {
            this.targetRedshiftCatalog = targetRedshiftCatalog != null ? targetRedshiftCatalog.build() : null;
        }

        @Override
        public final Builder targetRedshiftCatalog(TargetRedshiftCatalog targetRedshiftCatalog) {
            this.targetRedshiftCatalog = targetRedshiftCatalog;
            return this;
        }

        public final CatalogProperties.Builder getCatalogProperties() {
            return this.catalogProperties != null ? this.catalogProperties.toBuilder() : null;
        }

        public final void setCatalogProperties(CatalogProperties.BuilderImpl catalogProperties) {
            this.catalogProperties = catalogProperties != null ? catalogProperties.build() : null;
        }

        @Override
        public final Builder catalogProperties(CatalogProperties catalogProperties) {
            this.catalogProperties = catalogProperties;
            return this;
        }

        public final List<PrincipalPermissions.Builder> getCreateTableDefaultPermissions() {
            List<PrincipalPermissions.Builder> result = PrincipalPermissionsListCopier.copyToBuilder(this.createTableDefaultPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCreateTableDefaultPermissions(Collection<PrincipalPermissions.BuilderImpl> createTableDefaultPermissions) {
            this.createTableDefaultPermissions = PrincipalPermissionsListCopier.copyFromBuilder(createTableDefaultPermissions);
        }

        @Override
        public final Builder createTableDefaultPermissions(Collection<PrincipalPermissions> createTableDefaultPermissions) {
            this.createTableDefaultPermissions = PrincipalPermissionsListCopier.copy(createTableDefaultPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createTableDefaultPermissions(PrincipalPermissions ... createTableDefaultPermissions) {
            this.createTableDefaultPermissions(Arrays.asList(createTableDefaultPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createTableDefaultPermissions(Consumer<PrincipalPermissions.Builder> ... createTableDefaultPermissions) {
            this.createTableDefaultPermissions(Stream.of(createTableDefaultPermissions).map(c -> (PrincipalPermissions)((PrincipalPermissions.Builder)PrincipalPermissions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PrincipalPermissions.Builder> getCreateDatabaseDefaultPermissions() {
            List<PrincipalPermissions.Builder> result = PrincipalPermissionsListCopier.copyToBuilder(this.createDatabaseDefaultPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCreateDatabaseDefaultPermissions(Collection<PrincipalPermissions.BuilderImpl> createDatabaseDefaultPermissions) {
            this.createDatabaseDefaultPermissions = PrincipalPermissionsListCopier.copyFromBuilder(createDatabaseDefaultPermissions);
        }

        @Override
        public final Builder createDatabaseDefaultPermissions(Collection<PrincipalPermissions> createDatabaseDefaultPermissions) {
            this.createDatabaseDefaultPermissions = PrincipalPermissionsListCopier.copy(createDatabaseDefaultPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createDatabaseDefaultPermissions(PrincipalPermissions ... createDatabaseDefaultPermissions) {
            this.createDatabaseDefaultPermissions(Arrays.asList(createDatabaseDefaultPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createDatabaseDefaultPermissions(Consumer<PrincipalPermissions.Builder> ... createDatabaseDefaultPermissions) {
            this.createDatabaseDefaultPermissions(Stream.of(createDatabaseDefaultPermissions).map(c -> (PrincipalPermissions)((PrincipalPermissions.Builder)PrincipalPermissions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CatalogInput build() {
            return new CatalogInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CatalogInput> {
        public Builder description(String var1);

        public Builder federatedCatalog(FederatedCatalog var1);

        default public Builder federatedCatalog(Consumer<FederatedCatalog.Builder> federatedCatalog) {
            return this.federatedCatalog((FederatedCatalog)((FederatedCatalog.Builder)FederatedCatalog.builder().applyMutation(federatedCatalog)).build());
        }

        public Builder parameters(Map<String, String> var1);

        public Builder targetRedshiftCatalog(TargetRedshiftCatalog var1);

        default public Builder targetRedshiftCatalog(Consumer<TargetRedshiftCatalog.Builder> targetRedshiftCatalog) {
            return this.targetRedshiftCatalog((TargetRedshiftCatalog)((TargetRedshiftCatalog.Builder)TargetRedshiftCatalog.builder().applyMutation(targetRedshiftCatalog)).build());
        }

        public Builder catalogProperties(CatalogProperties var1);

        default public Builder catalogProperties(Consumer<CatalogProperties.Builder> catalogProperties) {
            return this.catalogProperties((CatalogProperties)((CatalogProperties.Builder)CatalogProperties.builder().applyMutation(catalogProperties)).build());
        }

        public Builder createTableDefaultPermissions(Collection<PrincipalPermissions> var1);

        public Builder createTableDefaultPermissions(PrincipalPermissions ... var1);

        public Builder createTableDefaultPermissions(Consumer<PrincipalPermissions.Builder> ... var1);

        public Builder createDatabaseDefaultPermissions(Collection<PrincipalPermissions> var1);

        public Builder createDatabaseDefaultPermissions(PrincipalPermissions ... var1);

        public Builder createDatabaseDefaultPermissions(Consumer<PrincipalPermissions.Builder> ... var1);
    }
}

