/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.TimestampFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataQualityStatisticAnnotationsRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, ListDataQualityStatisticAnnotationsRequest> {
    private static final SdkField<String> STATISTIC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatisticId").getter(ListDataQualityStatisticAnnotationsRequest.getter(ListDataQualityStatisticAnnotationsRequest::statisticId)).setter(ListDataQualityStatisticAnnotationsRequest.setter(Builder::statisticId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatisticId").build()}).build();
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileId").getter(ListDataQualityStatisticAnnotationsRequest.getter(ListDataQualityStatisticAnnotationsRequest::profileId)).setter(ListDataQualityStatisticAnnotationsRequest.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()}).build();
    private static final SdkField<TimestampFilter> TIMESTAMP_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimestampFilter").getter(ListDataQualityStatisticAnnotationsRequest.getter(ListDataQualityStatisticAnnotationsRequest::timestampFilter)).setter(ListDataQualityStatisticAnnotationsRequest.setter(Builder::timestampFilter)).constructor(TimestampFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampFilter").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListDataQualityStatisticAnnotationsRequest.getter(ListDataQualityStatisticAnnotationsRequest::maxResults)).setter(ListDataQualityStatisticAnnotationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDataQualityStatisticAnnotationsRequest.getter(ListDataQualityStatisticAnnotationsRequest::nextToken)).setter(ListDataQualityStatisticAnnotationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATISTIC_ID_FIELD, PROFILE_ID_FIELD, TIMESTAMP_FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StatisticId", STATISTIC_ID_FIELD);
            this.put("ProfileId", PROFILE_ID_FIELD);
            this.put("TimestampFilter", TIMESTAMP_FILTER_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String statisticId;
    private final String profileId;
    private final TimestampFilter timestampFilter;
    private final Integer maxResults;
    private final String nextToken;

    private ListDataQualityStatisticAnnotationsRequest(BuilderImpl builder) {
        super(builder);
        this.statisticId = builder.statisticId;
        this.profileId = builder.profileId;
        this.timestampFilter = builder.timestampFilter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String statisticId() {
        return this.statisticId;
    }

    public final String profileId() {
        return this.profileId;
    }

    public final TimestampFilter timestampFilter() {
        return this.timestampFilter;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticId());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataQualityStatisticAnnotationsRequest)) {
            return false;
        }
        ListDataQualityStatisticAnnotationsRequest other = (ListDataQualityStatisticAnnotationsRequest)((Object)obj);
        return Objects.equals(this.statisticId(), other.statisticId()) && Objects.equals(this.profileId(), other.profileId()) && Objects.equals(this.timestampFilter(), other.timestampFilter()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDataQualityStatisticAnnotationsRequest").add("StatisticId", (Object)this.statisticId()).add("ProfileId", (Object)this.profileId()).add("TimestampFilter", (Object)this.timestampFilter()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StatisticId": {
                return Optional.ofNullable(clazz.cast(this.statisticId()));
            }
            case "ProfileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
            case "TimestampFilter": {
                return Optional.ofNullable(clazz.cast(this.timestampFilter()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListDataQualityStatisticAnnotationsRequest, T> g) {
        return obj -> g.apply((ListDataQualityStatisticAnnotationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String statisticId;
        private String profileId;
        private TimestampFilter timestampFilter;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataQualityStatisticAnnotationsRequest model) {
            super(model);
            this.statisticId(model.statisticId);
            this.profileId(model.profileId);
            this.timestampFilter(model.timestampFilter);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getStatisticId() {
            return this.statisticId;
        }

        public final void setStatisticId(String statisticId) {
            this.statisticId = statisticId;
        }

        @Override
        public final Builder statisticId(String statisticId) {
            this.statisticId = statisticId;
            return this;
        }

        public final String getProfileId() {
            return this.profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final TimestampFilter.Builder getTimestampFilter() {
            return this.timestampFilter != null ? this.timestampFilter.toBuilder() : null;
        }

        public final void setTimestampFilter(TimestampFilter.BuilderImpl timestampFilter) {
            this.timestampFilter = timestampFilter != null ? timestampFilter.build() : null;
        }

        @Override
        public final Builder timestampFilter(TimestampFilter timestampFilter) {
            this.timestampFilter = timestampFilter;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDataQualityStatisticAnnotationsRequest build() {
            return new ListDataQualityStatisticAnnotationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataQualityStatisticAnnotationsRequest> {
        public Builder statisticId(String var1);

        public Builder profileId(String var1);

        public Builder timestampFilter(TimestampFilter var1);

        default public Builder timestampFilter(Consumer<TimestampFilter.Builder> timestampFilter) {
            return this.timestampFilter((TimestampFilter)((TimestampFilter.Builder)TimestampFilter.builder().applyMutation(timestampFilter)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

