/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.ErrorDetail;
import software.amazon.awssdk.services.glue.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PartitionError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PartitionError> {
    private static final SdkField<List<String>> PARTITION_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PartitionValues").getter(PartitionError.getter(PartitionError::partitionValues)).setter(PartitionError.setter(Builder::partitionValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ErrorDetail> ERROR_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ErrorDetail").getter(PartitionError.getter(PartitionError::errorDetail)).setter(PartitionError.setter(Builder::errorDetail)).constructor(ErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTITION_VALUES_FIELD, ERROR_DETAIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PartitionValues", PARTITION_VALUES_FIELD);
            this.put("ErrorDetail", ERROR_DETAIL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> partitionValues;
    private final ErrorDetail errorDetail;

    private PartitionError(BuilderImpl builder) {
        this.partitionValues = builder.partitionValues;
        this.errorDetail = builder.errorDetail;
    }

    public final boolean hasPartitionValues() {
        return this.partitionValues != null && !(this.partitionValues instanceof SdkAutoConstructList);
    }

    public final List<String> partitionValues() {
        return this.partitionValues;
    }

    public final ErrorDetail errorDetail() {
        return this.errorDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitionValues() ? this.partitionValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDetail());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartitionError)) {
            return false;
        }
        PartitionError other = (PartitionError)obj;
        return this.hasPartitionValues() == other.hasPartitionValues() && Objects.equals(this.partitionValues(), other.partitionValues()) && Objects.equals(this.errorDetail(), other.errorDetail());
    }

    public final String toString() {
        return ToString.builder((String)"PartitionError").add("PartitionValues", this.hasPartitionValues() ? this.partitionValues() : null).add("ErrorDetail", (Object)this.errorDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PartitionValues": {
                return Optional.ofNullable(clazz.cast(this.partitionValues()));
            }
            case "ErrorDetail": {
                return Optional.ofNullable(clazz.cast(this.errorDetail()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PartitionError, T> g) {
        return obj -> g.apply((PartitionError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> partitionValues = DefaultSdkAutoConstructList.getInstance();
        private ErrorDetail errorDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(PartitionError model) {
            this.partitionValues(model.partitionValues);
            this.errorDetail(model.errorDetail);
        }

        public final Collection<String> getPartitionValues() {
            if (this.partitionValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.partitionValues;
        }

        public final void setPartitionValues(Collection<String> partitionValues) {
            this.partitionValues = ValueStringListCopier.copy(partitionValues);
        }

        @Override
        public final Builder partitionValues(Collection<String> partitionValues) {
            this.partitionValues = ValueStringListCopier.copy(partitionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionValues(String ... partitionValues) {
            this.partitionValues(Arrays.asList(partitionValues));
            return this;
        }

        public final ErrorDetail.Builder getErrorDetail() {
            return this.errorDetail != null ? this.errorDetail.toBuilder() : null;
        }

        public final void setErrorDetail(ErrorDetail.BuilderImpl errorDetail) {
            this.errorDetail = errorDetail != null ? errorDetail.build() : null;
        }

        @Override
        public final Builder errorDetail(ErrorDetail errorDetail) {
            this.errorDetail = errorDetail;
            return this;
        }

        public PartitionError build() {
            return new PartitionError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PartitionError> {
        public Builder partitionValues(Collection<String> var1);

        public Builder partitionValues(String ... var1);

        public Builder errorDetail(ErrorDetail var1);

        default public Builder errorDetail(Consumer<ErrorDetail.Builder> errorDetail) {
            return this.errorDetail((ErrorDetail)((ErrorDetail.Builder)ErrorDetail.builder().applyMutation(errorDetail)).build());
        }
    }
}

