/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.InclusionAnnotationValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimestampedInclusionAnnotation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimestampedInclusionAnnotation> {
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(TimestampedInclusionAnnotation.getter(TimestampedInclusionAnnotation::valueAsString)).setter(TimestampedInclusionAnnotation.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedOn").getter(TimestampedInclusionAnnotation.getter(TimestampedInclusionAnnotation::lastModifiedOn)).setter(TimestampedInclusionAnnotation.setter(Builder::lastModifiedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedOn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, LAST_MODIFIED_ON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Value", VALUE_FIELD);
            this.put("LastModifiedOn", LAST_MODIFIED_ON_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String value;
    private final Instant lastModifiedOn;

    private TimestampedInclusionAnnotation(BuilderImpl builder) {
        this.value = builder.value;
        this.lastModifiedOn = builder.lastModifiedOn;
    }

    public final InclusionAnnotationValue value() {
        return InclusionAnnotationValue.fromValue(this.value);
    }

    public final String valueAsString() {
        return this.value;
    }

    public final Instant lastModifiedOn() {
        return this.lastModifiedOn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.valueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedOn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimestampedInclusionAnnotation)) {
            return false;
        }
        TimestampedInclusionAnnotation other = (TimestampedInclusionAnnotation)obj;
        return Objects.equals(this.valueAsString(), other.valueAsString()) && Objects.equals(this.lastModifiedOn(), other.lastModifiedOn());
    }

    public final String toString() {
        return ToString.builder((String)"TimestampedInclusionAnnotation").add("Value", (Object)this.valueAsString()).add("LastModifiedOn", (Object)this.lastModifiedOn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.valueAsString()));
            }
            case "LastModifiedOn": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedOn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TimestampedInclusionAnnotation, T> g) {
        return obj -> g.apply((TimestampedInclusionAnnotation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String value;
        private Instant lastModifiedOn;

        private BuilderImpl() {
        }

        private BuilderImpl(TimestampedInclusionAnnotation model) {
            this.value(model.value);
            this.lastModifiedOn(model.lastModifiedOn);
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public final Builder value(InclusionAnnotationValue value) {
            this.value(value == null ? null : value.toString());
            return this;
        }

        public final Instant getLastModifiedOn() {
            return this.lastModifiedOn;
        }

        public final void setLastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
        }

        @Override
        public final Builder lastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        public TimestampedInclusionAnnotation build() {
            return new TimestampedInclusionAnnotation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimestampedInclusionAnnotation> {
        public Builder value(String var1);

        public Builder value(InclusionAnnotationValue var1);

        public Builder lastModifiedOn(Instant var1);
    }
}

